// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15540 $
//  $Date: 2007-06-19 15:37:31 -0700 (Tue, 19 Jun 2007) $
//  $Author: chu $

#include "repeat.h"

#include "after_opts.h"
#include "files_paths.h"
#include "random_numbers.h"

#include <utility/io/izstream.hh>

#include <ObjexxFCL/string.functions.hh>

#include <cassert>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>

using namespace std;
using namespace files_paths;

int IS_REPEAT_RUN = 0;
int OUTPUT_REPEAT = 0;

std::string repeat_output_fname;

int repeat_ran3_seed = 0;
int repeat_ran3_iter = 0;

vector< int > repeat_seeds;
vector< int > repeat_iters;
vector< string > repeat_names;


void
repeat_init()
{
	//cout << "repeat.cc: checking for REPEAT RUN" << endl;
	if ( truefalseoption( "repeatin" ) ) {
		cout << "repeat.cc: doing repeat run!!" << endl;
		std::string const opt( "repeatin" );
		std::string const def( "repeat.input" );
		std::string buf;
		stringafteroption( opt, def, buf );
		//cout << buf << endl;
		utility::io::izstream infile( buf );
		int seed,iter;
		string name;
		while ( true ) {
			if ( !( infile >> name && infile >> seed && infile >> iter ) ) {
				//cout << "repeatin: Problem with input file " << buf << endl;
				break;
			}
			std::string line;
			infile.getline( line );
			//cout << name << ' ' << seed << ' ' << iter << endl;
			repeat_names.push_back( name );
			repeat_seeds.push_back( seed );
			repeat_iters.push_back( iter );
		}
		IS_REPEAT_RUN = 1;
		infile.close();
		infile.clear();
	}

	if ( truefalseoption( "repeatout" ) ) {
		OUTPUT_REPEAT = 1;
		std::string const opt( "repeatout" );
		std::string const def( "repeat.output" );
		stringafteroption( opt, def, repeat_output_fname );
		cout << "repeat.cc: repeat output file= " << repeat_output_fname << endl;
	}
}


void
repeat_capture_ran3_seed( int const seed )
{
	repeat_ran3_seed = seed;
}


void
repeat_count_ran3()
{
	++repeat_ran3_iter;
}


void
repeat_begin_iter( int const iter )
{
  if ( IS_REPEAT_RUN & (int)repeat_names.size() >= iter) {
    cout << "repeat.cc: This is a repeat of run '" << repeat_names[iter-1]
	 << "' seed = " << repeat_seeds[iter-1]
	 << " ran3 iter = " << repeat_iters[iter-1] << "!!!!!" << endl;
    // this is where the action is...
    ran3_seed(repeat_seeds[iter-1]);
    for ( int ii = 0; ii < repeat_iters[iter-1]; ++ii )
      ran3();
    assert(repeat_seeds[iter-1]==repeat_ran3_seed);
    assert(repeat_iters[iter-1]==repeat_ran3_iter);
  }
  if ( OUTPUT_REPEAT ) {
    //cout << "repeat.cc: otuput repeat begin iter" << endl;
    while ( (int)repeat_names.size() < iter ) {
      ostringstream name;
      name << code << protein_name << lead_zero_string_of( iter, NUMBER_MAX_LENGTH );
      repeat_names.push_back(name.str());
      repeat_seeds.push_back(repeat_ran3_seed);
      repeat_iters.push_back(repeat_ran3_iter);
    }
    repeat_seeds[iter-1] = repeat_ran3_seed;
    repeat_iters[iter-1] = repeat_ran3_iter;
  }
}


void
repeat_end_iter( int const iter, int const accepted )
{
	if ( OUTPUT_REPEAT && accepted ) {
		//cout << "repeat.cc: output repeat " << iter << endl;
		repeat_seeds[iter-1] = repeat_ran3_seed;
		assert(repeat_names.size()==repeat_seeds.size());
		assert(repeat_names.size()==repeat_iters.size());
		assert(repeat_iters.size()==repeat_seeds.size());
		//cout << "repeat.cc: writting to " << repeat_output_fname << endl;

		std::string const tempfile( repeat_names[iter-1] + ".rosetta.tempfile" );
		ofstream out( tempfile.c_str(), std::ios_base::out|std::ios_base::app );
		out << repeat_names[iter-1] << '\t' << repeat_seeds[iter-1]
		 << '\t' << repeat_iters[iter-1] << endl;
		out.close();
		out.clear();

		std::string command( "cat " + tempfile + " >> " + repeat_output_fname );
		std::system( command.c_str() );
		command = "rm -f " + tempfile;
		std::system( command.c_str() );
	}
}


void
repeat_final()
{
	if ( OUTPUT_REPEAT ) {
		cout << "repeat.cc: repeat information logged to file "
		 <<  repeat_output_fname << endl;
	}
}
