// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32323 $
//  $Date: 2009-08-25 13:16:13 -0700 (Tue, 25 Aug 2009) $
//  $Author: johnk $


// Rosetta Headers
#include "rotamer_trial_energies.h"
#include "after_opts.h"
#include "design.h"
#include "files_paths.h"
#include "ligand_ns.h"
#include "param.h"
#include "param_pack.h"
#include "water_ns.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// C++ Headers
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>

// Using
using namespace param;


namespace rotamer_trial_energies {

	// jk A rotamer trials output object (class description below)
	rot_ene_output opte_output;

//bk energy arrays that describe the energy of each sequence position
//bk when the current rotamer has been removed

namespace minus_energies {
	FArray1D_float atrenergy_minus_current( MAX_RES() );
	FArray1D_float repenergy_minus_current( MAX_RES() );
	FArray1D_float resenergy_minus_current( MAX_RES() );
	FArray1D_float solenergy_minus_current( MAX_RES() );
	FArray1D_float gb_elecenergy_minus_current( MAX_RES() );
	FArray1D_float h2oenergy_minus_current( MAX_RES() );
	FArray1D_float h2ohbenergy_minus_current( MAX_RES() );
	FArray1D_float pair_energy_minus_current( MAX_RES() );
	FArray1D_float plane_energy_minus_current( MAX_RES() );
	FArray1D_float hbenergy_minus_current( MAX_RES() );
	FArray1D_float cstenergy_minus_current( MAX_RES() );
}


//bk energy arrays that describe the energy of each sequence position
//bk with the trial rotamer in place

namespace trial_energies {
	FArray1D_float atrenergy_trial( MAX_RES() );
	FArray1D_float repenergy_trial( MAX_RES() );
	FArray1D_float resenergy_trial( MAX_RES() );
	FArray1D_float solenergy_trial( MAX_RES() );
	FArray1D_float gb_elecenergy_trial( MAX_RES() );
	FArray1D_float h2oenergy_trial( MAX_RES() );
	FArray1D_float h2ohbenergy_trial( MAX_RES() );
	FArray1D_float pair_energy_trial( MAX_RES() );
	FArray1D_float plane_energy_trial( MAX_RES() );
	FArray1D_float atr_trial_pair( MAX_RES() );
	FArray1D_float rep_trial_pair( MAX_RES() );
	FArray1D_float sol_trial_pair( MAX_RES() );
	FArray1D_float gb_elec_trial_pair( MAX_RES() );
	FArray1D_float h2o_trial_pair( MAX_RES(),0.0 );
	FArray1D_float h2o_hb_trial_pair( MAX_RES(),0.0 );
	FArray1D_float res_trial_pair( MAX_RES() );
	FArray1D_float prob_trial( MAX_RES() );
	FArray1D_float dun_trial( MAX_RES() );
	FArray1D_float unf_trial( MAX_RES() );
	FArray1D_float protonation_trial( MAX_RES() );
	FArray1D_float hbenergy_trial( MAX_RES() );
	FArray1D_float cstenergy_trial( MAX_RES() );
	FArray1D_float h2olj_trial( MAX_RES() );
	FArray1D_float h2ohb_trial( MAX_RES() );
	float fullatomE_trial;
	FArray1D_float pair_trial_pair( MAX_RES() );
	FArray1D_float plane_trial_plane( MAX_RES() );
	FArray1D_float cst_trial_pair( MAX_RES() );
	FArray1D_float hbond_trial_pair( MAX_RES() );
	FArray1D_float bbhbenergy_trial( MAX_RES() );
	FArray1D_float schbenergy_trial( MAX_RES() );
	FArray1D_float sc_bbhbenergy_trial( MAX_RES() );
	FArray1D_float coulenergy_trial( MAX_RES() );
	FArray1D_float intrares_trial( MAX_RES() );
	FArray1D_float lig_couenergy_trial( MAX_RES() );
	FArray1D_float lig_atrenergy_trial( MAX_RES() );
	FArray1D_float lig_repenergy_trial( MAX_RES() );
	FArray1D_float lig_solenergy_trial( MAX_RES() );
	FArray1D_float lig_hb_energy_trial( MAX_RES() );
	FArray1D_float lig_virenergy_trial( MAX_RES() );
	FArray1D_float trie_best_pair_trial_pair( MAX_RES() );
	FArray1D_float trie_best_gb_elec_trial_pair( MAX_RES() );
	FArray1D_float trie_best_cst_trial_pair( MAX_RES() );
	float trie_best_dun_trial;
	float trie_best_prob_trial;
	float trie_best_unf_trial;
	float trie_best_intrares_trial;
	float trie_best_h2olj_trial;
	float trie_best_h2ohb_trial;
	int const componentE_ljatr_row = { 1 };
	int const componentE_ljrep_row = { 2 };
	int const componentE_solvE_row = { 3 };
	int const componentE_hbond_row = { 4 };
	bool use_trials_trie_flag = {false};
}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin rot_ene_output::rot_ene_output
///
/// @brief: constructor for class rot_ene_output
///
/// @authors: John Karanicolas
///
/// @last_modified: 07/13/05
////////////////////////////////////////////////////////////////////////////////
rot_ene_output::rot_ene_output() { done_setup = false; }

////////////////////////////////////////////////////////////////////////////////
/// @begin rot_ene_output::~rot_ene_output
///
/// @brief: destructor for class rot_ene_output
///
/// @authors: John Karanicolas
///
/// @last_modified: 07/13/05
////////////////////////////////////////////////////////////////////////////////
rot_ene_output::~rot_ene_output() { if ( design::optE ) outdata.close(); }

////////////////////////////////////////////////////////////////////////////////
/// @begin rot_ene_output::write_rot_ene
///
/// @brief: write a line of rotamer energies, for use by opte program
///
/// @authors: John Karanicolas
///
/// @last_modified: 07/13/05
////////////////////////////////////////////////////////////////////////////////
void
rot_ene_output::write_rot_ene(
  int const pos,
  int const aa,
	int const aanat,
	int const nb,
	float const rmsd
)
{
	using namespace rotamer_trial_energies;
	using namespace files_paths;

	if ( ! done_setup ) {
		// write header
		std::string Eout;
		stringafteroption( "Eout", "default", Eout );
		outdata.open( (score_path + Eout).c_str(), std::ios_base::out );

		// Write a header for the opte output file--order must match below
		outdata << "pdb+cid " <<
		           "resnum aanum nataa " <<
							 "nb rmsd " <<
							 "atr rep " <<
							 "sol dun " <<
							 "one plane_total " <<
							 "intra hbond_sc " <<
							 "hbond_bb_sc";

		if ( param_pack::gen_born ) outdata << " gb_elec";
		else outdata << " pair";

		if ( design::explicit_h2o || water::read_hetero_h2o ) {
			outdata << " h2o_lj h2o_hb";
		}
		outdata << std::endl;
		done_setup = true;
	}

	outdata << start_file.substr(0,4) << protein_chain << ' ' <<
	           pos << ' ' << aa << ' ' << aanat << ' ' <<
	           nb << ' ' << F(6,2,rmsd) << ' ' <<
	           2*atrenergy_trial(pos) << ' ' << 2*repenergy_trial(pos) << ' ' <<
	           2*solenergy_trial(pos) << ' ' << dun_trial(pos) << ' ' <<
	           prob_trial(pos) << ' ' << 2*plane_energy_trial(pos) << ' ' <<
						 intrares_trial(pos) << ' ' << 2*schbenergy_trial(pos) << ' ' <<
	           2*(sc_bbhbenergy_trial(pos)+bbhbenergy_trial(pos));

	if ( param_pack::gen_born ) outdata << ' ' << 2*gb_elecenergy_trial(pos);
	else outdata << ' ' << 2*pair_energy_trial(pos);

	// Note: currently no support for explicit water
	if ( design::explicit_h2o || water::read_hetero_h2o ) {
		outdata << ' ' << h2olj_trial(pos) << ' ' << h2ohb_trial(pos);
	}

	outdata << '\n';
}
