// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32323 $
//  $Date: 2009-08-25 13:16:13 -0700 (Tue, 25 Aug 2009) $
//  $Author: johnk $

#ifndef INCLUDED_rotamer_trial_energies
#define INCLUDED_rotamer_trial_energies


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <fstream>

class rot_ene_output
{
	// opte output function with header
	private:
		bool done_setup;
		std::fstream outdata; // output file stream
	public:
		rot_ene_output();
		~rot_ene_output();
		void write_rot_ene(
			int const seqpos, int const aa, int const aanat,
			int const nb, float const rmsd
		);
};

namespace rotamer_trial_energies {

	extern rot_ene_output opte_output;

//bk energy arrays that describe the energy of each sequence position
//bk when the current rotamer has been removed

namespace minus_energies {
	extern FArray1D_float atrenergy_minus_current;
	extern FArray1D_float repenergy_minus_current;
	extern FArray1D_float resenergy_minus_current;
	extern FArray1D_float solenergy_minus_current;
	extern FArray1D_float gb_elecenergy_minus_current;
	extern FArray1D_float h2oenergy_minus_current;
	extern FArray1D_float h2ohbenergy_minus_current;
	extern FArray1D_float pair_energy_minus_current;
	extern FArray1D_float plane_energy_minus_current;
	extern FArray1D_float hbenergy_minus_current;
	extern FArray1D_float cstenergy_minus_current;
	extern FArray1D_float cstenergy_trial_current;
}
using namespace minus_energies;


//bk energy arrays that describe the energy of each sequence position
//bk with the trial rotamer in place

namespace trial_energies {
	extern FArray1D_float atrenergy_trial;
	extern FArray1D_float repenergy_trial;
	extern FArray1D_float resenergy_trial;
	extern FArray1D_float solenergy_trial;
	extern FArray1D_float gb_elecenergy_trial;
	extern FArray1D_float h2oenergy_trial;
	extern FArray1D_float h2ohbenergy_trial;
	extern FArray1D_float pair_energy_trial;
	extern FArray1D_float plane_energy_trial;
	extern FArray1D_float atr_trial_pair;
	extern FArray1D_float rep_trial_pair;
	extern FArray1D_float sol_trial_pair;
	extern FArray1D_float gb_elec_trial_pair;
	extern FArray1D_float h2o_trial_pair;
	extern FArray1D_float h2o_hb_trial_pair;
	extern FArray1D_float res_trial_pair;
	extern FArray1D_float prob_trial;
	extern FArray1D_float dun_trial;
	extern FArray1D_float unf_trial;
	extern FArray1D_float protonation_trial;
	extern FArray1D_float hbenergy_trial;
	extern FArray1D_float cstenergy_trial;
	extern FArray1D_float h2olj_trial;
	extern FArray1D_float h2ohb_trial;
	extern float fullatomE_trial;
	extern FArray1D_float pair_trial_pair;
	extern FArray1D_float plane_trial_plane;
	extern FArray1D_float cst_trial_pair;
	extern FArray1D_float hbond_trial_pair;
	extern FArray1D_float bbhbenergy_trial;
	extern FArray1D_float schbenergy_trial;
	extern FArray1D_float sc_bbhbenergy_trial;
	extern FArray1D_float coulenergy_trial;
	extern FArray1D_float intrares_trial;
	extern FArray1D_float lig_couenergy_trial;
	extern FArray1D_float lig_atrenergy_trial;
	extern FArray1D_float lig_repenergy_trial;
	extern FArray1D_float lig_solenergy_trial;
	extern FArray1D_float lig_hb_energy_trial;
	extern FArray1D_float lig_virenergy_trial;
	extern FArray1D_float trie_best_pair_trial_pair;
	extern FArray1D_float trie_best_gb_elec_trial_pair;
	extern FArray1D_float trie_best_cst_trial_pair;
	extern float trie_best_dun_trial;
	extern float trie_best_prob_trial;
	extern float trie_best_unf_trial;
	extern float trie_best_intrares_trial;
	extern float trie_best_h2olj_trial;
	extern float trie_best_h2ohb_trial;
	extern float trie_best_ligand_trial;
	extern int const componentE_ljatr_row;
	extern int const componentE_ljrep_row;
	extern int const componentE_solvE_row;
	extern int const componentE_hbond_row;
	extern bool use_trials_trie_flag;
}
using namespace trial_energies;


}


#endif
