// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_rotate
#define INCLUDED_rotate


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2DB.hh>


////////////////////////////////////////////////////////////////////////////////
//\BEGIN rotate
//
//\BRIEF   Using (col,row) subscripting
//
//\FULL
//
//\PARAM - mat - in/out -
//\PARAM - v1 - in/out -
//\PARAM - v2 - in/out -
//
//\GLOBAL_READ
//
//\GLOBAL_WRITE
//
//\NOTES
//
//\COMMENTERS
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
void
rotate(
	FArray2DB_double const & mat,
	FArray1Da_double v1,
	FArray1DB_double & v2
)
{
//Objexx: Skip dimensioning for speed

// input mat,v1
// output: v2 = MAT*V1
// profiler says do loop is expensive! use explicit notation
//$$$        for ( int i = 1; i <= 3; ++i ) {
//$$$          v2(i) = mat(1,i)*v1(1)+mat(2,i)*v1(2)+mat(3,i)*v1(3);
//$$$        }

	double const a = v1[0]; // v1(1)
	double const b = v1[1]; // v1(2)
	double const c = v1[2]; // v1(3)
	v2(1) = mat[0]*a + mat[1]*b + mat[2]*c;
	v2(2) = mat[3]*a + mat[4]*b + mat[5]*c;
	v2(3) = mat[6]*a + mat[7]*b + mat[8]*c;
}


////////////////////////////////////////////////////////////////////////////////
//\BEGIN rotate
//
//\BRIEF   Using (col,row) subscripting
//
//\FULL
//
//\PARAM - mat - in/out -
//\PARAM - v1 - in/out -
//\PARAM - v2 - in/out -
//
//\GLOBAL_READ
//
//\GLOBAL_WRITE
//
//\NOTES
//
//\COMMENTERS
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
void
rotate(
	FArray2DB_float const & mat,
	FArray1Da_float v1,
	FArray1Da_float v2
)
{
//Objexx: Skip dimensioning for speed

// it is okay if v1 and v2 are the same array, or use rotate_in_place to make this explicit
	double const a = v1[0]; // v1(1)
	double const b = v1[1]; // v1(2)
	double const c = v1[2]; // v1(3)
	v2[0] = mat[0]*a + mat[1]*b + mat[2]*c; // v2(1)
	v2[1] = mat[3]*a + mat[4]*b + mat[5]*c; // v2(2)
	v2[2] = mat[6]*a + mat[7]*b + mat[8]*c; // v2(3)
}


////////////////////////////////////////////////////////////////////////////////
//\BEGIN rotate_in_place
//
//\BRIEF   Using (col,row) subscripting
//
//\FULL
//
//\PARAM - mat - in/out -
//\PARAM - v1 - in/out -
//
//\GLOBAL_READ
//
//\GLOBAL_WRITE
//
//\NOTES
//
//\COMMENTERS
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
void
rotate_in_place(
	FArray2DB_double const & mat,
	FArray1Da_double v1
)
{
//	v1.dimension( 3 ); //Objexx: Skip dimensioning for speed

// like rotate, but copies results back into original matrix

	double const a = v1[0]; // v1(1)
	double const b = v1[1]; // v1(2)
	double const c = v1[2]; // v1(3)
	v1[0] = mat[0]*a + mat[1]*b + mat[2]*c; // v1(1)
	v1[1] = mat[3]*a + mat[4]*b + mat[5]*c; // v1(2)
	v1[2] = mat[6]*a + mat[7]*b + mat[8]*c; // v1(3)
}


////////////////////////////////////////////////////////////////////////////////
//\BEGIN rotate_in_place
//
//\BRIEF   Using (col,row) subscripting
//
//\FULL
//
//\PARAM - mat - in/out -
//\PARAM - v1 - in/out -
//
//\GLOBAL_READ
//
//\GLOBAL_WRITE
//
//\NOTES
//
//\COMMENTERS
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
void
rotate_in_place(
	FArray2DB_float const & mat,
	FArray1Da_float v1
)
{
//Objexx: Skip dimensioning for speed
//	v1.dimension( 3 );

// like rotate, but copies results back into original matrix
	double const a = v1[0]; // v1(1)
	double const b = v1[1]; // v1(2)
	double const c = v1[2]; // v1(3)
	v1[0] = mat[0]*a + mat[1]*b + mat[2]*c; // v1(1)
	v1[1] = mat[3]*a + mat[4]*b + mat[5]*c; // v1(2)
	v1[2] = mat[6]*a + mat[7]*b + mat[8]*c; // v1(3)

}


#endif
