// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32323 $
//  $Date: 2009-08-25 13:16:13 -0700 (Tue, 25 Aug 2009) $
//  $Author: johnk $


// Rosetta Headers
#include "score_ns.h"
#include "files_paths.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>


namespace scorefxns {


//car--------------------------
//car named parameters to identify scorefxn combinations

int const score_undef = { -999 };

int const score_0 = { 0 };
int const score_1 = { 1 };
int const score_2 = { 2 };
int const score_3 = { 3 };
int const score_4 = { 4 };
int const score_5 = { 5 };
int const score_6 = { 6 };
int const score_7 = { 7 };
int const score_8 = { 8 };
int const score_9 = { 9 };
int const score_10 = { 10 };
int const score_11 = { 11 };
int const score_12 = { 12 };
int const score_13 = { 13 };
int const score_14 = { 14 };
// docking scorefxns  (31-50)
int const score_4d = { 34 };
int const score_10d = { 40 };

// domins scorefxns (71-90)
int const score_8di = { 78 };

// aroop: antibody loop modeling scorefxns (91-100)
int const score_4Lc = { 91 };

// loop scorefxns  (51-70)
int const score_3L = { 53 };
int const score_4L = { 54 };
int const score_9L = { 59 };
int const score_10L = { 60 };
int const score_11L = { 61 };
int const score_12L = { 62 };


//car weights and parameters for scorefxn evaluation


//car--------------------------
//car flags
//car--------------------------


namespace scorefxn_default {
	int default_scorefxn = { score_undef }; // see scorefxns.cc for values
	int default_fascorefxn = { score_undef }; // see scorefxns.cc for values
}


namespace scorefxn_flags {
	bool evaluate_all_terms = { false };
	bool no_evaluation = { false }; // one time, don't actually call scorefxn
	bool try_rotamers = { false };
	bool try_rotamers_default = { false };
	bool use_mc_prescore;
	bool use_subset_energy = { false };
	bool fa_scorefxn; // are fullatom terms on?
	bool bbonly_scorefxn; // should we skip fullatom_energy?
	bool rnaonly_scorefxn = { false }; // skip fullatom energy, only evaluate rna terms?
	bool dock_scorefxn; // are docking terms in use
	bool domain_scorefxn; // are domain terms in use
	bool loop_scorefxn; // aroop: loop contact terms in use
	bool docking_ensemble_scorefxn = { false }; // Sid: for ensemble docking terms
	bool vary_omega = { false };
}


//car--------------------------
//car parameters
//car--------------------------
	//<=0.5: do not include ss distscore in ss_score
	// do  not contribute to ss_score
	// see comments on mode in eval_pairConstraint

namespace scorefxn_parameters {
	int ss_lowstrand; // >0.5: include ss distscore in ss_score
	int ss_cutoff; // dimer pairs closer in sequence than ss_cutoff
	int pc_mode; // selects functional form for pc_score
}


//car--------------------------
//car internal weights  (ie set internally in scorefxns)
//car   These weights are all applied to scorefxn terms before summing totals
//car   The weights are not applied to individual terms written out in pdb
//car   files and score files

//car additional weights are applied directly to the following scorefxn terms
//car within the functions where the terms are evaluated (ie before they
//car are returned to scorefxn) These numbers are current as of 8/12/2003
//car       term         weight         function
//car       sheet        2.019          evaluate_ss
//car       hs_score     0.090          evaluate_ss
//car       ss_score     0.3735         evaluate_ss
//car       rsigma       0.1            evaluate_ss
//car       env          2.019          evaluate_envpair
//car       pair         2.019          evaluate_envpair
//car       cbeta        0.8001         evaluate_envpair
//car       vdw          0.8            vdw_compute_insert


namespace scorefxn_weights {
	float env_weight;          ///< environment
	float pair_weight;         ///< pair
	float vdw_weight;          ///< bumps
	float sheet_weight;        ///< strand arrangement
	float rsigma_weight;
	float cb_weight;           ///< C-beta density
	float ss_weight;           ///< strand pairing
	float hs_weight;           ///< helix-strand packing
	float rg_weight;           ///< radius of gyration
	float co_weight;           ///< contact order
	float contact_prediction_weight; //mj
	float ramachandran_weight; ///< torsion preferences
	float pc_weight;           ///< pair constraint
	float dipolar_weight;      ///< NMR dipolar couplings
	float projection_weight;
	float splicemsd_weight;    ///< loop closure splice distance
	float jmp_chainbreak_weight;
	float taboo_weight;
	float atompair_cst_weight; ///< new constraint scores based on Cst_set
	float coord_cst_weight;    ///< see more comments in score_ns.h
	float chainbreak_cst_weight;
	float phipsi_cst_weight;
	float omega_cst_weight;
	float chi_cst_weight;
	float kin_1D_cst_weight;
	float kin_3D_cst_weight;
	float symm_weight;
	FArray1D_float cut_weight;
	float rms_weight;
	float dna_bs_weight;
	float dna_bp_weight;
	float rna_bs_weight;
	float rna_bp_w_weight;
	float rna_bp_h_weight;
	float rna_bp_s_weight;
	float rna_axis_weight;
	float rna_stagger_weight;
	float rna_bulge_weight;
	float rna_nonbasebase_weight;
	float rna_o2star_weight;
	float rna_phosphate_weight;
	float rna_contact_weight;
	float rna_long_range_contact_weight;
	float rna_sasa_weight;
	float sidechain_bond_angle_weight;
	float dummy_model_weight;
	float extra_weight;
	float saxs_model_weight;
	float loop_contact_weight; // aroop: loop modeling
	float electron_density_weight;
}

//car additional weights are applied directly to the following terms when they
//car are evaluated (ie before they are returned to scorefxn)
//car These additional weights are defined in param_pack.h

namespace fullatom_weights {
	float fa_atr_weight;       ///< attractive van der Waals
	float fa_rep_weight;       ///< repulsive van der Waals
	float fa_dun_weight;       ///< Dunbrack rotamer probability
	float fa_prob1b_weight;
	float fa_pair_weight;      ///< res-res pair propensity
	float fa_plane_weight;     ///< aromatic interactions
	float fa_solv_weight;      ///< lazaridis-karplus solvation
	float fa_ref_weight;
 	float fa_pH_weight;        ///< Chemical Energy of Protonation
	float fa_gb_elec_weight;   ///< generalized born electrostatics
  float fa_elec_weight;      // SJF electrostatic potential with distance-dependent dielectric
	float fa_h2o_weight;       ///< water-solvated rotamers
}


//cj    weights for explicit ljvdw & approximate SASA
//car scaling factor of 0.0008 applied in calc_aprox_sasa

namespace more_fullatom_weights {
	float ex_gsolt_weight;      ///< surface-area solvation
	float ex_ponpf_weight;
	float sasa_weight;
}

namespace pair_term {
  bool no_pair_term = { false };
}


//bs  weights for disulfide scorefxn terms
//bs  additional wts for these terms in packer (param_pack.h); packer
//bs    weights are applied before values are returned to scorefxn
//bs  fa_disulfide scores declared in fullatom_energies.h
//bs  centroid disulfide scores declared in score_ns.h

namespace scorefxn_disulfide_weights {
	float disulfide_distance_weight;
	float disulfide_csangles_weight;
	float disulfide_dihedral_weight;
	float disulfide_ca_dihedral_weight;
	float disulfide_cbs_dist_weight;
	float disulf_cendist_weight;
	float disulf_bb_dih_weight;
	float disulf_cbdist_weight;
	float disulf_ca_minus_cen_weight;
	float disulf_cacbcb_weight;
	float disulf_cacbcbca_weight;
	float disulf_Ncen_weight;
	float disulf_Ncb_weight;
	float disulf_Nfa_weight;
}


//car weights for docking scorefxn terms

namespace docking_scorefxn_weights {
	float docking_env_weight;
	float docking_pair_weight;
	float docking_contact_weight;
	float docking_contact_cap;
	float docking_vdw_weight;
	float docking_sc_weight;
	float docking_fab_weight;
	float docking_fab_cap;
	float docking_warshel_elec_weight;
}

//Monica Berrondo weights for domain insertion scorefxn terms

namespace domain_scorefxn_weights {
	float domain_contact_weight;
	float domain_contact_cap;
	float domain_dc_weight;
	float domain_vdw_weight;
}

// aroop: weights for loop building in antibody mode
namespace loop_scorefxn_weights {
	float loop_contact_weight;
}

//car tethering weights

namespace external_tether_weights {
	float tether_weight;
	float phipsi_weight;
	float omega_weight;
}


namespace unideal_bond_weights {
	float bond_angle_weight;
}


//car--------------------------
//car external weights (ie set from main protocols via methods)
//car note changing these values necessitates resetting monte_carlo
//car through either recover_LOW or new_scoring_function
//car  These weights are not applied to the scorefxn terms, but are used to
//car    set the values of weights which are applied in scorefxn.
//car--------------------------

namespace external_scorefxn_weights {
	float lj_weight = { 1.0 };
	float loop_weight = { 0.0 };
	float cst_weight = { 1.0 };
	float dpl_weight = { 10.0 };
	float rep_reduce = { 1.0 };
	float motif_tether_weight = { 0.0 };
	int cst_mode = { 3 };
}

// weights for the barcode constraints
namespace barcode_weights {
	float barcode_weight = {0.0};
	float barcode_energy_weight = {0.0};
}

//car--------------------------
//car mc_prescore
//car      scores used to determine if fullatom scoring is worth the
//car      time required as estimated from the centroid scores

namespace mc_prescore_private {
	float prescore;
	float best_prescore;
}

// user defined reweights of score terms
namespace score_reweights{
	float vdw_reweight = { 1.0 };
	float env_reweight = { 1.0 };
	float pair_reweight = { 1.0 };
	float cb_reweight = { 1.0 };
	float sheet_reweight = { 1.0 };
	float ss_reweight = { 1.0 };
	float hs_reweight = { 1.0 };
	float rsigma_reweight = { 1.0 };
	float rg_reweight = { 1.0 };
	float pc_reweight = { 1.0 };
	float fa_atr_reweight = { 1.0 };
	float fa_rep_reweight = { 1.0 };
	float fa_dun_reweight = { 1.0 };
	float fa_pair_reweight = { 1.0 };
	float fa_plane_reweight = { 1.0 };
	float fa_solv_reweight = { 1.0 };
	float fa_ref_reweight = { 1.0 };
	float fa_pH_reweight = { 1.0 };
	float fa_h2o_reweight = {1.0 };
	float fa_prob1b_reweight = { 1.0 };
	float fa_gb_elec_reweight = { 1.0 };
	float hb_srbb_reweight = { 1.0 };
	float hb_lrbb_reweight = { 1.0 };
	float hb_sc_reweight = { 1.0 };
	float chainbreak_reweight = { 1.0 };
	float electron_density_reweight = { 1.0 };
	float dummy_model_reweight = { 1.0 };
	float saxs_model_reweight = { 1.0 };

	float barcode_reweight = { 1.0 };
	float barcode_energy_reweight = { 1.0 };
}

} //namespace scorefxn



namespace scores {


//--------
// scores
//--------


namespace current_scores {
	float env_score;
	float pair_score;
	float vdw_score;
	float sheet_score;
	float rsigma_score;
	float barscore;
	float bar_energy_score;
	float cb_score;
	float cb_score6;
	float cb_score12;
	float centroid_pack_score;
	float ss_score;
	float hs_score;
	float rg;
	float co;
	float contact_prediction;
	float ramachandran_score;
	float pc_score;
	float pc_viol;
	float dipolar_score;
	float projection_score;
	float taboo_score;
	float taboo_best;
	float chainbreak_score;
	float dummy_model_score;
	float nsd;
	float saxs_model_score;
	float homolog_env_score;
	float homolog_pair_score;
	float homolog_cendist_score;
	float loop_contact_score; // aroop
	float rna_bs_score;
	float rna_bp_w_score;
	float rna_bp_h_score;
	float rna_bp_s_score;
	float rna_axis_score;
	float rna_stagger_score;
	float rna_bulge_score;
	float rna_nonbasebase_score;
	float rna_o2star_score;
	float rna_phosphate_score;
	float rna_contact_score;
	float rna_sasa_score;
	float rna_long_range_contact_score;
	float delG;
	float energy_pack;
}


namespace hbond_scores {
	float hb_srbb_score;
	float hb_lrbb_score;
	float hb_sc_score;
}


namespace fa_energies {
	float fa_solv_score;
	float fa_atr_score;
	float fa_rep_score;
	float fa_ref_score;
	float fa_pH_score;      ///< Chemical Energy of Protonation
	float fa_dun_score;
	float fa_prob1b_score;
	float fa_pair_score;
	float fa_plane_score;
	float fa_h2o_score;
	float fa_h2o_hb_score;
	float fa_h2o_solv_score;
	float fa_intrares_score;
	float fa_gb_elec_score;
  float fa_elec_score; // SJF
  float fa_d_elec_score;
}


//namespace plane_score {
//	float plane_pi_score;
//	float plane_hydrophobic_score;
//	float plane_cation_score;
//	float plane_proline_score;
//	float plane_histadine_score;
//	float plane_total_score;
//}


namespace docking_scores {
	float docking_env_score;
	float docking_pair_score;
	float docking_contact_score;
	float docking_vdw_score;
	float docking_site_constraint_score;
	float docking_fab_score;
	float docking_warshel_elec_score;
	float symm_mon_score;
}

namespace domain_scores {
	float domain_contact_score;
	float domain_dc_score;
	float domain_vdw_score;
}

namespace loop_scores {
	float loop_contact_score;
}

namespace score_disulf_centroid {
	float disulf_cendist_score;
	float disulf_bb_dih_score;
	float disulf_cbdist_score;
	float disulf_ca_minus_cen_score;
	float disulf_cacbcb_score;
	float disulf_cacbcbca_score;
	int disulf_Ncen_score;
	int disulf_Nfa_score;
}


namespace tether_scores {
	float omega_score;
	float tether_score;
	float phipsi_score;
}


namespace unideal_bond_scores {
	float bond_angle_score;
}


}

//glb  scale various pair-wise interactions
namespace scale_res_energy_ns {
	using namespace files_paths;
	using namespace param;
	FArray2D_bool scale_energy_matrix( MAX_RES(), MAX_RES() );
	FArray2D_bool scale_rep_energy_matrix( MAX_RES(), MAX_RES() );
	bool scale_res_energy_flag = { false };
	float scale_res_energy_weight = { 1.0 };
	float scale_res_rep_energy_weight = { 1.0 };
}
