// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32323 $
//  $Date: 2009-08-25 13:16:13 -0700 (Tue, 25 Aug 2009) $
//  $Author: johnk $

#ifndef INCLUDED_score_ns
#define INCLUDED_score_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace scorefxns {


//car--------------------------
//car named parameters to identify scorefxn combinations

extern int const score_undef;

extern int const score_0;
extern int const score_1;
extern int const score_2;
extern int const score_3;
extern int const score_4;
extern int const score_5;
extern int const score_6;
extern int const score_7;
extern int const score_8;
extern int const score_9;
extern int const score_10;
extern int const score_11;
extern int const score_12;
extern int const score_13;
extern int const score_14;
// docking scorefxns  (31-50)
extern int const score_4d;
extern int const score_10d;

// domain scorefxns (71-90)
extern int const score_8di;

// aroop antibody loop scorefxn
extern int const score_4Lc;

// loop scorefxns  (51-70)
extern int const score_3L;
extern int const score_4L;
extern int const score_9L;
extern int const score_10L;
extern int const score_11L;
extern int const score_12L;


//car weights and parameters for scorefxn evaluation


//car--------------------------
//car flags
//car--------------------------


namespace scorefxn_default {
	extern int default_scorefxn;   // see scorefxns.cc for values
	extern int default_fascorefxn; // see scorefxns.cc for values
}
using namespace scorefxn_default;


namespace scorefxn_flags {
	extern bool evaluate_all_terms;
	extern bool no_evaluation; // one time, don't actually call scorefxn
	extern bool try_rotamers;
	extern bool try_rotamers_default;
	extern bool use_mc_prescore;
	extern bool use_subset_energy;
	extern bool fa_scorefxn; // are fullatom terms on?
	extern bool bbonly_scorefxn; // should we skip fullatom_energy?
	extern bool rnaonly_scorefxn; // skip fullatom_energy, only evaluate rna terms?
	extern bool dock_scorefxn; // are docking terms in use
	extern bool domain_scorefxn; // are domain insertion terms in use
	extern bool loop_scorefxn; // aroop: loop contact terms in use
	extern bool vary_omega; // evaluate omega score?
	extern bool docking_ensemble_scorefxn;
}
using namespace scorefxn_flags;


//car--------------------------
//car parameters
//car--------------------------
	//<=0.5: do not include ss distscore in ss_score
	// do  not contribute to ss_score
	// see comments on mode in eval_pairConstraint


namespace scorefxn_parameters {
	extern int ss_lowstrand; ///< >0.5: include ss distscore in ss_score
	extern int ss_cutoff;    ///< dimer pairs closer in sequence than ss_cutoff
	extern int pc_mode;      ///< selects functional form for pc_score
}
using namespace scorefxn_parameters;


//car--------------------------
//car internal weights  (ie set internally in scorefxns)
//car   These weights are all applied to scoring terms before summing totals
//car   The weights are not applied to individual terms written out in pdb
//car   files and score files

//car additional weights are applied directly to the following scoring terms
//car within the functions where the terms are evaluated (ie before they
//car are returned to scorefxn) These numbers are current as of 8/12/2003
//car       term         weight         function
//car       sheet        2.019          evaluate_ss
//car       hs_score     0.090          evaluate_ss
//car       ss_score     0.3735         evaluate_ss
//car       rsigma       0.1            evaluate_ss
//car       env          2.019          evaluate_envpair
//car       pair         2.019          evaluate_envpair
//car       cbeta        0.8001         evaluate_envpair
//car       vdw          0.8            vdw_compute_insert


namespace scorefxn_weights {
	extern float env_weight;            ///< environment
	extern float pair_weight;           ///< pair
	extern float vdw_weight;            ///< bumps
	extern float sheet_weight;          ///< strand arrangement
	extern float rsigma_weight;
	extern float cb_weight;             ///< C-beta density
	extern float ss_weight;             ///< strand pairing
	extern float hs_weight;             ///< helix-strand packing
	extern float rg_weight;             ///< radius of gyration
	extern float co_weight;             ///< contact order
	extern float contact_prediction_weight;        //mj
	extern float ramachandran_weight;   ///< torsion preferences
	extern float pc_weight;             ///< pair constraint
	extern float dipolar_weight;        ///< NMR dipolar couplings
	extern float projection_weight;
	extern float splicemsd_weight;      /// loop closure splice distance
	extern float jmp_chainbreak_weight;
	extern float taboo_weight;
	extern float atompair_cst_weight;   //< pose-style constraints
	extern float coord_cst_weight;      //< based on the Cst_set class
	extern float chainbreak_cst_weight;      //< based on the Cst_set class
	extern float phipsi_cst_weight;     //< see pose_constraints.cc
	extern float omega_cst_weight;      //< and cst_set.*
	extern float chi_cst_weight;
	extern float kin_1D_cst_weight;
	extern float kin_3D_cst_weight;
	extern float symm_weight;
	extern FArray1D_float cut_weight;
	extern float rms_weight;
	extern float dna_bs_weight;
	extern float dna_bp_weight;
	extern float rna_bs_weight;
	extern float rna_bp_w_weight;
	extern float rna_bp_h_weight;
	extern float rna_bp_s_weight;
	extern float rna_axis_weight;
	extern float rna_stagger_weight;
	extern float rna_bulge_weight;
	extern float rna_nonbasebase_weight;
	extern float rna_o2star_weight;
	extern float rna_phosphate_weight;
	extern float rna_contact_weight;
	extern float rna_long_range_contact_weight;
	extern float rna_sasa_weight;
	extern float sidechain_bond_angle_weight;
	extern float dummy_model_weight;
	extern float extra_weight;
	extern float saxs_model_weight;
	extern float electron_density_weight;
}
using namespace scorefxn_weights;

//car additional weights are applied directly to the following terms when they
//car are evaluated (ie before they are returned to scorefxn)
//car These additional weights are defined in param_pack.h

namespace fullatom_weights {
	extern float fa_atr_weight;     ///< attractive van der Waals
	extern float fa_rep_weight;     ///< repulsive van der Waals
	extern float fa_dun_weight;     ///< Dunbrack rotamer probability
	extern float fa_prob1b_weight;
	extern float fa_pair_weight;    ///< res-res pair propensity
	extern float fa_plane_weight;   ///< aromatic interactions
	extern float fa_solv_weight;    ///< lazaridis-karplus solvation
	extern float fa_ref_weight;
 	extern float fa_pH_weight;      ///< Chemical Energy of Protonation
	extern float fa_gb_elec_weight; ///< generalized born electrostatics
  extern float fa_elec_weight;    // SJF electrostatic potential with distance dependent (1/r) dielectric
	extern float fa_h2o_weight;     ///< water-solvated rotamers
}
using namespace fullatom_weights;


//cj    weights for explicit ljvdw & approximate SASA
//car scaling factor of 0.0008 applied in calc_aprox_sasa

namespace more_fullatom_weights {
	extern float ex_gsolt_weight;  ///< surface-area solvation
	extern float ex_ponpf_weight;
	extern float sasa_weight;
}
using namespace more_fullatom_weights;

namespace pair_term {
	extern bool no_pair_term;
}
using namespace pair_term;


//bs  weights for disulfide scoring terms
//bs  additional wts for these terms in packer (param_pack.h); packer
//bs    weights are applied before values are returned to scorefxn
//bs  fa_disulfide scores declared in fullatom_energies.h
//bs  centroid disulfide scores declared in score_ns.h

namespace scorefxn_disulfide_weights {
	extern float disulfide_distance_weight;
	extern float disulfide_csangles_weight;
	extern float disulfide_dihedral_weight;
	extern float disulfide_ca_dihedral_weight;
	extern float disulfide_cbs_dist_weight;
	extern float disulf_cendist_weight;
	extern float disulf_bb_dih_weight;
	extern float disulf_cbdist_weight;
	extern float disulf_ca_minus_cen_weight;
	extern float disulf_cacbcb_weight;
	extern float disulf_cacbcbca_weight;
	extern float disulf_Ncen_weight;
	extern float disulf_Ncb_weight;
	extern float disulf_Nfa_weight;
}
using namespace scorefxn_disulfide_weights;


//car weights for docking scoring terms

namespace docking_scorefxn_weights {
	extern float docking_env_weight;        ///< residue environment
	extern float docking_pair_weight;       ///< residue pair
	extern float docking_contact_weight;    ///< interface contacts
	extern float docking_contact_cap;       ///< max number of interface contacts
	extern float docking_vdw_weight;        ///< interface bumps
	extern float docking_sc_weight;         ///< docking site constraint
	extern float docking_fab_weight;        ///< antibody or alignment score
	extern float docking_fab_cap;           ///< max antibody bonus
	extern float docking_warshel_elec_weight;
	                           ///< distance-dependent dielectric electrostatics
}
using namespace docking_scorefxn_weights;

// Monica Berrondo weights for domain insertion scoring terms

namespace domain_scorefxn_weights {
	extern float domain_contact_weight;		// interface contacs
	extern float domain_contact_cap;			// max number of interface contacts
	extern float domain_dc_weight;				// distance constraint
	extern float domain_vdw_weight;				// interface bumps
}
using namespace domain_scorefxn_weights;

// aroop weights for loop modeling in antibody mode

namespace loop_scorefxn_weights {
	extern float loop_contact_weight; // loop contacting with main body of protein
}
using namespace loop_scorefxn_weights;

//car tethering weights

namespace external_tether_weights {
	extern float tether_weight;
	extern float phipsi_weight;
	extern float omega_weight;
}
using namespace external_tether_weights;


namespace unideal_bond_weights {
	extern float bond_angle_weight;
}
using namespace unideal_bond_weights;


//car--------------------------
//car external weights (ie set from main protocols via methods)
//car note changing these values necessitates resetting monte_carlo
//car through either recover_LOW or new_scoring_function
//car  These weights are not applied to the scoring terms, but are used to
//car    set the values of weights which are applied in scorefxn.
//car--------------------------

namespace external_scorefxn_weights {
	extern float lj_weight;
	extern float loop_weight;
	extern float cst_weight;
	extern float dpl_weight;
	extern float rep_reduce;
	extern float motif_tether_weight;
	extern int cst_mode;
}
using namespace external_scorefxn_weights;

// weights for the barcode constraints
namespace barcode_weights {
	extern float barcode_weight;
	extern float barcode_energy_weight;
}
using namespace barcode_weights;

//car--------------------------
//car mc_prescore
//car      scores used to determine if fullatom scoring is worth the
//car      time required as estimated from the centroid scores

namespace mc_prescore_private {
	extern float prescore;
	extern float best_prescore;
}
using namespace mc_prescore_private;

// user defined reweights of score terms
namespace score_reweights{
	extern float vdw_reweight;
	extern float env_reweight;
	extern float pair_reweight;
	extern float cb_reweight;
	extern float sheet_reweight;
	extern float ss_reweight;
	extern float hs_reweight;
	extern float rsigma_reweight;
	extern float rg_reweight;
 	extern float pc_reweight;
 	extern float fa_atr_reweight;
 	extern float fa_rep_reweight;
 	extern float fa_dun_reweight ;
 	extern float fa_pair_reweight;
 	extern float fa_plane_reweight;
 	extern float fa_solv_reweight;
 	extern float fa_ref_reweight ;
 	extern float fa_pH_reweight;
 	extern float fa_h2o_reweight ;
 	extern float fa_prob1b_reweight;
 	extern float fa_gb_elec_reweight;
 	extern float hb_srbb_reweight;
 	extern float hb_lrbb_reweight;
 	extern float hb_sc_reweight;
 	extern float chainbreak_reweight;
	extern float electron_density_reweight;
 	extern float dummy_model_reweight;
 	extern float saxs_model_reweight;

 	extern float barcode_reweight;
 	extern float barcode_energy_reweight;
}

}


namespace scores {


//car weights and parameters for scorefxn evaluation


//--------
// scores
//--------


namespace current_scores {
	extern float env_score;         ///< environment
	extern float pair_score;        ///< pair
	extern float vdw_score;         ///< bumps
	extern float sheet_score;       ///< strand arrangement
	extern float rsigma_score;
	extern float barscore;
	extern float bar_energy_score;
	extern float cb_score;          ///< C-beta density
	extern float cb_score6;
	extern float cb_score12;
	extern float centroid_pack_score;          ///< Centroid packing score
	extern float ss_score;          ///< strand pairing
	extern float hs_score;          ///< helix-strand packing
	extern float rg;                ///< radius of gyration
	extern float co;                ///< contact order
	extern float contact_prediction;//mj
	extern float ramachandran_score;///< torsion preferences
	extern float pc_score;          ///< pair constraint
	extern float pc_viol;
	extern float dipolar_score;     ///< NMR dipolar couplings
	extern float projection_score;
	extern float taboo_score;       /// bonus for taboo search
	extern float taboo_best;
	extern float chainbreak_score;
	extern float dummy_model_score;
	extern float nsd;
	extern float saxs_model_score;
	extern float homolog_env_score;
	extern float homolog_pair_score;
	extern float homolog_cendist_score;
	extern float rna_bs_score;
	extern float rna_bp_w_score;
	extern float rna_bp_h_score;
	extern float rna_bp_s_score;
	extern float rna_axis_score;
	extern float rna_stagger_score;
	extern float rna_bulge_score;
	extern float rna_nonbasebase_score;
	extern float rna_o2star_score;
	extern float rna_phosphate_score;
	extern float rna_contact_score;
	extern float rna_sasa_score;
	extern float rna_long_range_contact_score;
	extern float delG;
	extern float energy_pack;
}
using namespace current_scores;


namespace hbond_scores {
	extern float hb_srbb_score; ///< hydrogen bonds, backbone, short-range
	extern float hb_lrbb_score; ///< hydrogen bonds, backbone, long-range
	extern float hb_sc_score;   ///< hydrogen bonds, sidechain
}
using namespace hbond_scores;


namespace fa_energies {
	extern float fa_solv_score;    ///< lazaridis-karplus solvation
	extern float fa_atr_score;     ///< attractive van der Waals
	extern float fa_rep_score;     ///< repulsive van der Waals
	extern float fa_ref_score;
 	extern float fa_pH_score;      ///< Chemical Energy of Protonation
	extern float fa_dun_score;     ///< Dunbrack rotamer probability
	extern float fa_prob1b_score;
	extern float fa_pair_score;    ///< res-res pair propensity
	extern float fa_plane_score;   ///< aromtic interactions
	extern float fa_h2o_score;     ///< water-solvated rotamers
	extern float fa_h2o_hb_score;
	extern float fa_h2o_solv_score;
	extern float fa_intrares_score;
	extern float fa_gb_elec_score; ///< generalized born electrostatics
  extern float fa_elec_score; // SJF electrostatic potential with distance dependent (1/r) dielectric
  extern float fa_d_elec_score;
}
using namespace fa_energies;


//namespace plane_score {
//	extern float plane_pi_score;
//	extern float plane_hydrophobic_score;
//	extern float plane_cation_score;
//	extern float plane_proline_score;
//	extern float plane_histadine_score;
//	extern float plane_total_score;
//}
//using namespace plane_score;


namespace docking_scores {
	extern float docking_env_score;             ///< residue environment
	extern float docking_pair_score;            ///< residue pair
	extern float docking_contact_score;         ///< interface contacts
	extern float docking_vdw_score;             ///< interface bumps
	extern float docking_site_constraint_score; ///< docking site constraint
	extern float docking_fab_score;             ///< antibody or alignment score
	extern float docking_warshel_elec_score;    ///< distance-dependent dielectric electrostatics
	extern float symm_mon_score;								///< score for symmetrical docking
}
using namespace docking_scores;

namespace domain_scores {
	extern float domain_contact_score;				///< interface contacts
	extern float domain_dc_score;							///< distance constraint
	extern float domain_vdw_score;						///< interface bumps
}
using namespace domain_scores;

namespace loop_scores {
	extern float loop_contact_score; ///< loop contacts with main body
}
using namespace loop_scores;

namespace score_disulf_centroid {
	extern float disulf_cendist_score;
	extern float disulf_bb_dih_score;
	extern float disulf_cbdist_score;
	extern float disulf_ca_minus_cen_score;
	extern float disulf_cacbcb_score;
	extern float disulf_cacbcbca_score;
	extern int disulf_Ncen_score;
	extern int disulf_Nfa_score;
}
using namespace score_disulf_centroid;


namespace tether_scores {
	extern float omega_score;
	extern float tether_score;
	extern float phipsi_score;
}
using namespace tether_scores;


namespace unideal_bond_scores {
	extern float bond_angle_score;
}
using namespace unideal_bond_scores;


}

//glb  scale_res_energy  allow various pair-wise interactions to be
//     scaled (for example energies between chains)
namespace scale_res_energy_ns {
	extern FArray2D_bool scale_energy_matrix;
	extern FArray2D_bool scale_rep_energy_matrix;
	extern bool scale_res_energy_flag;
	extern float scale_res_energy_weight;
	extern float scale_res_rep_energy_weight;
}


#endif
