// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.4 $
//  $Date: 2004/05/21 17:20:04 $
//  $Author: pbradley $


// Rosetta Headers
#include "shotgun.h"
#include "after_opts.h"
#include "files_paths.h"
#include "maxsub.h"
#include "misc.h"
#include "param.h"
#include "pose.h"
#include "silent_input.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/formatted.io.hh>

// C++ Headers
#include <cstdlib>
#include <string>
#include <vector>

namespace shotgun {
  int max_nali = { 0 };
  float closest_server_rms = { 0 };
  std::string closest_server_tag = "no_model";
}


void
maxsub_to_server_models()
{
  using namespace misc;
  using namespace param;
  using namespace silent_io;
  using namespace pose_ns;
  using namespace shotgun;
  static bool init ( false );

  FArray1D_bool occ1(total_residue, false);
  FArray3D_float Epos1(3,MAX_POS,total_residue,0.0);

  int nali;
  float rms, logeval;

  //Read the first array of C-alpha's from whatever's in misc (presumably the last decoy).
  for ( int i=1; i<= total_residue; i++ ) {
    for ( int k=1; k<= 3; k++ ) {
      Epos1(k,2,i) = full_coord(k,2,i);
    }
    occ1(i) = true;
  }

  // Read in server models, assumed to be in an out file, maybe gzipped.
  bool fa_input( false );
  std::string silent_input_file;
  if (!init){
    stringafteroption("server_models",  "3djury.out", silent_input_file );
    init = true;
  }
  std::string const filename( files_paths::start_path + silent_input_file );

  static Silent_file_data server_model_data( filename, fa_input );

  // loop through the tag list
  std::vector< std::string > tag_list;
  tag_list = server_model_data.tags();
  max_nali = 0;
  closest_server_tag = "no_model";
  closest_server_rms = 0.0;
  for ( std::vector< std::string >::const_iterator it=tag_list.begin(),
					it_end = tag_list.end(); it != it_end; ++it ) {
    std::string const & tag( *it );
    if ( ! server_model_data.has_key( tag ) ) {
      std::cout << "couldnt find tag in silent-file: " << tag << std::endl;
      continue;
    }
    // get the data
    Silent_structure const & decoy( server_model_data.get_structure( tag ) );

  //Read the second array of C-alpha's from the server model.
    FArray1D_bool  occ2(total_residue, false);
    FArray3D_float Epos2(3,MAX_POS,total_residue,0.0);
    FArray2D_float server_coords( decoy.coords );
    for ( int i=1; i<= total_residue; i++ ) {
      for ( int k=1; k<= 3; k++ ) {
	Epos2(k,2,i) = server_coords(k,i);
      }
	if (Epos2(1,2,i)*Epos2(1,2,i) +
	    Epos2(2,2,i)*Epos2(2,2,i) +
	    Epos2(3,2,i)*Epos2(3,2,i)> 0.0) occ2(i) = true;
	//	std::cout << Epos1(1,2,i) << " " << Epos1(2,2,i) << " " << Epos1(3,2,i) << " " << occ1(i) << "    "
	//		  << Epos2(1,2,i) << " " << Epos2(2,2,i) << " " << Epos2(3,2,i) << " " << occ2(i) << std::endl;
    }

    maxsub_partial( total_residue, Epos1, Epos2, occ1, occ2, nali, rms, logeval);
    //std::cout << "TAG : " << tag << ".  NALI: " << nali << ". RMS: " << rms << std::endl;
    if (nali > max_nali){
      max_nali = nali;
      closest_server_tag = tag;
      closest_server_rms = rms;
    }
  }
  return;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

bool
get_maxsub_to_server_models_flag()
{
  static bool init = {false};
  static bool maxsub_to_server_models_flag;

  if (!init) {
    maxsub_to_server_models_flag = truefalseoption("server_models");
    init = true;
  }

  return maxsub_to_server_models_flag;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

void maxsub_to_server_models_output( std::ostream & iunit )
{
  using namespace shotgun;
  iunit <<
    ' ' << I( 7, max_nali ) <<
    ' ' << F( 7, 2, closest_server_rms) <<
    ' ' << A( 15, closest_server_tag );
}

void maxsub_to_server_models_output_header( std::ostream & iunit )
{
  using namespace shotgun;
  iunit <<
    ' ' << A( 7, "srv_mxn") <<
    ' ' << A( 7, "srv_rms") <<
    ' ' << A( 15, "server");
}
