// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 20369 $
//  $Date: 2008-02-13 20:38:22 -0800 (Wed, 13 Feb 2008) $
//  $Author: bblum $

#ifndef INCLUDED_silent_input
#define INCLUDED_silent_input

// Rosetta Headers
#include "param.h"
#include "barcode_classes.h"
#include "bonds_class.h"
#include "pose.h" // need Fold_tree

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// C++ Headers
//#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>

namespace silent_io {

//Utility Headers
#include <utility/basic_sys_util.hh>

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	class Rotamer_template {
	public:
		// access methods
		inline int aa() const;
		inline int aav() const;
		inline int get_natoms() const;
		inline float xyz( int const k, int const j ) const;
		inline FArray2D_float const & xyz() const;

		// distance to another rotamer_template
		// ignores backbone (and HN) atoms
		float distance( Rotamer_template const & t2 ) const;

		// constructors
		Rotamer_template();
		Rotamer_template( int const aa, int const aav, FArray2Da_float xyz_in );
		Rotamer_template( std::istream & is );

		// operator=
		Rotamer_template & operator=( Rotamer_template const & t2 );

		// copy into a coordinate array
		void
		insert(
			FArray2Da_float xyz_inout,
			FArray1Da_float chi,
			bool const rebuild_pro = true

		) const;


	private:
		int aa_;
		int aav_;
		int natoms_;
		FArray2D_float xyz_;
	};

	// stream inserter
	std::ostream& operator <<(
		std::ostream& os,
		Rotamer_template const & t
	);

	// inline functions for Rotamer_template
	inline int Rotamer_template::aa() const { return aa_;}
	inline int Rotamer_template::aav() const { return aav_;}
	inline int Rotamer_template::get_natoms() const { return natoms_;}
	inline float Rotamer_template::xyz(
		int const k,
		int const j
	) const
	{
		assert( 1 <= k && k <= 3 && 1 <= j && j <= natoms_ );
		return xyz_(k,j);
	}

	inline FArray2D_float const & Rotamer_template::xyz() const { return xyz_; }

	/////////////////////////////////////////////////
	// forward definition, needed by Silent_structure
	class Silent_file_data;

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	// Silent_structure holds all the data for a single entry in a silent
	// file
	//
	class Silent_structure {
	public:
		bool fullatom;
		int nres;
		float total_score; // from SCORE line, useful for filtering
		FArray1D_int res;
		FArray1D_int res_variant;
		FArray1D_char secstruct;
		FArray1D_float phi;
		FArray1D_float psi;
		FArray1D_float omega;
		FArray2D_float coords;
		FArray2D_float chi;
		FArray2D_float torsion; //for more general polymers, including RNA
		FArray1D_string name;
		Silent_file_data const * parent;

		// objects for fold_tree and jumps
		// default-constructed
		pose_ns::Fold_tree fold_tree;
		FArray1D< pose_ns::Jump > jump_transform;

		// bond-geometry object. only dimensioned if necessary
		// bonds.nres() == 0 if ideal
		bonds_class::Bonds bonds;

		// alternate rotamer template info; .size1() == 0 if all standard templates
		FArray1D_int rot_template;

		// barcode flavors that may have been enforced in generating this 
		// structure
		barcode_classes::feature_set barcodes;

		// Full coordinate information, for non-ideal decoys whose bond
		// lengths and angles don't follow any template.
		bool full_coord_exists;
		FArray3D_float full_coord;

		// the constructor:
		Silent_structure( int const nres_in, bool const fullatom_in = false) :
			fullatom( fullatom_in ),
			nres( nres_in ),
			total_score( 0.0 ),
			parent( 0 ),
			full_coord_exists( false )
		{
			dimension( nres_in );
		}

		Silent_structure():
			fullatom( false ),
			nres( 0 ),
			parent( 0 ),
			full_coord_exists( false )
		{}

		void dimension(
			int const nres_in
		);

		// destructor
		~Silent_structure() {}

		Silent_structure & operator= (
			Silent_structure const & src
		);

		void fill_pose(
			pose_ns::Pose & pose,
			const bool check_coords = false,
			const bool save_input_score = false
		) const;

		// fills the res array
		void set_sequence(
			std::string const & sequence
		);

		// store fold_tree and jump data that was read from silent-file
// 		void store_tree_and_jumps(
// 			const pose_ns::Fold_tree & fold_tree,
// 			const FArray1D< pose_ns::Jump > & jump_transform
// 		);
	};

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	// DANGER: the Silent_structure pointers in structure_map are the only
	// remaining pointers to data allocated with "new" statememts
	// so this object has the responsibility of freeing any space passed to
	// it via the new_structure method.

	class Silent_file_data {
	public:
		typedef std::map< std::string, Silent_structure* > Structure_map;
		typedef Structure_map::iterator iterator;
		typedef Structure_map::const_iterator const_iterator;
	private:
		// mapping from tags to structure data pointers
		Structure_map structure_map_;

		// handle non-ideal rotamers
		std::map< int, std::vector< Rotamer_template > > rotamer_template_map_;

		// handle Symmetry
		pose_ns::Symmetry_info * symm_info;

	public:

		///////////////////////////////////////////////////////////////////////////
		// constructor
		Silent_file_data():symm_info(0) {};

		// constructor
		Silent_file_data(
			std::string const filename,
			bool const fullatom = false
		);

		// constructor
		Silent_file_data(
			std::string const filename,
			std::vector< std::string > const & desired_tags_in,
			bool const fullatom = false
		);

		///////////////////////////////////////////////////////////////////////////
		// file reader
		bool read_file(
			std::string const filename,
			bool const fullatom = false,
			bool const prepend_filename = false
		);

		// file reader, subset of tags
		bool read_file(
			std::string const filename,
			std::vector< std::string > const & desired_tags,
			bool const fullatom = false,
			bool const prepend_filename = false
		);

		///////////////////////////////////////////////////////////////////////////
		// pointers to structure_map:
		const_iterator begin() const {return structure_map_.begin();}
		const_iterator end() const {return structure_map_.end();}
		int size() const {return structure_map_.size();}
		int nres() const;
		std::string sequence() const;

		inline pose_ns::Symmetry_info * get_symm_info() const { return symm_info; }

		// handle non-ideal rotamers
		bool ideal_rotamers() const;
		std::vector< Rotamer_template > const & rotamer_templates(
			int const seqpos
		) const;

		// get all tags
		std::vector< std::string > tags() const;

		// do we have this tag or not?
		bool has_key( const std::string & tag ) const;

		// filter down to score_fraction of the decoys by total_score
		void
		score_filter(
			float const score_fraction
		);

		// add a new structure to the map
		void new_structure(
			const std::string & tag,
			Silent_structure * new_data
		);

		// assumes that we have checked the tag!!
		Silent_structure const &
		get_structure(
			const std::string & tag
		) const;

		// clean up -- call delete on all pointers in structure_map!
		void clear_structure_map();

		// destructor
		~Silent_file_data() {
			clear_structure_map();
			if ( symm_info ) delete symm_info;
		}

	};

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	// Silent output object
	//

	class Silent_out {
		typedef std::map< int, std::vector<Rotamer_template> > Rotamer_template_map;
	private:
		std::string filename;
		void setup( const pose_ns::Pose & pose );
		bool subset;
		FArray1D_bool output_rsd; // init by setup(...)
		//std::map< int, std::vector< Rotamer_template > > rotamer_template_map_;
		Rotamer_template_map rotamer_template_map_;
		pose_ns::Symmetry_info * symm_info;
	public:
		// clear state information
		void
		reset()
		{ filename.clear(); subset = false; symm_info = 0; }

		// constuctor
		Silent_out() { reset(); };

		// constuctor: filename
		Silent_out ( const std::string filename_in )
		{ reset(); filename = filename_in; }

		//
		~Silent_out() {
			if ( symm_info ) delete symm_info;
		}

		// open: defines filename
		void open( const std::string filename_in ) {
			if ( filename.size() > 0 ) {
				std::cout << "already opened!!" << std::endl;
				utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
			}
			filename = filename_in ;
		}

		// close: prepare to re-open another file
		void close() {
			reset();
		}

		// set the subset of residues to be output:
		void set_subset( int const nres, FArray1D_bool const & rsd );

		// handle non-ideal rotamers
		bool ideal_rotamers() const;
		void store_rotamers( pose_ns::Pose const & pose );
		void set_rotamer_templates(
			//std::map< int, std::vector< Rotamer_template > > const & map_in
			Rotamer_template_map const & map_in
		);
		inline Rotamer_template_map const & rotamer_template_map () const {
			return rotamer_template_map_ ;}
		void get_rot_templates(
			pose_ns::Pose const & pose,
			FArray1D_int & rot_template
		) const;

		// returns TRUE if ok to start; FALSE if decoy already exists
		bool start_decoy( const std::string & decoy_name ) const;

		void append_to_list( const std::string & decoy_name ) const;

		void write( const std::string & decoy_name, const pose_ns::Pose & pose );
		void write_scores( const std::string & decoy_name, const pose_ns::Pose & pose );
	};

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	// generic class for handling decoy output
	//
	// either silent-output or standard decoys
	//
	//


	class Decoy_out {
	public:
		// returns TRUE if already exists
		// if not it will also mark the decoy as started!!!!
		bool decoy_exists(
			std::string const & decoy_name
		);

		void write(
			const std::string & decoy_name,
			const pose_ns::Pose & pose
		);

		// constructor
		Decoy_out( bool const silent_output ):
			silent( silent_output ),
			init( false )
		{};

	private:
		bool silent;

		// if silent-mode:
		Silent_out silent_out;
		std::string silent_filename;

		// if pdb-mode
		std::string pdb_prefix;

		bool init;
		void setup();

		std::string pdb_filename( std::string const & decoy_name ) const;
	};

	void
	dump_compressed_pose(
		std::string const & decoy_name,
		pose_ns::Pose const & pose,
		FArray1D_bool const & output_rsd,
		FArray1D_int const & rot_template,
		pose_ns::Symmetry_info const * const symm_info,
		std::ostream & out
	);



} // namespace silent_io

/////////////////////////////////////////////////////////////////////
//////////////////////////////////////////// function declarations
std::string
files_paths_pdb_out_prefix();

std::string
files_paths_pdb_out_prefix_nochain();

void output_foldtree(pose_ns::Fold_tree const & t, std::ostream & os);

#endif














