// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7803 $
//  $Date: 2006-03-30 23:33:14 -0800 (Thu, 30 Mar 2006) $
//  $Author: chu $

#ifndef INCLUDED_smallmove
#define INCLUDED_smallmove


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <vector>


// smallmove Function Declarations

namespace small_move_param{
	extern float strand_max;
	extern float other_max;
	extern float helix_max;
	extern float temp;
}

void
small_moves_wob(
	int num_in,
	FArray1Da_int list, // list of positions moved
	int & num_out, // number moves actually made
	int & first,
	int & last
);


void
small_moves(
	int num_in,
	FArray1Da_int list, // list of positions moved
	int & num_out, // number moves actually made
	int & first,
	int & last
);


void
set_smallmove_size(
	float helix,
	float strand,
	float other
);


void
shear_moves(
	int num_in,
	FArray1Da_int list, // list of positions moved
	int & num_out, // length of list
	int & first,
	int & last
);


void
coupled_phipsi_moves(
	int num_in,
	FArray1Da_int list, // list of positions moved
	int & num_out,
	int & first,
	int & last
);


void
target_small_moves(
	std::vector< int > target_pos,
	FArray1Da_int list, // list of positions moved
	int & num_out, // number moves actually made
	int & first,
	int & last
);


void
target_shear_moves(
	std::vector< int > target_pos,
	FArray1Da_int list, // list of positions moved
	int & num_out, // length of list
	int & first,
	int & last
);


void
target_small_moves_wob(
	std::vector< int > target_pos, // target positions to move
	FArray1Da_int list, // list of positions moved
	int & num_out, // number moves actually made
	int & first,
	int & last
);


void
target_junction_moves(
 int junction_res
);


#endif
