// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

// author sheffler
//

#ifndef INCLUDED_spline
#define INCLUDED_spline


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/vector1.fwd.hh>

// C++ Headers
#include <cstdlib>
#include <iosfwd>


void
spline_fill_marked_gaps(
	FArray1Da_float x,
	FArray1Da_float y,
	FArray1Da_float dy,
	float badval=-9e9,
	bool verbose = false
);


void
spline_fill_gaps(
	FArray1Da_float x,
	FArray1Da_float y,
	FArray1Da_float dy,
	FArray1Da_bool  good,
	bool verbose = false
);


utility::vector1<float>
spline_second_derivative(
	utility::vector1<float> const & x,
	utility::vector1<float> const & y,
	float yp1,
	float ypn,
	bool verbose = false
);


void
spline_interpolate(
	utility::vector1<float> const & xa,
	utility::vector1<float> const & ya,
	utility::vector1<float> const & y2a,
	float x, float & y, float & dy,
	bool verbose = false
);


bool
test_spline();


#endif
