#ifndef INCLUDED_ObjexxFCL_FArray3DB_FWD_HH
#define INCLUDED_ObjexxFCL_FArray3DB_FWD_HH


// FArray3DB Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray3DB;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray3DB< bool >                FArray3DB_bool;
typedef  FArray3DB< sbyte >                FArray3DB_byte;
typedef  FArray3DB< ubyte >               FArray3DB_ubyte;
typedef  FArray3DB< short int >           FArray3DB_short;
typedef  FArray3DB< int >                 FArray3DB_int;
typedef  FArray3DB< long int >            FArray3DB_long;
typedef  FArray3DB< unsigned short int >  FArray3DB_ushort;
typedef  FArray3DB< unsigned int >        FArray3DB_uint;
typedef  FArray3DB< unsigned long int >   FArray3DB_ulong;
typedef  FArray3DB< std::size_t >         FArray3DB_size_t;
typedef  FArray3DB< std::size_t >         FArray3DB_size;
typedef  FArray3DB< float >               FArray3DB_float;
typedef  FArray3DB< double >              FArray3DB_double;
typedef  FArray3DB< long double >         FArray3DB_longdouble;
typedef  FArray3DB< char >                FArray3DB_char;
typedef  FArray3DB< unsigned char >       FArray3DB_uchar;
typedef  FArray3DB< signed char >         FArray3DB_schar;
typedef  FArray3DB< std::string >         FArray3DB_string;
typedef  FArray3DB< Fstring >             FArray3DB_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray3DB_FWD_HH
