#ifndef INCLUDED_ObjexxFCL_FArray4DB_FWD_HH
#define INCLUDED_ObjexxFCL_FArray4DB_FWD_HH


// FArray4DB Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray4DB;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray4DB< bool >                FArray4DB_bool;
typedef  FArray4DB< sbyte >                FArray4DB_byte;
typedef  FArray4DB< ubyte >               FArray4DB_ubyte;
typedef  FArray4DB< short int >           FArray4DB_short;
typedef  FArray4DB< int >                 FArray4DB_int;
typedef  FArray4DB< long int >            FArray4DB_long;
typedef  FArray4DB< unsigned short int >  FArray4DB_ushort;
typedef  FArray4DB< unsigned int >        FArray4DB_uint;
typedef  FArray4DB< unsigned long int >   FArray4DB_ulong;
typedef  FArray4DB< std::size_t >         FArray4DB_size_t;
typedef  FArray4DB< std::size_t >         FArray4DB_size;
typedef  FArray4DB< float >               FArray4DB_float;
typedef  FArray4DB< double >              FArray4DB_double;
typedef  FArray4DB< long double >         FArray4DB_longdouble;
typedef  FArray4DB< char >                FArray4DB_char;
typedef  FArray4DB< unsigned char >       FArray4DB_uchar;
typedef  FArray4DB< signed char >         FArray4DB_schar;
typedef  FArray4DB< std::string >         FArray4DB_string;
typedef  FArray4DB< Fstring >             FArray4DB_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray4DB_FWD_HH
