#ifndef INCLUDED_ObjexxFCL_FArray5DB_FWD_HH
#define INCLUDED_ObjexxFCL_FArray5DB_FWD_HH


// FArray5DB Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray5DB;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray5DB< bool >                FArray5DB_bool;
typedef  FArray5DB< sbyte >                FArray5DB_byte;
typedef  FArray5DB< ubyte >               FArray5DB_ubyte;
typedef  FArray5DB< short int >           FArray5DB_short;
typedef  FArray5DB< int >                 FArray5DB_int;
typedef  FArray5DB< long int >            FArray5DB_long;
typedef  FArray5DB< unsigned short int >  FArray5DB_ushort;
typedef  FArray5DB< unsigned int >        FArray5DB_uint;
typedef  FArray5DB< unsigned long int >   FArray5DB_ulong;
typedef  FArray5DB< std::size_t >         FArray5DB_size_t;
typedef  FArray5DB< std::size_t >         FArray5DB_size;
typedef  FArray5DB< float >               FArray5DB_float;
typedef  FArray5DB< double >              FArray5DB_double;
typedef  FArray5DB< long double >         FArray5DB_longdouble;
typedef  FArray5DB< char >                FArray5DB_char;
typedef  FArray5DB< unsigned char >       FArray5DB_uchar;
typedef  FArray5DB< signed char >         FArray5DB_schar;
typedef  FArray5DB< std::string >         FArray5DB_string;
typedef  FArray5DB< Fstring >             FArray5DB_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray5DB_FWD_HH
