#ifndef INCLUDED_ObjexxFCL_FArrayB_FWD_HH
#define INCLUDED_ObjexxFCL_FArrayB_FWD_HH


// FArrayB Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArrayB;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArrayB< bool >                FArrayB_bool;
typedef  FArrayB< sbyte >                FArrayB_byte;
typedef  FArrayB< ubyte >               FArrayB_ubyte;
typedef  FArrayB< short int >           FArrayB_short;
typedef  FArrayB< int >                 FArrayB_int;
typedef  FArrayB< long int >            FArrayB_long;
typedef  FArrayB< unsigned short int >  FArrayB_ushort;
typedef  FArrayB< unsigned int >        FArrayB_uint;
typedef  FArrayB< unsigned long int >   FArrayB_ulong;
typedef  FArrayB< std::size_t >         FArrayB_size_t;
typedef  FArrayB< std::size_t >         FArrayB_size;
typedef  FArrayB< float >               FArrayB_float;
typedef  FArrayB< double >              FArrayB_double;
typedef  FArrayB< long double >         FArrayB_longdouble;
typedef  FArrayB< char >                FArrayB_char;
typedef  FArrayB< unsigned char >       FArrayB_uchar;
typedef  FArrayB< signed char >         FArrayB_schar;
typedef  FArrayB< std::string >         FArrayB_string;
typedef  FArrayB< Fstring >             FArrayB_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArrayB_FWD_HH
