// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   numeric/all.hh
/// @brief  numeric package declarations
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_numeric_all_HH
#define INCLUDED_numeric_all_HH


// Classes
#include <numeric/BodyPosition.hh>
#include <numeric/Quaternion.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzTriple.hh>
#include <numeric/xyzVector.hh>

// Functions
#include <numeric/angle.functions.hh>
#include <numeric/conversions.hh>
#include <numeric/numeric.functions.hh>
#include <numeric/trig.functions.hh>
#include <numeric/xyz.functions.hh>

// Interpolation
#include <numeric/interpolation/all.hh>

// I/O
#include <numeric/io.hh>

// Constants
#include <numeric/constants.hh>


#endif // INCLUDED_numeric_all_HH
