// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   numeric/conversions.hh
/// @brief  Conversions between degrees and radians
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_numeric_conversions_HH
#define INCLUDED_numeric_conversions_HH


// Package headers
#include <numeric/NumericTraits.hh>


namespace numeric {
namespace conversions {


/// @brief Radians of degrees
template< typename T >
inline
T
radians( T const & degrees )
{
	return degrees * NumericTraits< T >::degrees_to_radians();
}


/// @brief Radians from degrees
template< typename T >
inline
T &
to_radians( T & degrees )
{
	return degrees *= NumericTraits< T >::degrees_to_radians();
}


/// @brief Degrees of radians
template< typename T >
inline
T
degrees( T const & radians )
{
	return radians * NumericTraits< T >::radians_to_degrees();
}


/// @brief Degrees from radians
template< typename T >
inline
T &
to_degrees( T & radians )
{
	return radians *= NumericTraits< T >::radians_to_degrees();
}


} // namespace conversions
} // namespace numeric


#endif // INCLUDED_numeric_conversions_HH
