// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/...
// (C) 199x-2005 University of Washington
// (C) 199x-2005 University of California Santa Cruz
// (C) 199x-2005 University of California San Francisco
// (C) 199x-2005 Johns Hopkins University
// (C) 199x-2005 University of North Carolina, Chapel Hill
// (C) 199x-2005 Vanderbilt University

/// @file   testing/unittest/TestCase.hh
///
/// @brief  Unit test test cases.
/// @author Ion Yannopoulos
/// @note   Currently a wrapper for Boost.Test.
///         http://www.boost.org/libs/test/doc/components/utf/components/test_case/index.html


#ifndef INCLUDED_testing_unittest_TestCase_HH
#define INCLUDED_testing_unittest_TestCase_HH


// Project forward headers
//- #include <testing/unittest/TestCase.fwd.hh>
 
 
// Project headers


// External library headers
#include <boost/test/unit_test_suite.hpp>


// Macros

// --- Default test cases

/// @brief The most common test case is a free function.
# define TEST_CASE(CASE) \
  TEST_CASE_FUNCTION(CASE)

/// @brief The most common test case is a free function.
#define TEST_CASE_BEGIN(CASE)   \
  TEST_CASE_FUNCTION_BEGIN(CASE)
#define TEST_CASE_END           \
	TEST_CASE_FUNCTION_END


// --- Free functions as test cases

/// @brief Declare a test case as a free function
# define TEST_CASE_FUNCTION(FUNCTION) \
  void FUNCTION();

/// @brief Define the beginning of a free function as test case.
#define TEST_CASE_FUNCTION_BEGIN(FUNCTION) \
	void FUNCTION()               \
	{
/// @brief Define the end of a free function as test case.
#define TEST_CASE_FUNCTION_END  \
	}


// --- Member functions as test cases

/// @brief Declare a test case as method
# define TEST_CASE_METHOD(CLASS, METHOD) \
  void METHOD();

/// @brief Define the beginning of member function as test case.
#define TEST_CASE_METHOD_BEGIN(CLASS, METHOD) \
	void CLASS::METHOD()          \
	{
/// @brief Define the end of member function as test case.
#define TEST_CASE_METHOD_END    \
	}


// --- Classes as test cases

#define TEST_CASE_CLASS(CLASS)  \
  struct CLASS;

/// @brief Define a test case as a full class.
/// Each of the methods of this class will have to be added to the
/// test suite separately.
//  This doesn't (yet) inherit from class TestCase.
#define TEST_CASE_CLASS_BEGIN(CLASS) \
	struct CLASS                  \
    /* : public testing::unittest::TestCase */ \
	{
/// @brief Declare the end of a test case as a class.
#define TEST_CASE_CLASS_END     \
	};



namespace testing {
namespace unittest {

/// @brief Test cases.
typedef boost::unit_test::test_case TestCase;

} // namespace unittest
} // namespace testing


#endif // INCLUDED_testing_unittest_TestCase_HH
