// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/...
// (C) 199x-2005 University of Washington
// (C) 199x-2005 University of California Santa Cruz
// (C) 199x-2005 University of California San Francisco
// (C) 199x-2005 Johns Hopkins University
// (C) 199x-2005 University of North Carolina, Chapel Hill
// (C) 199x-2005 Vanderbilt University

/// @file   testing/unittest/TestMain.hh
///
/// @brief  Unit test test main.
/// @author Ion Yannopoulos


#ifndef INCLUDED_testing_unittest_TestMain_HH
#define INCLUDED_testing_unittest_TestMain_HH


// Project forward headers

 
// Project headers
#include <testing/unittest/TestSuite.hh>

// External library headers
#include <boost/test/unit_test_log.hpp>


// Macros

#define TEST_MAIN(SUITE) \
  testing::unittest::TestSuite* init_unit_test_suite ( int, char*[] ) \
  {                            \
    testing::unittest::TestSuite * suite = new SUITE(); \
		boost::unit_test::unit_test_log.set_threshold_level( \
	    boost::unit_test::log_messages \
    ); \
    return suite;              \
  }
  


#endif // INCLUDED_testing_unittest_TestMain_HH
