// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/basic_sys_util.cc
/// @brief  All system functions in utility that have no other home
/// @author David Kim (dekim@u.washington.edu)
/// @todo   Break out platform-specific code.
/// @todo   Get rid of output messages: unnecessary dependence on <iostream>


// Unit headers
#include <utility/basic_sys_util.hh>

// C++ headers
#include <cmath>
#include <ctime>
#include <iomanip>
#include <iostream>
#include <sstream>

// Platform headers
#ifdef _WIN32
#include <windows.h>
#include <float.h>
#else // Not _WIN32
#include <unistd.h>
#endif // _WIN32

// Boinc headers
#ifdef BOINC
#include <boinc/boinc_rosetta_util.h>
#endif


namespace utility {


/// @brief Sleep for a specified number of seconds
void
sys_sleep( double const seconds )
{
	using std::cout;
	using std::endl;
	using std::fmod;

	cout << "sleep" << endl;

#ifdef _WIN32
	::Sleep( (int) (1000 * seconds) );
#else // Not _WIN32
	unsigned int remaining_time = (int) seconds;
	while ( true ) {
		remaining_time = ::sleep( remaining_time );
		if ( remaining_time == 0 ) break;
		if ( remaining_time > seconds ) break; // paranoia
	}
	int const x = static_cast< int >( fmod( seconds * 1000000, 1000000 ) );
	if ( x ) ::usleep(x);
#endif // _WIN32

	cout << "sleep end" << endl;
}


/// @brief Generate timestamp string
std::string
timestamp()
{
	using std::ostringstream;
	using std::setw;
	using std::time;
	using std::time_t;
	using std::tm;

	time_t currentTime = time( 0 );
	struct tm * now = std::localtime( &currentTime );

	ostringstream timestamp;
	timestamp
	 << "["
	 << setw( 4 ) << ( now->tm_year + 1900 ) << "-"
	 << setw( 2 ) << ( now->tm_mon + 1 ) << "-"
	 << setw( 2 ) << ( now->tm_mday ) << " "
	 << setw( 2 ) << ( now->tm_hour ) << ":"
	 << setw( 2 ) << ( now->tm_min ) << ":"
	 << setw( 2 ) << ( now->tm_sec ) << ":"
	 << "]";

	return timestamp.str();
}


} // namespace utility
