// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/boinc_util.hh
/// @brief  Wrappers to make BOINC work
/// @author David Kim (dekim@u.washington.edu)
/// @note   Diagnostics are defined at http://boinc.berkeley.edu/diagnostics.php


// Unit header
#include <utility/boinc/boinc_util.hh>

// Project headers
#include <utility/basic_sys_util.hh>
#include <utility/file/file_sys_util.hh>

#ifdef BOINC

// External headers: BOINC
// XXX: Need absolute paths
#ifdef _WIN32
#include <boinc_win.h>
#endif
#include <boinc_api.h>
#include <diagnostics.h>

// C++ headers
#include <cstdlib>
#include <iostream>


namespace utility {
namespace boinc {

void
initialize()
{
	using std::cout;
	using std::endl;
	using std::exit;
	using utility::timestamp;

	int rc = 0;
	rc = boinc_init_diagnostics(BOINC_DIAG_DUMPCALLSTACKENABLED);
	if ( rc ) exit( EXIT_FAILURE );
	rc = boinc_init_diagnostics(BOINC_DIAG_HEAPCHECKENABLED);
	if ( rc ) exit( EXIT_FAILURE );
	//rc = boinc_init_diagnostics(BOINC_DIAG_MEMORYLEAKCHECKENABLED);
	//if ( rc ) exit( EXIT_FAILURE );
	//rc = boinc_init_diagnostics(BOINC_DIAG_ARCHIVESTDERR);
	//if ( rc ) exit( EXIT_FAILURE );
	//rc = boinc_init_diagnostics(BOINC_DIAG_ARCHIVESTDOUT);
	//if ( rc ) exit( EXIT_FAILURE );
	rc = boinc_init_diagnostics(BOINC_DIAG_REDIRECTSTDERR);
	if ( rc ) exit( EXIT_FAILURE );
	rc = boinc_init_diagnostics(BOINC_DIAG_REDIRECTSTDOUT);
	if ( rc ) exit( EXIT_FAILURE );
	//rc = boinc_init_diagnostics(BOINC_DIAG_REDIRECTSTDERROVERWRITE);
	//if ( rc ) exit( EXIT_FAILURE );
	//rc = boinc_init_diagnostics(BOINC_DIAG_REDIRECTSTDOUTOVERWRITE);
	//if ( rc ) exit( EXIT_FAILURE );
	//rc = boinc_init_diagnostics(BOINC_DIAG_TRACETOSTDERR);
	//if ( rc ) exit( EXIT_FAILURE );
	//rc = boinc_init_diagnostics(BOINC_DIAG_TRACETOSTDOUT);
	//if ( rc ) exit( EXIT_FAILURE );
	cout << timestamp() << " :: BOINC :: boinc_init()" << endl;
	if ( boinc_init() ) exit( EXIT_FAILURE ); // No I/O until after boinc_init() is called
}


/// @brief Convert logical file names to physical names
void
resolve_filename( std::string & filename )
{
	using std::cout;
	using std::endl;
	using utility::file::file_exists;

	// first check if file exists
	if ( !file_exists( filename ) ) return;
	char resolved_name[ 512 ];
	if ( ::boinc_resolve_filename( filename.c_str(), resolved_name, sizeof( resolved_name ) ) ) {
		cout << "BOINC WARNING: can't resolve filename " << filename << endl;
	}
	filename = resolved_name;
}



} // namespace boinc
} // namespace utility

#endif
