// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/file/file_sys_util.hh
/// @brief  Platform independent operations on files (except I/O)
/// @author David Kim (dekim@u.washington.edu)
/// @author Ion Yannopoulos (ion@rosettacommons.org)


#ifndef INCLUDED_utility_file_file_sys_util_HH
#define INCLUDED_utility_file_file_sys_util_HH


// C++ headers
#include <string>
#include <fstream>


namespace utility {
namespace file {


/// @brief Does file exist?
bool
file_exists( std::string const & path );


/// @brief Delete file
int
file_delete( std::string const & path );


/// @brief Extension of a file name
std::string
file_extension( std::string const & filename );


/// @brief File size
long
file_size( std::string const & filename );


/// @brief Create a blank file if it doesn't already exist
bool
create_blank_file( std::string const & blank_file );


/// @brief Try to open file for read a few times just in case it is locked (from BOINC LIB)
bool
trytry_ifstream_open(
	std::ifstream & ifstream_,
	std::string const & name,
	std::ios_base::openmode open_mode
);


/// @brief Try to open file for write a few times just in case it is locked (from BOINC LIB)
bool
trytry_ofstream_open(
	std::ofstream & ofstream_,
	std::string const & name,
	std::ios_base::openmode open_mode
);


} // namespace file
} // namespace utility


#endif // INCLUDED_utility_file_file_sys_util_HH
