// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/keys/KeyLess.hh
/// @brief  Key comparison functor template
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
///
/// @note
///  @li Types must have key() member functions and comparable keys


#ifndef INCLUDED_utility_keys_KeyLess_HH
#define INCLUDED_utility_keys_KeyLess_HH


namespace utility {
namespace keys {


/// @brief Key member comparison functor template
template< typename T, typename U >
class KeyLess
{


public: // Methods


	/// @brief Functor operator
	inline
	bool
	operator ()( T const & t, U const & u ) const
	{
		return ( t.key() < u.key() );
	}


}; // KeyLess


/// @brief Key member comparison functor template for pointers
template< typename T, typename U >
class PointerKeyLess
{


public: // Methods


	/// @brief Functor operator
	inline
	bool
	operator ()( T const & t, U const & u ) const
	{
		return ( t->key() < u->key() );
	}


}; // PointerKeyLess


} // namespace keys
} // namespace utility


#endif // INCLUDED_utility_keys_KeyLess_HH
