// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/options/AnyOption.hh
/// @brief  Program any scalar-valued option abstract base class
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_utility_options_AnyOption_HH
#define INCLUDED_utility_options_AnyOption_HH


// Unit headers
#include <utility/options/AnyOption.fwd.hh>

// Package headers
#include <utility/options/ScalarOption_T_.hh>
#include <utility/options/keys/AnyOptionKey.hh>


namespace utility {
namespace options {


/// @brief Program any scalar-valued option abstract base class
template< typename T >
class AnyOption :
	public ScalarOption_T_< AnyOptionKey, T >
{


private: // Types


	typedef  ScalarOption_T_< AnyOptionKey, T >  Super;


public: // Types


	// STL/boost style
	typedef  AnyOptionKey  key_type;
	typedef  T  value_type;

	// Project style
	typedef  AnyOptionKey  Key;
	typedef  T  Value;


protected: // Creation


	/// @brief Default constructor
	inline
	AnyOption()
	{}


	/// @brief Copy constructor
	inline
	AnyOption( AnyOption const & option ) :
		Super( option )
	{}


	/// @brief Key + description constructor
	inline
	AnyOption(
		AnyOptionKey const & key_a,
		std::string const & description_a
	) :
		Super( key_a, description_a )
	{}


public: // Creation


	/// @brief Clone this
	virtual
	AnyOption *
	clone() const = 0;


	/// @brief Destructor
	inline
	virtual
	~AnyOption()
	{}


protected: // Assignment


	/// @brief Copy assignment
	inline
	AnyOption &
	operator =( AnyOption const & option )
	{
		if ( this != &option ) {
			Super::operator =( option );
		}
		return *this;
	}


public: // Properties


	/// @brief Option type code string representation
	inline
	std::string
	type_string() const
	{
		return "A";
	}


}; // AnyOption


} // namespace options
} // namespace utility


#endif // INCLUDED_utility_options_AnyOption_HH
