// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/options/AnyVectorOption.hh
/// @brief  Program any vector-valued option abstract base class
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_utility_options_AnyVectorOption_HH
#define INCLUDED_utility_options_AnyVectorOption_HH


// Unit headers
#include <utility/options/AnyVectorOption.fwd.hh>

// Package headers
#include <utility/options/VectorOption_T_.hh>
#include <utility/options/keys/AnyVectorOptionKey.hh>


namespace utility {
namespace options {


/// @brief Program any vector-valued option abstract base class
template< typename T >
class AnyVectorOption :
	public VectorOption_T_< AnyVectorOptionKey, T >
{


private: // Types


	typedef  VectorOption_T_< AnyVectorOptionKey, T >  Super;


public: // Types


	// STL/boost style
	typedef  AnyVectorOptionKey  key_type;
	typedef  T  value_type;

	// Project style
	typedef  AnyVectorOptionKey  Key;
	typedef  T  Value;


protected: // Creation


	/// @brief Default constructor
	inline
	AnyVectorOption()
	{}


	/// @brief Copy constructor
	inline
	AnyVectorOption( AnyVectorOption const & option ) :
		Super( option )
	{}


	/// @brief Key + description constructor
	inline
	AnyVectorOption(
		AnyVectorOptionKey const & key_a,
		std::string const & description_a
	) :
		Super( key_a, description_a )
	{}


public: // Creation


	/// @brief Clone this
	virtual
	AnyVectorOption *
	clone() const = 0;


	/// @brief Destructor
	inline
	virtual
	~AnyVectorOption()
	{}


protected: // Assignment


	/// @brief Copy assignment
	inline
	AnyVectorOption &
	operator =( AnyVectorOption const & option )
	{
		if ( this != &option ) {
			Super::operator =( option );
		}
		return *this;
	}


public: // Properties


	/// @brief Option type code string representation
	inline
	std::string
	type_string() const
	{
		return "(A" + Super::size_constraint_string() + ')';
	}


}; // AnyVectorOption


} // namespace options
} // namespace utility


#endif // INCLUDED_utility_options_AnyVectorOption_HH
