// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/pointer/owning_ptr.functions.hh
/// @brief  owning_ptr acquire and release functions
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
///
/// @remarks
///  @li Objects owned by owning_ptr should inherit from ReferenceCount to get the
///      reference counting mechanism and the add_ref and remove_ref functions.


#ifndef INCLUDED_utility_pointer_owning_ptr_functions_HH
#define INCLUDED_utility_pointer_owning_ptr_functions_HH


namespace utility {
namespace pointer {


/// @brief Add a reference to the object acquired by an owning_ptr
template< typename T >
inline
void
owning_ptr_acquire( T * p )
{
	p->add_ref();
}


/// @brief Remove a reference from the object released by an owning_ptr
template< typename T >
inline
void
owning_ptr_release( T * p )
{
	p->remove_ref();
}


} // namespace pointer
} // namespace utility


#endif // INCLUDED_utility_pointer_owning_ptr_functions_HH
