// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/random.functions.hh
/// @brief  Random number generation functions
/// @author Ion Yannopoulos (ion@rosettacommons.org)
///
/// @note   When designing RNGs consider:
///         http://www.sgi.com/tech/stl/RandomNumberGenerator.html


#ifndef INCLUDED_utility_random_functions_HH
#define INCLUDED_utility_random_functions_HH


// C++ headers
#include <cstdlib>


namespace utility {


/// @brief Generic random number generator
/// @note  Default to std::rand in the absence of a better alternative
/// @note  On POSIX systems (e.g. Linux) use drand48 for doubles
template< typename T >
inline
T
random()
{
	using std::rand;

	return static_cast< T >( rand() ) / static_cast< T >( RAND_MAX );
}


/// @brief Generate random doubles.
/// @note  This should probably use C stdlib.h's drand48 if available.
/// @deprecated  Use random<double> instead.
inline
double
drand()
{
	using std::rand;

	return (double)rand() / (double)RAND_MAX;
}


} // namespace utility


#endif // INCLUDED_utility_random_functions_HH
