// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/vector1.fwd.hh
/// @brief  utility::vector1 forward declarations
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_utility_vector1_FWD_HH
#define INCLUDED_utility_vector1_FWD_HH


// Platform headers
#include <platform/types.hh>

// C++ headers
#include <cstddef>


// std::allocator Declaration
#ifdef UNUSUAL_ALLOCATOR_DECLARATION

// C++ headers
#include <vector>

#else

// Faster but not 100% portable
namespace std { template< typename > class allocator; }

#endif // UNUSUAL_ALLOCATOR_DECLARATION


namespace utility {


// Forward
template< typename T, typename A = std::allocator< T > > class vector1;


// Types
typedef  vector1< bool >                vector1_bool;
typedef  vector1< short int >           vector1_short;
typedef  vector1< int >                 vector1_int;
typedef  vector1< long int >            vector1_long;
typedef  vector1< unsigned short int >  vector1_ushort;
typedef  vector1< unsigned int >        vector1_uint;
typedef  vector1< unsigned long int >   vector1_ulong;
typedef  vector1< std::size_t >         vector1_size_t;
typedef  vector1< std::size_t >         vector1_size;
typedef  vector1< ssize_t >             vector1_ssize_t;
typedef  vector1< ssize_t >             vector1_ssize;
typedef  vector1< float >               vector1_float;
typedef  vector1< double >              vector1_double;
typedef  vector1< long double >         vector1_longdouble;
typedef  vector1< char >                vector1_char;
typedef  vector1< unsigned char >       vector1_uchar;
typedef  vector1< signed char >         vector1_schar;


} // namespace utility


#endif // INCLUDED_utility_vector1_FWD_HH
