// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_ssblocks
#define INCLUDED_ssblocks


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <iosfwd>


// ssblocks Function Declarations


bool
get_ssblock_state();

bool
get_barcode_state();

void
identify_ssblocks();


void
decide_block_state();


void
block_rank_frags( int size );


void
score_frag_block_heap(
	int & size,
	int & ires,
	FArray1Da_int frag_block_pointer,
	int & block_frag_depth
);

void
barcode_score_frag_block_heap(
	int & size,
	int & ires,
	FArray1Da_int frag_block_pointer,
	int & block_frag_depth
);

void
output_block_state( std::ostream & iunit );


float
mismatch_frag_block(
	int const frag_begin,
	int const size
);


void
scoreall_frag_block( int const size );


void
score_frag_block(
	int const size,
	int & ires,
	FArray1Da_int frag_block_pointer,
	int & block_frag_depth
);


void
heap_init(
	FArray1Da_int heap,
	FArray1Da_float coheap,
	int max_items
);


void
heap_extract(
	FArray1Da_int heap, // convert to zero offset matrix
	FArray1Da_float coheap,
	int & val,
	float & coval,
	bool & err
);


void
heap_insert(
	FArray1Da_int heap, // convert to zero offset matrix
	FArray1Da_float coheap,
	int val,
	float coval,
	bool & err
);


void
heap_replace(
	FArray1Da_int heap, // convert to zero offset matrix
	FArray1Da_float coheap,
	int val,
	float coval
);


void
heap_down(
	FArray1Da_int heap, // convert to zero offset matrix
	FArray1Da_float coheap,
	int index_in
);


void
heap_up(
	FArray1Da_int heap, // convert to zero offset matrix
	FArray1Da_float coheap,
	int & index_in
);


#endif
