// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $


// Rosetta Headers
#include "start.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Dp.hh>

// Using
using namespace param;


namespace start {


//car Starting conformation


namespace start_pose {
	bool start_initialized = { false };
	FArray1D_int start_res( MAX_RES() );
	FArray1D_int start_res_variant( MAX_RES() );
	FArray1D_float start_phi( MAX_RES() );
	FArray1D_float start_psi( MAX_RES() );
	FArray1D_float start_omega( MAX_RES() );
	FArray2D_float start_position( 3, MAX_POS * MAX_RES() );
	FArray3Dp_float Estart_position( start_position, 3, MAX_POS, MAX_RES() ); // 3D view
	FArray2D_float start_centroid( 3, MAX_RES() );
	FArray3D_float start_fullcoord( 3, MAX_ATOM(), MAX_RES() );
	float start_rms;
	FArray1D_string start_name( MAX_RES(), std::string( 4, ' ' ) );
	FArray1D_char start_secstruct( MAX_RES(), ' ' );
}


namespace start_logical {
	FArray1D_bool start_allow_insert( MAX_RES() );
}


namespace start_bond_param {
	FArray2D_float st_cb_phi_offset( DRange( -1, 1 ), MAX_RES() );
	FArray2D_float st_ox_psi_offset( DRange( -1, 1 ), MAX_RES() );
	FArray3D_float st_D( 5, DRange( -1, 1 ), DRange( 0, MAX_RES() + 1 ) );
	FArray3D_float st_angle( 5, DRange( -1, 1 ), DRange( 0, MAX_RES() + 1 ) );
	FArray3D_float st_cT( 5, DRange( -1, 1 ), DRange( 0, MAX_RES() + 1 ) );
	FArray3D_float st_sT( 5, DRange( -1, 1 ), DRange( 0, MAX_RES() + 1 ) );
	FArray3D_float st_default_template( 3, 3, DRange( -1, 1 ) );
}


}
