// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision:
//  $Date:
//  $Author:

#ifndef INCLUDED_surface_h
#define INCLUDED_surface_h

// Rosetta Headers
#include "SurfaceMode.h"

// ObjexxFCL Headers
#include <vector>
#include <numeric/xyzVector.hh>

class Surface {

//============================================================================
//
//     Surface mode
//	kosta makrodimitris 2006-02
//===========================================================================
private:

 std::vector<double> plane123 ;
 Surface(const Surface & S);
 Surface & operator=(const Surface & S);


public:
//constructors and destructor
	Surface();

	~Surface();


//////////////////////////////////////////////////////////////////

numeric::xyzVector<double>
parametric_line	( numeric::xyzVector<double> point, double t,
				  numeric::xyzVector<double> parallel_vector );


numeric::xyzVector<double>
normalto3points ( numeric::xyzVector<double> Apoint,
				  numeric::xyzVector<double> Bpoint,
				  numeric::xyzVector<double> Cpoint );


numeric::xyzVector<double>
point2lines2 ( numeric::xyzVector<double> Bpoint,
			   numeric::xyzVector<double> Cpoint,
			   numeric::xyzVector<double> Bvector,
							numeric::xyzVector<double> Cvector );

numeric::xyzVector<double>
point2lines3 ( numeric::xyzVector<double> Bpoint,
			   numeric::xyzVector<double> Cpoint,
			   numeric::xyzVector<double> Bvector,
			   numeric::xyzVector<double> Cvector );

std::vector<double>
plane3points ( numeric::xyzVector<double> Apoint,
			   numeric::xyzVector<double> Bpoint,
			   numeric::xyzVector<double> Cpoint );

numeric::xyzVector<double>
point_intersect_plane ( std::vector<double>  plane_abcd ,
						numeric::xyzVector<double> point_outofplane,
						numeric::xyzVector<double> normal_plane );

////////////////////////////////////////////////////////////////////////
//=======================================================================
};


#endif

