// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   numeric/conversions.test.hh
/// @brief  numeric::conversions test suite
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)


// Test headers
#include <numeric/conversions.test.hh>

// Package headers
#include <numeric/conversions.hh>


namespace test {
namespace numeric {
namespace conversions {


// --------------- Fixtures --------------- //

// --- define a test fixture (some initial state that several tests share)
TEST_FIXTURE_BEGIN( fixture_conversions )


// Shared initialization goes here.  (invoked when TEST_FIXTURE_USE is called)
TEST_FIXTURE_SETUP_BEGIN( fixture_conversions )
{
	delta_percent = 0.0001;
}
TEST_FIXTURE_SETUP_END


// Shared finalization goes here.  (invoked when a test case that uses the fixture ends)
TEST_FIXTURE_TEARDOWN_BEGIN( fixture_conversions )
{
}
TEST_FIXTURE_TEARDOWN_END


// Shared data elements go here.  (They will be declared public.)

double delta_percent; // percentage difference for floating-point comparisons in TEST_CHECK_CLOSE

TEST_FIXTURE_END  // fixture_conversions


// --------------- Test Suites --------------- //

TEST_SUITE_BEGIN(Tests_conversions)
	TEST_SUITE_USES_CASE( test_conversions_general );
TEST_SUITE_END


// --------------- Test Cases --------------- //

/// @brief general conversion tests
TEST_CASE_BEGIN(test_conversions_general)
{
	using ::numeric::conversions::degrees;
	using ::numeric::conversions::radians;
	using ::numeric::conversions::to_degrees;
	using ::numeric::conversions::to_radians;
	TEST_FIXTURE_USE( fixture_conversions, fix );

	float rad_f = 1.0f;
	float deg_f = 1.0f;

	TEST_CHECK_CLOSE( degrees( rad_f ), 57.2957795131f, fix.delta_percent );
	TEST_CHECK_CLOSE( radians( deg_f ),  0.0174532925f, fix.delta_percent );

	to_degrees( rad_f );
	TEST_CHECK_CLOSE( rad_f, 57.2957795131f, fix.delta_percent );
	to_radians( deg_f );
	TEST_CHECK_CLOSE( deg_f,  0.0174532925f, fix.delta_percent );

	double rad_d = 1.0;
	double deg_d = 1.0;

	to_degrees( rad_d );
	TEST_CHECK_CLOSE( rad_d, 57.29577951308232087680, fix.delta_percent );
	to_radians( deg_d );
	TEST_CHECK_CLOSE( deg_d,  0.01745329251994329577, fix.delta_percent );
}
TEST_CASE_END


} // namespace conversions
} // namespace numeric
} // namespace test
