#include <testing/unittest/TestCase.hh>

// Put all tests in a anonymous namespace to prevent collisions
// with test case names in other files in this project.
// You do not normally want to put tests in an anonymous namespace:
// this will prevent them from being shared.


namespace {


// --- The default test cases.

TEST_CASE(test_1_1)
TEST_CASE(test_1_2)

TEST_CASE_BEGIN(test_1_1)
TEST_CASE_END

TEST_CASE_BEGIN(test_1_2)
{
}
TEST_CASE_END

// This shouldn't compile: it's missing TEST_CASE_END
// TEST_CASE_BEGIN(test_1)

// This shouldn't compile: it's missing TEST_CASE_END
// TEST_CASE_BEGIN(test_2)
// {
// }


// --- Free function test cases

TEST_CASE_FUNCTION(test_2_1)
TEST_CASE_FUNCTION(test_2_2)

TEST_CASE_FUNCTION_BEGIN(test_2_1)
TEST_CASE_FUNCTION_END

TEST_CASE_FUNCTION_BEGIN(test_2_2)
{
}
TEST_CASE_FUNCTION_END


// --- Member function test cases

TEST_CASE_CLASS_BEGIN(Case_1)
  TEST_CASE(test_1)
  TEST_CASE(test_2)
TEST_CASE_CLASS_END

TEST_CASE_METHOD_BEGIN(Case_1, test_1)
{
}
TEST_CASE_METHOD_END

TEST_CASE_METHOD_BEGIN(Case_1, test_2)
{
}
TEST_CASE_METHOD_END


} // anonymous namespace
