#include <testing/unittest/TestSuite.hh>
#include <testing/unittest/TestCase.hh>
#include <testing/unittest/TestFixture.hh>
#include <testing/unittest/Tests.hh>


// Put all tests in a anonymous namespace to prevent collisions
// with test case names in other files in this project.
// You do not normally want to put tests in an anonymous namespace:
// this will prevent them from being shared.


namespace {


// --- The default test suite, and default test cases.


TEST_SUITE(Suite_1)

TEST_CASE(test_1_1)
TEST_CASE(test_1_2)  

TEST_SUITE_BEGIN(Suite_1)
{
  TEST_SUITE_USES_CASE(test_1_1)
  TEST_SUITE_USES_CASE(test_1_2)
}
TEST_SUITE_END

TEST_CASE_BEGIN(test_1_1)
{
}
TEST_CASE_END

TEST_CASE_BEGIN(test_1_2)
{
}
TEST_CASE_END

// This works as a definition, but isn't part of the suite.
// If the suite is placed at the end undeclared cases can be added to
// the suite.  The only downside to this is that the cases can't be
// shared with suites in other compilation units.
TEST_CASE_BEGIN(test_undeclared)
{
}
TEST_CASE_END


// --- Test suite as free function, test case as free function


TEST_SUITE_FUNCTION(Suite_2)

TEST_CASE_FUNCTION(test_2_1)
TEST_CASE_FUNCTION(test_2_2)

TEST_SUITE_FUNCTION_BEGIN(Suite_2)
{
  TEST_SUITE_USES_FUNCTION_CASE(test_2_1)
  TEST_SUITE_USES_FUNCTION_CASE(test_2_2)
}  
TEST_SUITE_FUNCTION_END

TEST_CASE_FUNCTION_BEGIN(test_2_1)
{
}
TEST_CASE_FUNCTION_END

TEST_CASE_FUNCTION_BEGIN(test_2_2)
{
}
TEST_CASE_FUNCTION_END


// --- Test suite as free function, test case as member function


TEST_SUITE_FUNCTION(Suite_3)

TEST_CASE_CLASS_BEGIN(Case_3)
  TEST_CASE_METHOD(Case_3, test_3_1)
  TEST_CASE_METHOD(Case_3, test_3_2)
TEST_CASE_CLASS_END

TEST_SUITE_FUNCTION_BEGIN(Suite_3)
{
  TEST_SUITE_USES_METHOD_CASE(Case_3, test_3_1)
  TEST_SUITE_USES_METHOD_CASE(Case_3, test_3_2)
}  
TEST_SUITE_FUNCTION_END

TEST_CASE_METHOD_BEGIN(Case_3, test_3_1)
{
}
TEST_CASE_METHOD_END

TEST_CASE_METHOD_BEGIN(Case_3, test_3_2)
{
}
TEST_CASE_METHOD_END


// --- Test suite as class, test case as free function


TEST_SUITE_CLASS(Suite_4)

TEST_CASE_FUNCTION(test_4_1)
TEST_CASE_FUNCTION(test_4_2)

TEST_SUITE_CLASS_BEGIN(Suite_4)
  TEST_SUITE_USES_FUNCTION_CASE(test_4_1)
  TEST_SUITE_USES_FUNCTION_CASE(test_4_2)
TEST_SUITE_CLASS_END

TEST_CASE_FUNCTION_BEGIN(test_4_1)
TEST_CASE_FUNCTION_END

TEST_CASE_FUNCTION_BEGIN(test_4_2)
{
}
TEST_CASE_FUNCTION_END


// --- Test suite as class, test case as member function


TEST_SUITE_CLASS(Suite_5)

TEST_CASE_CLASS_BEGIN(Case_5)
  TEST_CASE_METHOD(Case_5, test_5_1)
  TEST_CASE_METHOD(Case_5, test_5_2)
TEST_CASE_CLASS_END

TEST_SUITE_CLASS_BEGIN(Suite_5)
  TEST_SUITE_USES_METHOD_CASE(Case_5, test_5_1)
  TEST_SUITE_USES_METHOD_CASE(Case_5, test_5_2)
TEST_SUITE_CLASS_END

TEST_CASE_METHOD_BEGIN(Case_5, test_5_1)
TEST_CASE_METHOD_END

TEST_CASE_METHOD_BEGIN(Case_5, test_5_2)
{
}
TEST_CASE_METHOD_END


// --- Test suite as free function, test suites used as free functions


TEST_SUITE_FUNCTION(Suite_6)

TEST_SUITE_FUNCTION_BEGIN(Suite_6)
  TEST_SUITE_USES_FUNCTION_SUITE(, Suite_2)
  TEST_SUITE_USES_FUNCTION_SUITE(, Suite_3)
  // This works, even though it shouldn't.
  // TEST_SUITE_USES_FUNCTION_SUITE(, Suite_3)
TEST_SUITE_FUNCTION_END


// --- Test suite as free function, test suites used as classes


TEST_SUITE_FUNCTION(Suite_7)

TEST_SUITE_FUNCTION_BEGIN(Suite_7)
  TEST_SUITE_USES_CLASS_SUITE(, Suite_4)
  TEST_SUITE_USES_CLASS_SUITE(, Suite_5)
TEST_SUITE_FUNCTION_END


// --- Test suite as class, test suites used as free functions


TEST_SUITE_CLASS(Suite_8)

TEST_SUITE_CLASS_BEGIN(Suite_8)
  TEST_SUITE_USES_FUNCTION_SUITE(, Suite_2)
  TEST_SUITE_USES_FUNCTION_SUITE(, Suite_3)
TEST_SUITE_CLASS_END


// --- Test suite as class, test suites used as classes


TEST_SUITE_CLASS(Suite_9)

TEST_SUITE_CLASS_BEGIN(Suite_9)
  TEST_SUITE_USES_CLASS_SUITE(, Suite_4)
  TEST_SUITE_USES_CLASS_SUITE(, Suite_5)
TEST_SUITE_CLASS_END


// --- Test suite dependencies

TEST_SUITE(Suite_10)

TEST_CASE(test_10_1)
TEST_CASE(test_10_2)

TEST_SUITE_BEGIN(Suite_10)
  TEST_SUITE_USES_CASE(test_10_1)
  TEST_SUITE_USES_CASE(test_10_2)
  TEST_SUITE_DEPENDS(test_10_1, test_10_2)
TEST_SUITE_CLASS_END

TEST_CASE_BEGIN(test_10_1)
TEST_CASE_END

TEST_CASE_BEGIN(test_10_2)
{
}
TEST_CASE_END


// --- Test cases with fixtures


TEST_FIXTURE_BEGIN(Fixture_11)
  TEST_FIXTURE_SETUP_BEGIN(Fixture_11)
  {
  }
  TEST_FIXTURE_SETUP_END
  TEST_FIXTURE_TEARDOWN_BEGIN(Fixture_11)
  {
  }
  TEST_FIXTURE_TEARDOWN_END
  int integer;
  float real;
  char * c_string;
  char c_array[15];
TEST_FIXTURE_END

TEST_SUITE(Suite_11)

TEST_CASE(test_11_1)
TEST_CASE(test_11_2)

TEST_SUITE_BEGIN(Suite_11)
  TEST_SUITE_USES_CASE(test_11_1)
  TEST_SUITE_USES_CASE(test_11_2)
TEST_SUITE_END

TEST_CASE_BEGIN(test_11_1)
{
  TEST_FIXTURE_USE(Fixture_11, test);
}
TEST_CASE_END

TEST_CASE_BEGIN(test_11_2)
{
  TEST_FIXTURE_USE(Fixture_11, test);
}
TEST_CASE_END


// --- Test cases with fixtures


TEST_SUITE(All_Suites)

TEST_SUITE_BEGIN(All_Suites)
  TEST_SUITE_USES_SUITE(, Suite_1)
  TEST_SUITE_USES_FUNCTION_SUITE(, Suite_2)
  TEST_SUITE_USES_FUNCTION_SUITE(, Suite_3)
  TEST_SUITE_USES_CLASS_SUITE(, Suite_4)
  TEST_SUITE_USES_CLASS_SUITE(, Suite_5)
  TEST_SUITE_USES_FUNCTION_SUITE(, Suite_6)
  TEST_SUITE_USES_FUNCTION_SUITE(, Suite_7)
  TEST_SUITE_USES_CLASS_SUITE(, Suite_8)
  TEST_SUITE_USES_CLASS_SUITE(, Suite_9)
  TEST_SUITE_USES_SUITE(, Suite_10)
  TEST_SUITE_USES_SUITE(, Suite_11)
TEST_SUITE_END


} // anonymous namespace
