// NOTE:  All tests commented out by //- are tests which warn at compile-time.


// Test headers
#include <testing/unittest/Tests.test.hh>

// C++ headers
#include <algorithm>
#include <vector>


namespace outer {
namespace inner {


// --- Suite of all Tests.hh tests

TEST_SUITE_BEGIN(Tests_Tests)
  TEST_SUITE_USES_SUITE(outer::inner, Note_Tests)
  TEST_SUITE_USES_SUITE(outer::inner, Check_Tests)
  TEST_SUITE_USES_SUITE(outer::inner, Require_Tests)
TEST_SUITE_END


// --- TEST_NOTE_* tests

TEST_SUITE_BEGIN(Note_Tests)
  TEST_SUITE_USES_CASE(test_note)
  TEST_SUITE_USES_CASE(test_note_message)
  TEST_SUITE_USES_CASE(test_note_equal)
  TEST_SUITE_USES_CASE(test_note_equal_bitwise)
  TEST_SUITE_USES_CASE(test_note_close)
  TEST_SUITE_USES_CASE(test_note_equal_range)
  TEST_SUITE_USES_CASE(test_note_equal_collection)
  TEST_SUITE_USES_CASE(test_warn)
TEST_SUITE_END


TEST_CASE_BEGIN(test_note)
{
  TEST_NOTE(true);
}
TEST_CASE_END


TEST_CASE_BEGIN(test_note_message)
{
  TEST_NOTE_MESSAGE(false, "A message");
}
TEST_CASE_END


TEST_CASE_BEGIN(test_note_equal)
{
  TEST_NOTE_EQUAL(0, 0);
  //- TEST_NOTE_EQUAL(0, 1);        // Should fail
}
TEST_CASE_END


TEST_CASE_BEGIN(test_note_equal_bitwise)
{
  short ss = -1;
  //- unsigned short us = -1U;
  long sl = -1L;
  //- unsigned long ul = -1UL;
  //- TEST_NOTE_EQUAL_BITWISE((unsigned)ss, us);
  TEST_NOTE_EQUAL_BITWISE(ss, sl);
  //- TEST_NOTE_EQUAL_BITWISE(us, ul);
}
TEST_CASE_END


TEST_CASE_BEGIN(test_note_close)
{
  TEST_NOTE_CLOSE(1.0, 1.000, 0.1);
  TEST_NOTE_CLOSE(1.0, static_cast<double>(1), 0.1);
  TEST_NOTE_CLOSE(1.0, 1.0001, 0.0001); // Should fail
  TEST_NOTE_CLOSE(1.0, 1.0001, 0.1);
  TEST_NOTE_CLOSE(1.0, 1.1, 0.0001); // Should fail
}
TEST_CASE_END


TEST_CASE_BEGIN(test_note_equal_range)
{
  using std::fill;
  using std::vector;

  const int size = 11;
  vector<int> v1(size), v2(size), v3(size);

  fill(v1.begin(), v1.end(), 1);
  fill(v2.begin(), v2.end(), 1);
  fill(v3.begin(), v3.end(), 1);
  v3[v3.size() - 1] = 2;

  TEST_NOTE_EQUAL_RANGE(v1.begin(), v1.end(), v2.begin(), v2.end());
  TEST_NOTE_EQUAL_RANGE(v1.begin(), v1.end(), v3.begin(), v3.end());
  // Should fail
  TEST_NOTE_EQUAL_RANGE(v1.begin(), v1.end() - 1, v3.begin(), v3.end() - 1);
}
TEST_CASE_END


TEST_CASE_BEGIN(test_note_equal_collection)
{
  using std::fill;
  using std::vector;

  const int size = 11;
  vector<int> v1(size), v2(size), v3(size);

  fill(v1.begin(), v1.end(), 1);
  fill(v2.begin(), v2.end(), 1);
  fill(v3.begin(), v3.end(), 1);
  v3[v3.size() - 1] = 2;

  TEST_NOTE_EQUAL_COLLECTION(v1, v2);
  TEST_NOTE_EQUAL_COLLECTION(v1, v3); // Should fail
}
TEST_CASE_END


TEST_CASE_BEGIN(test_warn)
{
  TEST_WARN("A warning message");
}
TEST_CASE_END


// --- TEST_CHECK_* tests


TEST_SUITE_BEGIN(Check_Tests)
  TEST_SUITE_USES_CASE(test_check)
  TEST_SUITE_USES_CASE(test_check_message)
  TEST_SUITE_USES_CASE(test_check_equal)
  TEST_SUITE_USES_CASE(test_check_equal_bitwise)
  TEST_SUITE_USES_CASE(test_check_close)
  TEST_SUITE_USES_CASE(test_check_equal_range)
  TEST_SUITE_USES_CASE(test_check_equal_collection)
  TEST_SUITE_USES_CASE(test_error)
TEST_SUITE_END


TEST_CASE_BEGIN(test_check)
{
  TEST_CHECK(true);
}
TEST_CASE_END


TEST_CASE_BEGIN(test_check_message)
{
  TEST_CHECK_MESSAGE(false, "A message");
}
TEST_CASE_END


TEST_CASE_BEGIN(test_check_equal)
{
  TEST_CHECK_EQUAL(0, 0);
  TEST_CHECK_EQUAL(0, 1);   // Should fail
}
TEST_CASE_END


TEST_CASE_BEGIN(test_check_equal_bitwise)
{
  short ss = -1;
  unsigned short us = -1U;
  long sl = -1L;
  //- unsigned long ul = -1UL;
  TEST_CHECK_EQUAL_BITWISE((unsigned short)ss, us);
  TEST_CHECK_EQUAL_BITWISE(ss, sl);
  //- TEST_CHECK_EQUAL_BITWISE(us, ul);
}
TEST_CASE_END


TEST_CASE_BEGIN(test_check_close)
{
  TEST_CHECK_CLOSE(1.0, 1.000, 0.1);
  TEST_CHECK_CLOSE(1.0, static_cast<double>(1), 0.1);
  TEST_CHECK_CLOSE(1.0, 1.0001, 0.0001); // Should fail
  TEST_CHECK_CLOSE(1.0, 1.0001, 0.1);
  TEST_CHECK_CLOSE(1.0, 1.1, 0.0001); // Should fail
}
TEST_CASE_END


TEST_CASE_BEGIN(test_check_equal_range)
{
  using std::fill;
  using std::vector;

  const int size = 11;
  vector<int> v1(size), v2(size), v3(size);

  fill(v1.begin(), v1.end(), 1);
  fill(v2.begin(), v2.end(), 1);
  fill(v3.begin(), v3.end(), 1);
  v3[v3.size() - 1] = 2;

  TEST_CHECK_EQUAL_RANGE(v1.begin(), v1.end(), v2.begin(), v2.end());
  TEST_CHECK_EQUAL_RANGE(v1.begin(), v1.end(), v3.begin(), v3.end());
  // Should fail
  TEST_CHECK_EQUAL_RANGE(v1.begin(), v1.end() - 1, v3.begin(), v3.end() - 1);
}
TEST_CASE_END


TEST_CASE_BEGIN(test_check_equal_collection)
{
  using std::fill;
  using std::vector;

  const int size = 11;
  vector<int> v1(size), v2(size), v3(size);

  fill(v1.begin(), v1.end(), 1);
  fill(v2.begin(), v2.end(), 1);
  fill(v3.begin(), v3.end(), 1);
  v3[v3.size() - 1] = 2;

  TEST_CHECK_EQUAL_COLLECTION(v1, v2);
  TEST_CHECK_EQUAL_COLLECTION(v1, v3); // Should fail
}
TEST_CASE_END


TEST_CASE_BEGIN(test_error)
{
  TEST_ERROR("An error message");
}
TEST_CASE_END


// --- TEST_REQUIRE_* tests


TEST_SUITE_BEGIN(Require_Tests)
  TEST_SUITE_USES_CASE(test_require)
  TEST_SUITE_USES_CASE(test_require_message)
  TEST_SUITE_USES_CASE(test_require_equal)
  TEST_SUITE_USES_CASE(test_require_equal_bitwise)
  TEST_SUITE_USES_CASE(test_require_close)
  TEST_SUITE_USES_CASE(test_require_equal_range)
  TEST_SUITE_USES_CASE(test_require_equal_collection)
  TEST_SUITE_USES_CASE(test_fatal)
TEST_SUITE_END


TEST_CASE_BEGIN(test_require)
{
  TEST_REQUIRE(true);
}
TEST_CASE_END


TEST_CASE_BEGIN(test_require_message)
{
  TEST_REQUIRE_MESSAGE(false, "A message");
}
TEST_CASE_END


TEST_CASE_BEGIN(test_require_equal)
{
  TEST_REQUIRE_EQUAL(0, 0);
  TEST_REQUIRE_EQUAL(0, 1);   // Should fail
}
TEST_CASE_END


TEST_CASE_BEGIN(test_require_equal_bitwise)
{
  short ss = -1;
  unsigned short us = -1U;
  long sl = -1L;
  //- unsigned long ul = -1UL;
  TEST_REQUIRE_EQUAL_BITWISE((unsigned short)ss, us);
  TEST_REQUIRE_EQUAL_BITWISE(ss, sl);
  //- TEST_REQUIRE_EQUAL_BITWISE(us, ul);
}
TEST_CASE_END


TEST_CASE_BEGIN(test_require_close)
{
  TEST_REQUIRE_CLOSE(1.0, 1.000, 0.1);
  TEST_REQUIRE_CLOSE(1.0, static_cast<double>(1), 0.1);
  TEST_REQUIRE_CLOSE(1.0, 1.0001, 0.0001); // Should fail
  TEST_REQUIRE_CLOSE(1.0, 1.0001, 0.1);
  TEST_REQUIRE_CLOSE(1.0, 1.1, 0.0001); // Should fail
}
TEST_CASE_END


TEST_CASE_BEGIN(test_require_equal_range)
{
  using std::fill;
  using std::vector;

  const int size = 11;
  vector<int> v1(size), v2(size), v3(size);

  fill(v1.begin(), v1.end(), 1);
  fill(v2.begin(), v2.end(), 1);
  fill(v3.begin(), v3.end(), 1);
  v3[v3.size() - 1] = 2;

  TEST_REQUIRE_EQUAL_RANGE(v1.begin(), v1.end(), v2.begin(), v2.end());
  TEST_REQUIRE_EQUAL_RANGE(v1.begin(), v1.end(), v3.begin(), v3.end());
  // Should fail
  TEST_REQUIRE_EQUAL_RANGE(v1.begin(), v1.end() - 1, v3.begin(), v3.end() - 1);
}
TEST_CASE_END


TEST_CASE_BEGIN(test_require_equal_collection)
{
  using std::fill;
  using std::vector;

  const int size = 11;
  vector<int> v1(size), v2(size), v3(size);

  fill(v1.begin(), v1.end(), 1);
  fill(v2.begin(), v2.end(), 1);
  fill(v3.begin(), v3.end(), 1);
  v3[v3.size() - 1] = 2;

  TEST_REQUIRE_EQUAL_COLLECTION(v1, v2);
  TEST_REQUIRE_EQUAL_COLLECTION(v1, v3); // Should fail
}
TEST_CASE_END


TEST_CASE_BEGIN(test_fatal)
{
  TEST_FATAL("A fatal error message");
}
TEST_CASE_END


} // namespace
} // namespace
