// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/keys/SmallKeyMap.test.cc
/// @brief  SmallKeyMap unit test suite
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)


// Package headers
#include <utility/keys/SmallKeyMap.test.hh>
#include <utility/keys/SmallKeyMap.hh>


namespace test {
namespace utility {
namespace keys {


// --- set up the test suite
TEST_SUITE_BEGIN(SmallKeyMap_Tests)
	TEST_SUITE_USES_CASE(test_SmallKeyMap_general)
	TEST_SUITE_USES_CASE(test_SmallKeyMap_swap)
TEST_SUITE_END

// --- set up the individual test cases

/// @brief General tests
TEST_CASE_BEGIN(test_SmallKeyMap_general)
{
	typedef  ::utility::keys::SmallKeyMap< int, int >  Map;

	// build initial map with 3 entries
	Map m;
	m.assign( 1, 123 ).assign( 2, 123 ).assign( 3, 123 );
	TEST_CHECK( m.size() == 3 );

	// add 4th entry
	m.assign( 7, 77 );
	TEST_CHECK( m[ 7 ] == 77 );

	// add 5th entry
	m( 8 ) = 88;

	// add 6th entry
	m.add( 12 );
	TEST_CHECK( m.has( 12 ) );
	TEST_CHECK( m[ 12 ] == 0 );
	TEST_CHECK( m.size() == 6 );

	// add 7th entry
	m.add( 22 );
	TEST_CHECK( m[ 22 ] == 0 );
	TEST_CHECK( m.size() == 7 );

	// test shrink
	m.shrink();
	TEST_CHECK( m.capacity() == m.size() );
}
TEST_CASE_END


/// @brief Swap test
TEST_CASE_BEGIN(test_SmallKeyMap_swap)
{
	typedef  ::utility::keys::SmallKeyMap< int, int >  Map;
	Map m;
	m.assign( 3, 33 );
	m.assign( 6, 33 );
	m.assign( 9, 33 );
	Map w;
	w.assign( 3, 66 );
	w.assign( 6, 66 );
	w.assign( 9, 66 );
	w.assign( 12, 66 );
	w.assign( 15, 66 );
	w.assign( 18, 66 );

	// Swap maps
	swap( m, w );
	TEST_CHECK( m.size() == 6 );
	TEST_CHECK( w.size() == 3 );
	TEST_CHECK( m[ 3 ] == 66 );
	TEST_CHECK( w[ 9 ] == 33 );

	// Swap them back
	w.swap( m );
	TEST_CHECK( w.size() == 6 );
	TEST_CHECK( m.size() == 3 );
	TEST_CHECK( w[ 3 ] == 66 );
	TEST_CHECK( m[ 9 ] == 33 );
}
TEST_CASE_END

} // namespace keys
} // namespace utility
} // namespace test
