// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/keys/SmallKeyVector.test.cc
/// @brief  SmallKeyVector unit test suite
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)


// Package headers
#include <utility/keys/SmallKeyVector.test.hh>
#include <utility/keys/SmallKeyVector.hh>


namespace test {
namespace utility {
namespace keys {


// --- set up the test suite
TEST_SUITE_BEGIN(SmallKeyVector_Tests)
	TEST_SUITE_USES_CASE(test_SmallKeyVector_general)
	TEST_SUITE_USES_CASE(test_SmallKeyVector_swap)
TEST_SUITE_END

// --- set up the individual test cases

/// @brief General tests
TEST_CASE_BEGIN(test_SmallKeyVector_general)
{
	typedef  ::utility::keys::SmallKeyVector< int, int >  Vector;

	// create an instance and check starting conditions
	Vector v( 3, 123 );
	TEST_CHECK( v.size() == 3 );

	// add a key/value assignment to the vector
	v.assign( 7, 77 );
	TEST_CHECK( v[ 7 ] == 77 );

	// add a second key/value entry
	v( 8 ) = 88;

	// activate a third entry (but keep default value)
	v.add( 12 );
	TEST_CHECK( v[ 12 ] == 123 );
	TEST_CHECK( v.size() == 3 );

	// add a fourth entry, which should expand the vector size
	v.add( 22 );
	TEST_CHECK( v.size() == 4 );

	// we expanded past original 3 entries, so 4th value should be zero
	TEST_CHECK( v[ 22 ] == 0 );

	// shrink the vector
	v.shrink();
	TEST_CHECK( v.capacity() == v.size() );
}
TEST_CASE_END


/// @brief Swap test
TEST_CASE_BEGIN(test_SmallKeyVector_swap)
{
	typedef  ::utility::keys::SmallKeyVector< int, int >  Vector;
	Vector v( 3, 33 ), w( 6, 66 );
	v.add( 3 );
	v.add( 6 );
	v.add( 9 );

	// Swap vectors
	swap( v, w );
	TEST_CHECK( v.size() == 6 );
	TEST_CHECK( w.size() == 3 );
	TEST_CHECK( v[ Vector::Index( 3u ) ] == 66 ); // 3u gets Index, not Key, accessor
	TEST_CHECK( w[ 9 ] == 33 );

	// Swap them back
	w.swap( v );
	TEST_CHECK( w.size() == 6 );
	TEST_CHECK( v.size() == 3 );
	TEST_CHECK( w[ Vector::Index( 3u ) ] == 66 ); // 3u gets Index, not Key, accessor
	TEST_CHECK( v[ 9 ] == 33 );
}
TEST_CASE_END


} // namespace keys
} // namespace utility
} // namespace test
