// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10221 $
//  $Date: 2006-09-06 16:42:20 -0700 (Wed, 06 Sep 2006) $
//  $Author: bqian $

#ifndef INCLUDED_tether
#define INCLUDED_tether


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// tether Function Declarations


void
tether_reset();


void
tether_set_window_size( int window );


void
tether_set_res_weight(
	int residue,
	float weight
);


void
tether_set_angle_res_weight(
	int residue,
	float weight
);


void
tether_init_residue_weights();


void
tether_setup();


void
calculate_tether_dme( float & tether_dme );


void
calculate_tether_score( float & tether_score );


void
calculate_phipsi_torsion_tether_score(
	float & phipsi_score,
	FArray2Da_float torsion_tether_score_deriv
);


void
calculate_omega_torsion_tether_score(
	float & omega_score,
	FArray2Da_float torsion_tether_score_deriv
);


void
calculate_angle_rms( float & angle_rms );


float
angle_delta(
	float a,
	float b
);

float
get_omega_weight();

void
set_omega_weight_default(float wt);

#endif
