// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8175 $
//  $Date: 2006-05-04 22:55:12 -0700 (Thu, 04 May 2006) $
//  $Author: ion $


// Rosetta Headers
#include "tether_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray4D.hh>

// Using
using namespace param;


namespace tether {


//------tether fixed parameters-------------------

int const max_tether_atoms = { 6 }; // max distances to consider --bb + centroid


//------tether state----------------------

namespace tether_state {
	int tether_window_size;
}


//------tether data------------------------
//car info for tethering to starting structure

namespace tether_data {
	/// @brief Table of ???
	///
	/// Dimensions 1, 2 are # of residues, # of tethered atoms in the @e
	/// 1st ???.
	/// Dimensions 3, 4 are # of residues, # of tethered atoms in the @e
	/// 2nd ???.
	/// The dimensions for #constraint_list are set in #tether_setup.

	FArray4D_float dis2_tether; // N,CA,C,O,sc (or cen)

//mj (1,1,1,1);
	FArray1D_float omega_tether( MAX_RES() );
	FArray1D_float phi_tether( MAX_RES() );
	FArray1D_float psi_tether( MAX_RES() );
	FArray1D_float tether_res_weight( MAX_RES() );
	FArray1D_float tether_angle_res_weight( MAX_RES() );
	float tether_norm;
	int cutoff_atm; // atom to use for distance checks
}


} // namespace tether
