// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef TRIANGLE_ITERATOR_H
#define TRIANGLE_ITERATOR_H

#include "pose.h" // <- needed to get FArrays to work
#include "dim.h"

#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>
#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>
#include <ObjexxFCL/FArray3Dp.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <vector>



class triangleIterator {
 public:
  // Constructors and destructors
  triangleIterator(const FArray3D_float & density, const float & threshold);
  ~triangleIterator();

  // Returns true if there is another triangle.
  bool hasNext() const;

  // Takes three parallel arrays of length three which this methods sets
  // to contain the vertix positions, normals, and velocities, respectively
  // for the next triangle triangle. The precondition is hasNext() is
  // true.
  void next(numeric::xyzVector_float vertices[3], numeric::xyzVector_float normals[3]);

 private:
  typedef std::vector<numeric::xyzVector_float> vecQueue;

  void aquireNextQueue();
  void computeGradient();
  void evalGradient(const numeric::xyzVector_float & pt, numeric::xyzVector_float & gradResult);

  // next indices
  int nextX, nextY, nextZ;

  // grids and dimensions
  float threshold;
  FArray3D_float const * densityPtr;
  FArray4D_float * gradPtr;
  dim_ns::dim size;

  // ques for future triangles
  vecQueue vertQueue;
  vecQueue nrmlQueue;
};

#endif
