// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15337 $
//  $Date: 2007-06-05 16:04:31 -0700 (Tue, 05 Jun 2007) $
//  $Author: johnk $


// Rosetta Headers
#include "uns_protocols.h"
//#include "aa_name_conversion.h"
//#include "aaproperties_pack.h"
//#include "after_opts.h"
#include "decoystats.h"
#include "decoystats_classes.h"
#include "decoystats_interface.h"
#include "decoystats_ns.h"
#include "design.h"
#include "design_structure.h"
#include "files_paths.h"
//#include "fullatom.h"
//#include "fullatom_energies.h"
//#include "fullatom_energy.h"
//#include "fullatom_sasa.h"
//#include "fullatom_setup.h"
//#include "misc.h"
#include "namespace_fullatom_flag.h"
//#include "output_decoy.h"
#include "pack.h"
//#include "pack_geom_inline.h"
//#include "param.h"
//#include "param_aa.h"
//#include "param_pack.h"
//#include "pdb.h"
#include "pose.h"
#include "pose_io.h"
//#include "DesignMap.h"
//#include "PackerTask.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/formatted.io.hh>
#include <ObjexxFCL/string.functions.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <ctime>
#include <fstream>
#include <iostream>
#include <list>
#include <string>
#include <vector>



////////////////////////////////////////////////////////////////////////////////
/// @begin identify_interface_UNS
///
/// @brief
///    find unsatified buried polars in a protein-protein interface
///
/// @detailed
///    protocol involved repacking the interface with solvated rotamers,
///    and comparing UNS to those found in unbound structure when non-Gly interface
///    residues are all replaced with Ala
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors John Karanicolas
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
identify_interface_UNS(){

	using namespace files_paths;
	using namespace misc;

	assert ( fullatom_flag::full_atom == true );

	bool file_exists;
	check_design_pdb_exists(1,file_exists);
	if ( file_exists && !overwrite_pdbs && !touch_before_reading ) {
		std::cout << "this file has already been started - move to next" << std::endl;
		return;
	}
	if ( touch_before_starting ) {
		create_design_pdb_file(1);
	}

	if ( design::fix_interface_UNS_flag ) {

		std::cout << "Starting attempts at fixing interface UNS" << std::endl;
		pose_ns::Pose curr_pose;
		fullatom_nonideal_initialized_pose_from_misc( curr_pose );

		std::cout << "Identifying initial interface UNS" << std::endl;
		interface_ds curr_interface(&curr_pose);
		std::list < unsatisfied_buried_group > curr_delta_group_uns_list =
			curr_interface.get_interface_delta_group_uns_list();
		std::cout << "Initial interface group UNS score is " <<
			total_group_UNS_score( curr_delta_group_uns_list ) << std::endl;

		bool made_repair = true;
		while ( made_repair ) {

			std::list < unsatisfied_buried_group > curr_delta_group_uns_list =
				curr_interface.get_copy_of_interface_delta_group_uns_list();

			// jk Sort the group uns based on priority in which we wish to try and fix them
			curr_delta_group_uns_list.sort();

			made_repair = false;
			for ( std::list<unsatisfied_buried_group>::iterator group_uns = curr_delta_group_uns_list.begin();
						group_uns != curr_delta_group_uns_list.end(); ++group_uns ) {
				made_repair = fix_interface_UNS( curr_pose, curr_interface, *group_uns );
				//				curr_interface.adjust_pointer(&curr_pose);
				if ( made_repair ) break;
			}
		}

		std::cout << "Remaining interface group UNS could not be fixed" << std::endl;
		std::cout << "Final interface group UNS score is " <<
			total_group_UNS_score( curr_delta_group_uns_list ) << std::endl;

	}

	int const run=1;
	design_output( total_residue, res, res_variant, full_coord, run );

	return;

}


////////////////////////////////////////////////////////////////////////////////
/// @begin total_group_UNS_score
///
/// @brief
///    Sum the weights of a group UNS list
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors John Karanicolas
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float total_group_UNS_score(
	std::list < unsatisfied_buried_group > & group_uns_list
){

	float score = 0.;
	for ( std::list<unsatisfied_buried_group>::iterator group_uns = group_uns_list.begin();
				group_uns != group_uns_list.end(); ++group_uns ) {
		score += group_uns->weight();
	}

	return score;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin eval_curr_group_uns_score
///
/// @brief
///    Evaluate the interface group uns score for the current pose
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors John Karanicolas
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float eval_curr_group_uns_score( pose_ns::Pose & pose ){
	interface_ds curr_interface(&pose);
	std::list < unsatisfied_buried_group > curr_delta_group_uns_list =
		curr_interface.get_interface_delta_group_uns_list();
	return total_group_UNS_score( curr_delta_group_uns_list );
}


////////////////////////////////////////////////////////////////////////////////
/// @begin fix_interface_UNS
///
/// @brief
///    Try fixing an interface UNS. Returns true if the UNS was fixed.
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors John Karanicolas
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
bool fix_interface_UNS(
	pose_ns::Pose & start_pose,
	interface_ds & starting_interface,
	unsatisfied_buried_group const & group_uns
){

	pose_ns::Pose curr_pose;
	curr_pose = start_pose;

	std::list < unsatisfied_buried_group > starting_delta_group_uns_list =
		starting_interface.get_interface_delta_group_uns_list();

	float const starting_group_uns_score = total_group_UNS_score( starting_delta_group_uns_list );
	std::cout << "Starting interface group UNS score is " << starting_group_uns_score << std::endl;

	std::cout << "Attempting to fix group UNS of type " << group_uns.get_type_name() <<
		" at seqpos " << group_uns.get_seqpos() << std::endl;


	// JK FILL THIS IN - DO SOMETHING CLEVER TO CURR_POSE

	interface_ds curr_interface(&curr_pose);
	bool acceptable_solution = test_solution( starting_interface, curr_interface );
	if ( acceptable_solution ) {
		std::cout << "Replacing original structure with current" << std::endl;
		start_pose = curr_pose;
		starting_interface = curr_interface;
		starting_interface.adjust_pointer(&start_pose);
		return true;
	}

	std::cout << "All attempted fixes were unsuccessful - retaining original structure" << std::endl;
	return false;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin test_solution
///
/// @brief
///    After building a potentially-fixed interface, decide whether or not it's better
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors John Karanicolas
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
bool test_solution(
	interface_ds & starting_interface,
	interface_ds & curr_interface
){

	if ( starting_interface.num_hotspots() > curr_interface.num_hotspots() ) {
		std::cout << "Hotspot was lost - attempt was unsuccessful" << std::endl;
		return false;
	}

	float max_interface_void_volume_difference =
		curr_interface.get_max_interface_void_volume() - starting_interface.get_max_interface_void_volume();
	if ( max_interface_void_volume_difference > 10. ) {
		std::cout << "A large cavity was created - attempt was unsuccessful" << std::endl;
		return false;
	}

	// JK FILL IN MORE CRITERIA TO GAUGE USEFUL CHANGES?

	std::list < unsatisfied_buried_group > starting_delta_group_uns_list =
		starting_interface.get_interface_delta_group_uns_list();
	float const starting_group_uns_score =
		total_group_UNS_score( starting_delta_group_uns_list );
	std::list < unsatisfied_buried_group > curr_delta_group_uns_list =
		curr_interface.get_interface_delta_group_uns_list();
	float const curr_group_uns_score =
		total_group_UNS_score( curr_delta_group_uns_list );
	if ( starting_group_uns_score < curr_group_uns_score ) {
		std::cout << "Number of group UNS was not reduced - attempt was unsuccessful" << std::endl;
		return false;
	}

	std::cout << "Attempted fix was successful!" << std::endl;
	return true;
}




