#!/bin/csh -f
#
#  $Revision: 11336 $
#  $Date: 2006-11-16 13:36:51 -0800 (Thu, 16 Nov 2006) $
#  $Author: snoeyink $


# This program creates version_rosetta.cc which is hard-coded to write out
# the Subversion revision numbers of the Rosetta source files from which it
# has been created.

# Revision numbers are extracted from the following sources:
# (whichever is successful first)
#
# 1. Running 'svn status'
# 2. A file called .version generated the last time svn status was run.
#
# 1. is the most up-to-date answer for people with access to the repository.
# However for anyone who does not have such access, the repository information
# is cached in a .version file, which will made up-to-date on each commit.
# While the files currently have $Revision: 11336 $ tags those numbers are the last
# time the file was changed, not the overall revision and are thus not as
# useful for recreating the current version of Rosetta.

# Portability
# sed needs to use full regular expressions below
set os = `uname`
if ( $os == "Darwin") then
    set sed = 'sed -E'
else
    set sed = 'sed -re'
endif

# Verify Subversion exists, otherwise this script won't work properly
which svn >& /dev/null
if ( $? == 0 ) then
    set have_svn = 1
else
    if ( -e .version ) then
        echo "${0}: Subversion was not found.  Falling back on .version file."
    else
        echo "${0}: Subversion was not found and no .version file.  version_rosetta.cc will lack version information."
    endif
endif

rm -f version_rosetta.cc # force avoids error on missing file JSS
touch version_rosetta.cc
echo "${0}: Creating version_rosetta.cc"
echo '// Rosetta Headers'           >> version_rosetta.cc
echo '#include "version_rosetta.h"' >> version_rosetta.cc
echo                                >> version_rosetta.cc
echo '// C++ Headers'               >> version_rosetta.cc
echo '#include <iostream>'          >> version_rosetta.cc
echo                                >> version_rosetta.cc
echo 'void'                         >> version_rosetta.cc
echo 'write_version() '             >> version_rosetta.cc
echo '{'                            >> version_rosetta.cc
echo '  std::cerr << "===========================\\n";' >> version_rosetta.cc
echo '  std::cerr << "=== version information ===\\n";' >> version_rosetta.cc
echo '  std::cerr << "===========================\\n";' >> version_rosetta.cc

### Run svn update

# # Assume the Subversion user is the same as the currently logged in user.
# if ( ! $?ROSETTA_SVN_USER )then
#     set ROSETTA_SVN_USER = $USER
#     echo "version.csh: Warning: Assuming your Subversion login is $USER."
#     echo "  If this is not the case, please set ROSETTA_SVN_USER to be the actual login".
# endif

rm -f .tmp.version
# Check if an .svn/entries file exists for current directory
# If it does, update .version.  Otherwise we use the existing .version
if ( -e .svn/entries && $?have_svn ) then
    echo "${0}: Adding Subversion status to .version"
    svn -v status | $sed "s| +| |g" | cut -f2,5 -d" " > .tmp.version
    # Make sure the .tmp.version is valid and not clobbered by a bad login
    # or we lose the version information we have.
    if ( -e .tmp.version && ! -z .tmp.version) then
        cp -f .tmp.version .version
        rm -f .tmp.version
    else
        echo "Subversion status failed, so new version information was not available."
        echo "Continuing with the existing .version file."
    endif
else
    echo "${0}: No Subversion, or no working copy found: using existing .version file."
endif

# Parse status results
# Show only files ending in ".cc" or ".h" which are in the main rosetta directory
echo "${0}: Generating version information for version_rosetta.cc."
echo '  std::cerr << "Version results:\\n";' >> version_rosetta.cc
echo '  std::cerr << "File                                    Version\\n";' >> version_rosetta.cc
if ( -e .version ) then
  awk  '{ if ($2 && ($2 ~ ".(cc|h)$") && ($2 !~ "/")) \
          printf "  std::cerr << \"  %-40s %s\\n\";\n", $2, $1 ; \
        }' .version | sort >> version_rosetta.cc
endif
echo '  std::cerr << "===========================\\n";' >> version_rosetta.cc
echo '  std::cerr << "===========================\\n";' >> version_rosetta.cc
echo '}' >> version_rosetta.cc
