// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19043 $
//  $Date: 2007-12-11 12:08:55 -0800 (Tue, 11 Dec 2007) $
//  $Author: havranek $


// Rosetta Headers
#include "water.h"
#include "aaproperties_pack.h"
#include "add_pser.h"
#include "analyze_interface_ddg.h"
#include "analyze_interface_ddg_ns.h"
#include "angles.h"
#include "atom_is_backbone.h"
#include "design.h"
#include "enzyme.h"
#include "etable.h"
#include "fullatom.h"
#include "fullatom_energies.h"
#include "fullatom_energy.h"
#include "gl_graphics.h"
#include "hbonds_geom.h"
#include "hbonds_ns.h"
#include "misc.h"
#include "orient_rms.h"
#include "pack_fwd.h"
#include "pack_geom_inline.h"
#include "param.h"
#include "param_aa.h"
#include "param_pack.h"
#include "param_torsion.h"
#include "pdbstatistics_pack.h"
#include "read_aaproperties.h"
#include "template_pack.h"
#include "util_vector.h"
#include "water_ns.h"
#include "weights_manager.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/formatted.io.hh>

// Numeric Headers
#include <numeric/conversions.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/irstream.hh>
#include <utility/io/orstream.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <string>


//lin  WATER ROTAMER/H2OHB calculation

//lin  Lin Jiang, Febrary 2003
//lin  - sets up the buildup of water around the rotamers,
//lin  - sets up input/output the native water,
//lin  - computes the free energy of water-mediated hydrogen bonds,
//lin  - defines the environment dependent weight for H-bonds and
//lin     water-mediated H-bonds.

//lin   this file contains the following functions:
//lin
//lin   --------------------------
//lin   for water rotamers buildup
//lin   --------------------------
//lin    - create_sidechain_h2o_variants()
//lin      input:  old variants of aa
//lin      output: building up the sidechain water and create the new variant

//lin    - create_backbone_h2o_variants()
//lin      input:  old variants of aa
//lin      output: building up the backbone water and create the new variant

//lin    - add_water_to_variant()
//lin      input:  current variant of aa
//lin      output: building up the water based on the geometrical parameter

//lin    - add_exact_water_to_variant()
//lin      input:  current variant of aa
//lin      output: building up the water based on the superimposition

//lin    - place_water_by_superimpose()
//lin      input:  the initial water position
//lin      output: the superimpoed position

//lin   -----------------------------
//lin   for native water input/output
//lin   -----------------------------
//lin    - read_pdb_water()
//lin      input:  input file
//lin      output: set up the buried native water for energy calculation

//lin    - make_pdb_water()
//lin      input:  current array of native water
//lin      output: the crude information of buried native water

//lin   -----------------------------
//lin   for counting water neighbors
//lin   -----------------------------
//lin    - is_buried_water()
//lin      input:  current protein structure
//lin      output: the native water is exposed or buried

//lin    - count_native_water_neighbors()
//lin      input:  current protein structure
//lin      output: neighbor number information of native waters

//lin    - count_explicit_water_neighbors()
//lin      input:  current protein structure
//lin      output: neighbor number information of explicit waters

//lin    - buried_water_check()
//lin      input:  current protein structure
//lin      output: get ride of rotamers whose water is buried

//lin   -----------------------------------------------
//lin   for getting energies between water and proteins
//lin   -----------------------------------------------
//lin    - get_h2oE()
//lin      The main function for get water energy
//lin      input:   two residues of current protein structure
//lin      output:  total water energy between these two residues

//lin    - get_sc_bb_h2oE()
//lin      input:   two residues of current protein structure
//lin      output:  water energy between the sidechain and the other backbone

//lin    - get_sc_hetero_h2oE()
//lin      input:   one residue of current protein structure
//lin      output:  lj repulsive between the residue and hetero water

//lin    - get_sc_sc_h2oE()
//lin      input:   two residues of current protein structure
//lin      output:  water energy between the sidechain and the other sidechain

//lin    - get_sc_sc_h2oE_1way()
//lin      input:   two residues of current protein structure
//lin      output:  water energy from the sidechain to the other sidechain

//lin    - find_h2ohb_template_atom()
//lin      input:   water and residue of current protein structure
//lin      output:  the base atom involving in this water-mediated H-bond

//lin    - h2o_hbenergy()
//lin      the core function for water-mediated H-bond calculation
//lin      input:   bridging water and atoms from current protein structure
//lin      output:  water-mediated H-bond energy

//lin    - fast_pairenergy_h2o()
//lin      input:   atoms and water from current protein structure
//lin      output:  lj repulsive energy

//lin    - fast_pairenergy_hetero_h2ohb()
//lin      input:   atom pair from current protein structure
//lin      output:  water-mediated H-bond energy between atoms
//lin               involved by hetero water

//lin    - fast_pairenergy_attached_h2o()
//lin      input:   atom pair from current protein structure
//lin      output:  water energy of atom pair involved by
//lin               lj repulsive and water-mediated H-bond energy

//lin    - get_buried_h2ohb_weight()
//lin      input:   neigbor number of the water
//lin      output:  the environment weight for calculating water-mediated H-bond

//lin   ------------------------------
//lin   for setting the packer weights
//lin   ------------------------------
//lin    - set_weights_for_packer()
//lin      output:  set packer weight when repacking

//lin    - set_weights_for_score()
//lin      output:  set packer weight when scoring

//lin    - revise_Wdun_Wrep_to_packer()
//lin      output:  reset repulsive and dunbrack weight for repacking

//lin   ---------------------
//lin   for setting the flags
//lin   ---------------------
//lin    - set_water_rotamer_for_packer()
//lin      output: set some flags for water rotamers when repacking

//lin    - set_weights_for_score()
//lin      output: set some flags for water rotamers when scoring

//lin    - set_use_W_int_repack()
//lin      output: set the flag Wint_repack_only:
//lin              using int weight when repacking

//lin    - set_use_W_int_score()
//lin      output: set the flag Wint_score_only:
//lin              using int weight when scoring

//lin    - set_use_W_hb_env_dep_lin()
//lin      output: set the flag use_W_hb_env_dep_lin: (now turn off)
//lin              using environment weight for hb calculation

//lin    - set_use_simple_bonus_for_h2ohb()
//lin      output: set the flag use_water_bonus:
//lin              using simple bonus for water-mediated H-bond calculation

//lin    - set_use_angle_check_for_h2ohb()
//lin      output: set the flag h2ohb_angle_check:
//lin              using angle constraint for water-mediated H-bond calculation

//lin    - set_use_W_h2o_hb_env_dep()
//lin      output: set the flag use_h2o_hb_env_dep_lin:
//lin              using environment weight for water-mediated H-bond calculation


//=========================================
// functions for water rotamers buildup
// Lin Jiang 09/19/2003
//=========================================

////////////////////////////////////////////////////////////////////////////////
/// @begin create_sidechain_h2o_variants
/// @brief create water rotamers for sidechain water
///
/// @detailed
///    create the new variants which contain water attached to sidechain atoms.
///    Two models here is to build the side chain water.
///    simple_placement:
///       build each water based on the geometrical parameters (distance,
///       dihedral angle and rotation angle)
///       some parameters see: J Mol Biol 1988, 202, 637-657
///    stat_placement:
///       build each water based on superimposing the conserved water site around
///       functional groups
///       see: J Mol Biol 1993, 229,419-427
///
/// @param[in]   aa - in - amino acid
///
/// @global_read
/// variables from "water.h"
///     stat_placement  - exact water placement using the statist
///     simple_placement - simple placement based on certain geometrical parameters
///
/// variables from "param_aa.h"
///     aa_ser, aa_thr, aa_tyr, aa_trp, aa_lys, aa_asp, aa_glu
///     aa_gln, aa_asn, aa_arg, aa_his  -  the id of amino acids whose side chain
///                                        water are attached to
/// variables from "aaproperties_pack.h"
///     nvar - the current number of variants
///
/// @global_write none
///
///
/// @remarks
///        check the global variable change in
///        function "create_new_variant" and "add_water_to_variant"
///
/// @references
///       J Mol Biol 1988, 202, 637-657
///       J Mol Biol 1993, 229,419-427
///
/// @authors  Lin Jiang 08/19/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
create_sidechain_h2o_variants( int aa )
{
//bk create amino acid variants that permute the different combinations
//bk of water hbonding to the backbone

	using namespace aaproperties_pack;
	using namespace param_aa;
	using namespace water;

	int new_variant;
	float dis;
	float dihedral = 0.0;
	int old_nvar = nvar(aa);
	float rot_angle = 0.0;

//bk   add new variations to all existing variations (ev)
	for ( int starting_variant = 1; starting_variant <= old_nvar;
	 ++starting_variant ) {

//bk      make variants for ser,try three different dihedral positions
		if ( aa == aa_ser ) {

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dihedral = 180.0;
			dis = 1.8;
//bk         template atoms: HG,OG,CB
			add_water_to_variant("1WOG",aa,new_variant,8,6,5,6,dis,false,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dihedral = -60.0;
			dis = 1.8;
//bk         template atoms: HG,OG,CB
			add_water_to_variant("2WOG",aa,new_variant,8,6,5,6,dis,false,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dihedral = 60.0;
			dis = 1.8;
//bk         template atoms: HG,OG,CB
			add_water_to_variant("3WOG",aa,new_variant,8,6,5,6,dis,false,dihedral,
			 true,rot_angle);

		}

//bk      make variants for thr, make three different dihedral positions
		if ( aa == aa_thr ) {
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dihedral = 180.0;
			dis = 1.8;
//bk         template atoms: HG1,OG1,CB
			add_water_to_variant("1WOG",aa,new_variant,9,6,5,6,dis,false,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dihedral = -60.0;
			dis = 1.8;
//bk         template atoms: HG1,OG1,CB
			add_water_to_variant("2WOG",aa,new_variant,9,6,5,6,dis,false,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dihedral = 60.0;
			dis = 1.8;
//bk         template atoms: HG1,OG1,CB
			add_water_to_variant("3WOG",aa,new_variant,9,6,5,6,dis,false,dihedral,
			 true,rot_angle);
		}


//bk      make variant for tyr
		if ( aa == aa_tyr ) {
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.8;
			add_water_to_variant("1WOH",aa,new_variant,14,12,11,12,dis,true,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dihedral = 180.0;
			dis = 1.8;
			add_water_to_variant("2WOH",aa,new_variant,14,12,11,12,dis,false,dihedral,
			 true,rot_angle);
		}

//bk      make variant for trp
		if ( aa == aa_trp ) {
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WNE",aa,new_variant,16,9,7,9,dis,true,dihedral,
			 true,rot_angle);
		}

//bk      make variant for lys
		if ( aa == aa_lys ) {
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WZ1",aa,new_variant,11,9,8,9,dis,true,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WZ2",aa,new_variant,12,9,8,9,dis,true,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WZ3",aa,new_variant,13,9,8,9,dis,true,dihedral,
			 true,rot_angle);
		}

//bk      make variants for asp
//lin     using the statistical water placement

		if ( aa == aa_asp && stat_placement ) {

//lin        add statistical water on asp
//bk         water 1 on OD1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,7,6,5,7,2.400,0.500,
			 0.040);
//bk         water 2 on OD1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,7,6,5,7,3.980,1.690,
			 0.210);
//bk         water 3 on OD1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("3WO1",aa,new_variant,7,6,5,7,1.420,5.030,
			 0.150);
//bk         water 1 on OD2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO2",aa,new_variant,8,6,5,8,1.340,5.000,
			 0.020);
//bk         water 2 on OD2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO2",aa,new_variant,8,6,5,8,3.900,1.210,
			 0.060);
//bk         water OD11 and OD13
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,7,6,5,7,2.400,0.500,
			 0.040);
			add_exact_water_to_variant("3WO1",aa,new_variant,7,6,5,7,1.420,5.030,
			 0.150);
//bk         water OD11 and OD21
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,7,6,5,7,2.400,0.500,
			 0.040);
			add_exact_water_to_variant("1WO2",aa,new_variant,8,6,5,8,1.340,5.000,
			 0.020);
//bk         water OD11 and OD22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,7,6,5,7,2.400,0.500,
			 0.040);
			add_exact_water_to_variant("2WO2",aa,new_variant,8,6,5,8,3.900,1.210,
			 0.060);
//bk         water OD12 and OD21
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,7,6,5,7,3.980,1.690,
			 0.210);
			add_exact_water_to_variant("1WO2",aa,new_variant,8,6,5,8,1.340,5.000,
			 0.020);
//bk         water OD12 and OD22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,7,6,5,7,3.980,1.690,
			 0.210);
			add_exact_water_to_variant("2WO2",aa,new_variant,8,6,5,8,3.900,1.210,
			 0.060);
//bk         water OD13 and OD22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("3WO1",aa,new_variant,7,6,5,7,1.420,5.030,
			 0.150);
			add_exact_water_to_variant("2WO2",aa,new_variant,8,6,5,8,3.900,1.210,
			 0.060);
//bk         water OD11 and OD13 and OD22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,7,6,5,7,2.400,0.500,
			 0.040);
			add_exact_water_to_variant("3WO1",aa,new_variant,7,6,5,7,1.420,5.030,
			 0.150);
			add_exact_water_to_variant("2WO2",aa,new_variant,8,6,5,8,3.900,1.210,
			 0.060);

//$$$$cbk         water on OD1
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,7,6,5,7,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on OD2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO2',aa,new_variant,8,6,5,8,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on both OD1 and OD2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,7,6,5,7,
//$$$$              true,dihedral);
//$$$$            add_water_to_variant('1WO2',aa,new_variant,8,6,5,8,
//$$$$              true,dihedral);

		}

//bk      make variants for glu
		if ( aa == aa_glu && stat_placement ) {

//lin        add statistical water on glu
//bk         water 1 on OE1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,8,7,6,8,2.400,0.500,
			 0.040);
//bk         water 2 on OE1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,8,7,6,8,3.980,1.690,
			 0.210);
//bk         water 3 on OE1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("3WO1",aa,new_variant,8,7,6,8,1.420,5.030,
			 0.150);
//bk         water 1 on OE2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO2",aa,new_variant,9,7,6,9,1.340,5.000,
			 0.020);
//bk         water 2 on OE2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO2",aa,new_variant,9,7,6,9,3.900,1.210,
			 0.060);
//bk         water OE11 and OE13
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,8,7,6,8,2.400,0.500,
			 0.040);
			add_exact_water_to_variant("3WO1",aa,new_variant,8,7,6,8,1.420,5.030,
			 0.150);
//bk         water OE11 and OE21
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,8,7,6,8,2.400,0.500,
			 0.040);
			add_exact_water_to_variant("1WO2",aa,new_variant,9,7,6,9,1.340,5.000,
			 0.020);
//bk         water OE11 and OE22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,8,7,6,8,2.400,0.500,
			 0.040);
			add_exact_water_to_variant("2WO2",aa,new_variant,9,7,6,9,3.900,1.210,
			 0.060);
//bk         water OE12 and OE21
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,8,7,6,8,3.980,1.690,
			 0.210);
			add_exact_water_to_variant("1WO2",aa,new_variant,9,7,6,9,1.340,5.000,
			 0.020);
//bk         water OE12 and OE22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,8,7,6,8,3.980,1.690,
			 0.210);
			add_exact_water_to_variant("2WO2",aa,new_variant,9,7,6,9,3.900,1.210,
			 0.060);
//bk         water OE13 and OE22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("3WO1",aa,new_variant,8,7,6,8,1.420,5.030,
			 0.150);
			add_exact_water_to_variant("2WO2",aa,new_variant,9,7,6,9,3.900,1.210,
			 0.060);
//bk         water OE11 and OE13 and OE22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,8,7,6,8,2.400,0.500,
			 0.040);
			add_exact_water_to_variant("3WO1",aa,new_variant,8,7,6,8,1.420,5.030,
			 0.150);
			add_exact_water_to_variant("2WO2",aa,new_variant,9,7,6,9,3.900,1.210,
			 0.060);


//$$$$cbk         water on OE1
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,8,7,6,8,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on OE2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO2',aa,new_variant,9,7,6,9,
//$$$$             true,dihedral);
//$$$$
//$$$$cbk         water on both OD1 and OD2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,8,7,6,8,
//$$$$              true,dihedral);
//$$$$            add_water_to_variant('1WO2',aa,new_variant,9,7,6,9,
//$$$$              true,dihedral);
//$$$$
		}

//bk      make variants for Asn
		if ( aa == aa_asn && stat_placement ) {

//lin        adding statistical water on Asn
//lin         water 1 on OD
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,7,6,5,7,2.210,0.450,
			 0.910);
//lin         water 2 on OD
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,7,6,5,7,3.820,1.200,
			 0.290);
//lin         water 3 on OD
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("3WO1",aa,new_variant,7,6,5,7,1.440,5.060,
			 0.030);
//lin         water 1 on 1HD2 of ND2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WD2",aa,new_variant,10,8,6,8,1.700,4.970,
			 0.060);
//lin         water 2 on 2HD2 of ND2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WD2",aa,new_variant,11,8,6,8,3.720,0.680,
			 0.160);
//lin         water OD1 and OD3
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,7,6,5,7,2.210,0.450,
			 0.910);
			add_exact_water_to_variant("3WO1",aa,new_variant,7,6,5,7,1.440,5.060,
			 0.030);
//lin         water OD1 and ND21
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,7,6,5,7,2.210,0.450,
			 0.910);
			add_exact_water_to_variant("1WD2",aa,new_variant,10,8,6,8,1.700,4.970,
			 0.060);
//lin         water OD1 and ND22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,7,6,5,7,2.210,0.450,
			 0.910);
			add_exact_water_to_variant("2WD2",aa,new_variant,11,8,6,8,3.720,0.680,
			 0.160);
//lin         water OD2 and ND21
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,7,6,5,7,3.820,1.200,
			 0.290);
			add_exact_water_to_variant("1WD2",aa,new_variant,10,8,6,8,1.700,4.970,
			 0.060);
//lin         water OD2 and ND22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,7,6,5,7,3.820,1.200,
			 0.290);
			add_exact_water_to_variant("2WD2",aa,new_variant,11,8,6,8,3.720,0.680,
			 0.160);
//lin         water OD3 and ND22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("3WO1",aa,new_variant,7,6,5,7,1.440,5.060,
			 0.030);
			add_exact_water_to_variant("2WD2",aa,new_variant,11,8,6,8,3.720,0.680,
			 0.160);
//lin         water OD1 and OD3 and ND22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,7,6,5,7,2.210,0.450,
			 0.910);
			add_exact_water_to_variant("3WO1",aa,new_variant,7,6,5,7,1.440,5.060,
			 0.030);
			add_exact_water_to_variant("2WD2",aa,new_variant,11,8,6,8,3.720,0.680,
			 0.160);

//$$$$cbk         water on both ONH2 and NH2O
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,7,6,5,7,
//$$$$              true,dihedral);
//$$$$            add_water_to_variant('1WD2',aa,new_variant,10,8,6,8,
//$$$$              true,dihedral);
//$$$$
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,7,6,5,7,
//$$$$              true,dihedral);
//$$$$            add_water_to_variant('2WD2',aa,new_variant,11,8,6,8,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on ONH2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,7,6,5,7,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on 1HD2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WD2',aa,new_variant,10,8,6,8,
//$$$$             true,dihedral);
//$$$$
//$$$$cbk         water on 2HD2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('2WD2',aa,new_variant,11,8,6,8,
//$$$$              true,dihedral);
//$$$$
//$$$$
//$$$$cbk         water on both ONH2 and NH2O
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,7,6,5,7,
//$$$$              true,dihedral);
//$$$$            add_water_to_variant('1WD2',aa,new_variant,10,8,6,8,
//$$$$              true,dihedral);
//$$$$
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,7,6,5,7,
//$$$$              true,dihedral);
//$$$$            add_water_to_variant('2WD2',aa,new_variant,11,8,6,8,
//$$$$             true,dihedral);

		}


//bk      make variants for Gln
		if ( aa == aa_gln && stat_placement ) {

//lin        adding statistical water on Asn
//bk         water 1 on OE
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,8,7,6,8,2.210,0.450,
			 0.910);
//bk         water 2 on OE
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,8,7,6,8,3.820,1.200,
			 0.290);
//bk         water 3 on OE
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("3WO1",aa,new_variant,8,7,6,8,1.440,5.060,
			 0.030);
//bk         water 1 on 1HE2 of NE2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WE2",aa,new_variant,11,9,7,9,1.700,4.970,
			 0.060);
//bk         water 2 on 2HE2 of NE2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WE2",aa,new_variant,12,9,7,9,3.720,0.680,
			 0.160);
//bk         water OE1 and OE3
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,8,7,6,8,2.210,0.450,
			 0.910);
			add_exact_water_to_variant("3WO1",aa,new_variant,8,7,6,8,1.440,5.060,
			 0.030);
//bk         water OE1 and NE21
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,8,7,6,8,2.210,0.450,
			 0.910);
			add_exact_water_to_variant("1WE2",aa,new_variant,11,9,7,9,1.700,4.970,
			 0.060);
//bk         water OE1 and NE22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,8,7,6,8,2.210,0.450,
			 0.910);
			add_exact_water_to_variant("2WE2",aa,new_variant,12,9,7,9,3.720,0.680,
			 0.160);
//bk         water OE2 and NE21
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,8,7,6,8,3.820,1.200,
			 0.290);
			add_exact_water_to_variant("1WE2",aa,new_variant,11,9,7,9,1.700,4.970,
			 0.060);
//bk         water OE2 and NE22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WO1",aa,new_variant,8,7,6,8,3.820,1.200,
			 0.290);
			add_exact_water_to_variant("2WE2",aa,new_variant,12,9,7,9,3.720,0.680,
			 0.160);
//bk         water OE3 and NE22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("3WO1",aa,new_variant,8,7,6,8,1.440,5.060,
			 0.030);
			add_exact_water_to_variant("2WE2",aa,new_variant,12,9,7,9,3.720,0.680,
			 0.160);
//bk         water OE1 and OE3 and NE22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WO1",aa,new_variant,8,7,6,8,2.210,0.450,
			 0.910);
			add_exact_water_to_variant("1WE2",aa,new_variant,11,9,7,9,1.700,4.970,
			 0.060);
			add_exact_water_to_variant("2WE2",aa,new_variant,12,9,7,9,3.720,0.680,
			 0.160);

//$$$$cbk         water on ONH2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,8,7,6,8,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on 1HE2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WE2',aa,new_variant,11,9,7,9,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on 2HE2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('2WE2',aa,new_variant,12,9,7,9,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on both ONH2 and NH2O
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,8,7,6,8,
//$$$$              true,dihedral);
//$$$$            add_water_to_variant('1WE2',aa,new_variant,11,9,7,9,
//$$$$              true,dihedral);
//$$$$
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WO1',aa,new_variant,8,7,6,8,
//$$$$              true,dihedral);
//$$$$            add_water_to_variant('2WE2',aa,new_variant,12,9,7,9,
//$$$$              true,dihedral);

		}

//bk      make variants for arg
		if ( aa == aa_arg && stat_placement ) {

//lin        put water on arg based on the coorrdinate
//bk         water on NE
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WNE",aa,new_variant,17,8,7,8,2.540,1.450,
			 0.180);
//bk         water 1  on NH1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WN1",aa,new_variant,10,9,8,10,3.730,0.640,
			 0.090);
//bk         water 2  on NH1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WN1",aa,new_variant,10,9,8,10,1.320,4.950,
			 0.100);
//bk         water 1  on NH2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WN2",aa,new_variant,11,9,8,11,1.210,4.900,
			 0.160);
//bk         water 2  on NH2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WN2",aa,new_variant,11,9,8,11,3.900,1.250,
			 0.070);
//bk         water on NE and NH12
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WNE",aa,new_variant,17,8,7,8,2.540,1.450,
			 0.180);
			add_exact_water_to_variant("2WN1",aa,new_variant,10,9,8,10,1.320,4.950,
			 0.100);
//bk         water on NE and NH21
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WNE",aa,new_variant,17,8,7,8,2.540,1.450,
			 0.180);
			add_exact_water_to_variant("1WN2",aa,new_variant,11,9,8,11,1.210,4.900,
			 0.160);
//bk         water on NE and NH22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WNE",aa,new_variant,17,8,7,8,2.540,1.450,
			 0.180);
			add_exact_water_to_variant("2WN2",aa,new_variant,11,9,8,11,3.900,1.250,
			 0.070);
//bk         water NH11 and NH21
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WN1",aa,new_variant,10,9,8,10,3.730,0.640,
			 0.090);
			add_exact_water_to_variant("1WN2",aa,new_variant,11,9,8,11,1.210,4.900,
			 0.160);
//bk         water NH11 and NH22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WN1",aa,new_variant,10,9,8,10,3.730,0.640,
			 0.090);
			add_exact_water_to_variant("2WN2",aa,new_variant,11,9,8,11,3.900,1.250,
			 0.070);
//bk         water NH12 and NH22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("2WN1",aa,new_variant,10,9,8,10,1.320,4.950,
			 0.100);
			add_exact_water_to_variant("2WN2",aa,new_variant,11,9,8,11,3.900,1.250,
			 0.070);
//bk         water on NE and NH12 and NH22
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			add_exact_water_to_variant("1WNE",aa,new_variant,17,8,7,8,2.540,1.450,
			 0.180);
			add_exact_water_to_variant("2WN1",aa,new_variant,10,9,8,10,1.320,4.950,
			 0.100);
			add_exact_water_to_variant("2WN2",aa,new_variant,11,9,8,11,3.900,1.250,
			 0.070);

//$$$$cbk         water on NE
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WNE',aa,new_variant,17,8,7,8,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on NH1
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WN1',aa,new_variant,10,9,8,10,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on NH2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WN2',aa,new_variant,11,9,8,11,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on NE and NH1
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WNE',aa,new_variant,17,8,7,8,
//$$$$              true,dihedral);
//$$$$            add_water_to_variant('1WN1',aa,new_variant,10,9,8,10,
//$$$$              true,dihedral);
//$$$$
//$$$$cbk         water on NE and NH2
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            add_water_to_variant('1WNE',aa,new_variant,17,8,7,8,
//$$$$              true,dihedral);
//$$$$            add_water_to_variant('1WN2',aa,new_variant,11,9,8,11,
//$$$$              true,dihedral);

		}

//bk      make variants for asp
//lin     using the simple water placement
		if ( aa == aa_asp && simple_placement ) {

//bk         water on OD1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = 55.0;
			dis = 2.8;
			add_water_to_variant("1WO1",aa,new_variant,7,6,5,7,dis,true,dihedral,
			 false,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = -55.0;
			dis = 2.8;
			add_water_to_variant("2WO1",aa,new_variant,7,6,5,7,dis,true,dihedral,
			 false,rot_angle);

//bk         water on OD2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = 55.0;
			dis = 2.8;
			add_water_to_variant("1WO2",aa,new_variant,8,6,5,8,dis,true,dihedral,
			 false,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = -55.0;
			dis = 2.8;
			add_water_to_variant("2WO2",aa,new_variant,8,6,5,8,dis,true,dihedral,
			 false,rot_angle);

//bk         water on both OD1 and OD2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = 55.0;
			dis = 2.8;
			add_water_to_variant("1WO1",aa,new_variant,7,6,5,7,dis,true,dihedral,
			 false,rot_angle);
			rot_angle = -55.0;
			dis = 2.8;
			add_water_to_variant("2WO2",aa,new_variant,8,6,5,8,dis,true,dihedral,
			 false,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = -55.0;
			dis = 2.8;
			add_water_to_variant("2WO1",aa,new_variant,7,6,5,7,dis,true,dihedral,
			 false,rot_angle);
			rot_angle = 55.0;
			dis = 2.8;
			add_water_to_variant("1WO2",aa,new_variant,8,6,5,8,dis,true,dihedral,
			 false,rot_angle);

//            new_variant = create_new_variant(aa,starting_variant,aav_water);
//            add_water_to_variant('1WO1',aa,new_variant,7,6,5,7,
//              true,dihedral);
//            add_water_to_variant('1WO2',aa,new_variant,8,6,5,8,
//              true,dihedral);

		}

//bk      make variants for glu
		if ( aa == aa_glu && simple_placement ) {

//bk         water on OE1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = 55.0;
			dis = 2.8;
			add_water_to_variant("1WO1",aa,new_variant,8,7,6,8,dis,true,dihedral,
			 false,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = -55.0;
			dis = 2.8;
			add_water_to_variant("2WO1",aa,new_variant,8,7,6,8,dis,true,dihedral,
			 false,rot_angle);

//bk         water on OE2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = 55.0;
			dis = 2.8;
			add_water_to_variant("1WO2",aa,new_variant,9,7,6,9,dis,true,dihedral,
			 false,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = -55.0;
			dis = 2.8;
			add_water_to_variant("2WO2",aa,new_variant,9,7,6,9,dis,true,dihedral,
			 false,rot_angle);

//bk         water on both OD1 and OD2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = 55.0;
			dis = 2.8;
			add_water_to_variant("1WO1",aa,new_variant,8,7,6,8,dis,true,dihedral,
			 false,rot_angle);
			rot_angle = -55.0;
			dis = 2.8;
			add_water_to_variant("2WO2",aa,new_variant,9,7,6,9,dis,true,dihedral,
			 false,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = -55.0;
			dis = 2.8;
			add_water_to_variant("2WO1",aa,new_variant,8,7,6,8,dis,true,dihedral,
			 false,rot_angle);
			rot_angle = 55.0;
			dis = 2.8;
			add_water_to_variant("1WO2",aa,new_variant,9,7,6,9,dis,true,dihedral,
			 false,rot_angle);

//            new_variant = create_new_variant(aa,starting_variant,aav_water);
//            add_water_to_variant('1WO1',aa,new_variant,8,7,6,8,
//              true,dihedral);
//            add_water_to_variant('1WO2',aa,new_variant,9,7,6,9,
//              true,dihedral);

		}

//bk      make variants for Asn
		if ( aa == aa_asn && simple_placement ) {

//bk         water on ONH2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 2.8;
			rot_angle = 55.0;
			add_water_to_variant("1WO1",aa,new_variant,7,6,5,7,dis,true,dihedral,
			 false,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 2.8;
			rot_angle = -55.0;
			add_water_to_variant("2WO1",aa,new_variant,7,6,5,7,dis,true,dihedral,
			 false,rot_angle);

//bk         water on 1HD2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WD2",aa,new_variant,10,8,6,8,dis,true,dihedral,
			 true,rot_angle);

//bk         water on 2HD2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("2WD2",aa,new_variant,11,8,6,8,dis,true,dihedral,
			 true,rot_angle);


//bk         water on both ONH2 and NH2O
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 2.8;
			rot_angle = 55.0;
			add_water_to_variant("1WO1",aa,new_variant,7,6,5,7,dis,true,dihedral,
			 false,rot_angle);
			dis = 1.95;
			add_water_to_variant("1WD2",aa,new_variant,10,8,6,8,dis,true,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 2.8;
			rot_angle = -55.0;
			add_water_to_variant("2WO1",aa,new_variant,7,6,5,7,dis,true,dihedral,
			 false,rot_angle);
			add_water_to_variant("2WD2",aa,new_variant,11,8,6,8,dis,true,dihedral,
			 true,rot_angle);

//            new_variant = create_new_variant(aa,starting_variant,aav_water);
//            add_water_to_variant('1WO1',aa,new_variant,7,6,5,7,
//              true,dihedral);
//            add_water_to_variant('1WD2',aa,new_variant,10,8,6,8,
//              true,dihedral);

//            new_variant = create_new_variant(aa,starting_variant,aav_water);
//            add_water_to_variant('1WO1',aa,new_variant,7,6,5,7,
//              true,dihedral);
//            add_water_to_variant('2WD2',aa,new_variant,11,8,6,8,
//              true,dihedral);

		}


//bk      make variants for Gln
		if ( aa == aa_gln && simple_placement ) {

//bk         water on ONH2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 2.8;
			rot_angle = 55.0;
			add_water_to_variant("1WO1",aa,new_variant,8,7,6,8,dis,true,dihedral,
			 false,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = -55.0;
			dis = 2.8;
			add_water_to_variant("2WO1",aa,new_variant,8,7,6,8,dis,true,dihedral,
			 false,rot_angle);

//bk         water on 1HE2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WE2",aa,new_variant,11,9,7,9,dis,true,dihedral,
			 true,rot_angle);

//bk         water on 2HE2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("2WE2",aa,new_variant,12,9,7,9,dis,true,dihedral,
			 true,rot_angle);

//bk         water on both ONH2 and NH2O
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 2.8;
			rot_angle = 55.0;
			add_water_to_variant("1WO1",aa,new_variant,8,7,6,8,dis,true,dihedral,
			 false,rot_angle);
			dis = 1.95;
			add_water_to_variant("1WE2",aa,new_variant,11,9,7,9,dis,true,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			rot_angle = -55.0;
			dis = 2.8;
			add_water_to_variant("2WO1",aa,new_variant,8,7,6,8,dis,true,dihedral,
			 false,rot_angle);
			dis = 1.95;
			add_water_to_variant("2WE2",aa,new_variant,12,9,7,9,dis,true,dihedral,
			 true,rot_angle);

//            new_variant = create_new_variant(aa,starting_variant,aav_water);
//            add_water_to_variant('1WO1',aa,new_variant,8,7,6,8,
//              true,dihedral);
//            add_water_to_variant('1WE2',aa,new_variant,11,9,7,9,
//              true,dihedral);

//            new_variant = create_new_variant(aa,starting_variant,aav_water);
//            add_water_to_variant('1WO1',aa,new_variant,8,7,6,8,
//              true,dihedral);
//            add_water_to_variant('2WE2',aa,new_variant,12,9,7,9,
//              true,dihedral);

		}

//bk      make variants for arg
		if ( aa == aa_arg && simple_placement ) {

//bk         water on NE
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WNE",aa,new_variant,17,8,7,8,dis,true,dihedral,
			 true,rot_angle);

//bk         water on NH1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WN1",aa,new_variant,13,10,9,10,dis,true,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("2WN1",aa,new_variant,14,10,9,10,dis,true,dihedral,
			 true,rot_angle);

//bk         water on NH2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WN2",aa,new_variant,15,11,9,11,dis,true,dihedral,
			 true,rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("2WN2",aa,new_variant,16,11,9,11,dis,true,dihedral,
			 true,rot_angle);

//bk         water on NE and 2N2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WNE",aa,new_variant,17,8,7,8,dis,true,dihedral,
			 true,rot_angle);
			add_water_to_variant("2WN2",aa,new_variant,16,11,9,11,dis,true,dihedral,
			 true,rot_angle);

//bk         water on NE and 1N1
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            dis = 1.95;
//$$$$            add_water_to_variant('1WNE',aa,new_variant,17,8,7,8,
//$$$$              dis,true,dihedral,true,rot_angle);
//$$$$            add_water_to_variant('1WN1',aa,new_variant,13,10,9,10,
//$$$$              dis,true,dihedral,true,rot_angle);

//bk         water on NE and 2N1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WNE",aa,new_variant,17,8,7,8,dis,true,dihedral,
			 true,rot_angle);
			add_water_to_variant("2WN1",aa,new_variant,14,10,9,10,dis,true,dihedral,
			 true,rot_angle);

//bk         water on 1N2 and 2N2
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WN2",aa,new_variant,15,11,9,11,dis,true,dihedral,
			 true,rot_angle);
			add_water_to_variant("2WN2",aa,new_variant,16,11,9,11,dis,true,dihedral,
			 true,rot_angle);

//bk         water on 1N2 and 1N1
//$$$$            new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$$            dis = 1.95;
//$$$$            add_water_to_variant('1WN2',aa,new_variant,15,11,9,11,
//$$$$              dis,true,dihedral,true,rot_angle);
//$$$$            add_water_to_variant('1WN1',aa,new_variant,13,10,9,10,
//$$$$              dis,true,dihedral,true,rot_angle);

//bk         water on 1N2 and 2N1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WN2",aa,new_variant,15,11,9,11,dis,true,dihedral,
			 true,rot_angle);
			add_water_to_variant("2WN1",aa,new_variant,14,10,9,10,dis,true,dihedral,
			 true,rot_angle);

//bk         water on 2N2 and 1N1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("2WN2",aa,new_variant,16,11,9,11,dis,true,dihedral,
			 true,rot_angle);
			add_water_to_variant("1WN1",aa,new_variant,13,10,9,10,dis,true,dihedral,
			 true,rot_angle);

//bk         water on 2N1 and 1N1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("2WN1",aa,new_variant,14,10,9,10,dis,true,dihedral,
			 true,rot_angle);
			add_water_to_variant("1WN1",aa,new_variant,13,10,9,10,dis,true,dihedral,
			 true,rot_angle);

//bk         water on NE and 2N2 and 1N1
			new_variant = create_new_variant(aa,starting_variant,aav_water);
			dis = 1.95;
			add_water_to_variant("1WNE",aa,new_variant,17,8,7,8,dis,true,dihedral,
			 true,rot_angle);
			add_water_to_variant("2WN2",aa,new_variant,16,11,9,11,dis,true,dihedral,
			 true,rot_angle);
			add_water_to_variant("1WN1",aa,new_variant,13,10,9,10,dis,true,dihedral,
			 true,rot_angle);

//            new_variant = create_new_variant(aa,starting_variant,aav_water);
//            add_water_to_variant('1WNE',aa,new_variant,17,8,7,8,
//              true,dihedral);
//            add_water_to_variant('1WN1',aa,new_variant,10,9,8,10,
//              true,dihedral);

//bk         water on NE and NH2
//            new_variant = create_new_variant(aa,starting_variant,aav_water);
//            add_water_to_variant('1WNE',aa,new_variant,17,8,7,8,
//             true,dihedral);
//            add_water_to_variant('1WN2',aa,new_variant,11,9,8,11,
//              true,dihedral);

		}


//bk      make variants for his
		if ( aa == aa_his ) {

			// jk Account for alternate His tautomers
			if ( atom_base(12, aa_his,starting_variant) == 10 ) {
				// jk HE2 proton on NE2 (default)

//bk         water on NE2
				new_variant = create_new_variant(aa,starting_variant,aav_water);
				dis = 1.95;
				add_water_to_variant("1WNE",aa,new_variant,12,10,8,10,dis,true,dihedral,
				 true,rot_angle);

//bk         water on ND1
				new_variant = create_new_variant(aa,starting_variant,aav_water);
				dis = 2.8;
				rot_angle = 60.0;
				add_water_to_variant("2WNE",aa,new_variant,7,6,5,7,dis,true,dihedral,
				 false,rot_angle);

//bk        water on ND1 and NE2
				new_variant = create_new_variant(aa,starting_variant,aav_water);
				dis = 1.95;
				add_water_to_variant("1WNE",aa,new_variant,12,10,8,10,dis,true,dihedral,
				 true,rot_angle);
				dis = 2.8;
				rot_angle = 60.0;
				add_water_to_variant("2WNE",aa,new_variant,7,6,5,7,dis,true,dihedral,
				 false,rot_angle);

			} else {

				// jk HD1 proton on ND1 (alternate)

//jk         water on protonated ND1
				new_variant = create_new_variant(aa,starting_variant,aav_water);
				dis = 1.95;
				add_water_to_variant("1WND",aa,new_variant,12,7,6,7,dis,true,dihedral,
				 true,rot_angle);

//jk         water on deprotonated NDE2
				new_variant = create_new_variant(aa,starting_variant,aav_water);
				dis = 2.8;
				rot_angle = 60.0;
				add_water_to_variant("2WND",aa,new_variant,10,8,6,10,dis,true,dihedral,
				 false,rot_angle);

//jk         water on both
				new_variant = create_new_variant(aa,starting_variant,aav_water);
				dis = 1.95;
				add_water_to_variant("1WND",aa,new_variant,12,7,6,7,dis,true,dihedral,
				 true,rot_angle);
				dis = 2.8;
				rot_angle = 60.0;
				add_water_to_variant("2WND",aa,new_variant,10,8,6,10,dis,true,dihedral,
				 false,rot_angle);

			}

		}

	}
}


////////////////////////////////////////////////////////////////////////////////
/// @begin create_dna_h2o_variants
/// @brief create hydrated variants of DNA bases
///
/// @detailed
///    Place waters on dna bases.  For now, it's just for the major groove.
///    Ref.:
///    Schneider, B. and H.M. Berman, "Hydration of the DNA bases is local"
///    Biophysical Journal, 1995. 69(6): p. 2661-2669.
///    In constrast to Lin's treatment for proteins, I'm using internal
///    coordinates (dihedral, angle, distance from 3 template atoms) so
///    I can enforce the minimum values for the water-mediated hydrogen bond
///    potential in my placement. I.e., when I do extra water variants, the
///    +/- deltas are in generalized coordinates, so varying the angles doesn't
///    perturb the 'ideal' distance, and vice versa.
///
///
/// @param[in]   na - in - nucleic acid id number
///
/// @global_read
/// variables from "design.h"
///     ex_dna_waters - Whether or not to include extra sample water points
///
/// variables from "param_aa.h"
///     all the na_XXX identifiers
///
/// variables from "aaproperties_pack.h"
///     nvar - the current number of variants
///
/// @global_write none
///
///
/// @remarks
///        check the global variable change in
///        function "create_new_variant" and "add_water_to_variant"
///
/// @references
///
/// @authors  Jim Havranek 08/18/06
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
create_dna_h2o_variants( int na )
{

	using namespace aaproperties_pack;
	using namespace param_aa;
	using namespace water;

///jjh I defined in water.h a simple class for the IC info needed
///jjh to build waters - a name, three atom ids, a length, angle, and dihedral

	for( int this_variant = 1, end_variant = nvar( na ) ;
				this_variant <= end_variant ; ++this_variant ) {

///jjh Pre-pack the relevant IC values by type
		std::vector< std::vector< IC_Info > > water_positions;

///jjh Note that LookupByName, which is about as inefficient as you would
///jjh guess, gets rid of magic numbers for particular atoms and this only
///jjh has to be done at set-up time.  So sue me.

		if( na == na_gua ) {
			std::vector< IC_Info > w1;
			w1.push_back( IC_Info( std::string( " WO6" ),
												LookupByName( na, this_variant, " C5 " ),
												LookupByName( na, this_variant, " C6 " ),
												LookupByName( na, this_variant, " O6 " ),
												2.580, 135.0, -4.0 ) );
			std::vector< IC_Info > w2;
			w2.push_back( IC_Info( " WN7",
												LookupByName( na, this_variant, " N9 " ),
												LookupByName( na, this_variant, " C8 " ),
												LookupByName( na, this_variant, " N7 " ),
												2.670, 120.0, -163.0 ) );

			water_positions.push_back( w1 );
			water_positions.push_back( w2 );
		} else if ( na == na_ade ) {
			std::vector< IC_Info > w1;
			w1.push_back( IC_Info( " WN6",
												LookupByName( na, this_variant, " C5 " ),
												LookupByName( na, this_variant, " C6 " ),
												LookupByName( na, this_variant, " N6 " ),
												2.990, 136.0, -6.0 ) );
			std::vector< IC_Info > w2;
			w2.push_back( IC_Info( " WN7",
												LookupByName( na, this_variant, " N9 " ),
												LookupByName( na, this_variant, " C8 " ),
												LookupByName( na, this_variant, " N7 " ),
												2.710, 126.0, -171.0 ) );
			water_positions.push_back( w1 );
			water_positions.push_back( w2 );
		} else if ( na == na_cyt ) {
			std::vector< IC_Info > w1;
			w1.push_back( IC_Info( " WN4",
												LookupByName( na, this_variant, " N3 " ),
												LookupByName( na, this_variant, " C4 " ),
												LookupByName( na, this_variant, " N4 " ),
												2.970, 116.0, -178.0 ) );
			water_positions.push_back( w1 );
		} else if ( na == na_thy ) {
			std::vector< IC_Info > w1;
			w1.push_back( IC_Info( " WO4",
												LookupByName( na, this_variant, " N3 " ),
												LookupByName( na, this_variant, " C4 " ),
												LookupByName( na, this_variant, " O4 " ),
												2.720, 144.0, -175.0 ) );
			water_positions.push_back( w1 );
		} else {
			std::cout << "WACKINESS ALERT!!!"<< std::endl;
			std::cout << "create_dna_water_variants() called on non DNA" <<
										std::endl;
			std::exit( EXIT_FAILURE );
		}

	///jjh Quick check - how many base waters?
//	std::cout << "Have a total of " << water_positions.size() <<
//		" waters defined " << std::endl;

	///jjh If requested, expand around these values
		if( design::ex_dna_waters ) {
			///jjh The generalrecipe for expansion is to go +/- by a value
			///jjh set in the water namespace

			///jjh Do the expansion for each water positions - there are no
			///jjh combinatorics yet
			for(  std::vector< std::vector< IC_Info > >::iterator this_w =
						water_positions.begin(),
						end_w = water_positions.end() ; this_w != end_w ; ++this_w ) {

				///jjh Now we have a handle on a single position.  Add the extras.
				///jjh I'm not expanding about length at the moment. We'll see
				///jjh how expensive this turns out to be.

				for( int itheta = -1 ; itheta <= 1 ; ++itheta ) {
					float workTheta = ( float(itheta) * water::specWaterAngleDelta );
					for( int iphi = -1 ; iphi <= 1 ; ++iphi ) {
						///jjh skip (0, 0) since that is the original
						if( itheta == 0 && iphi ==0 ) continue;
						float workPhi = ( float(iphi) * water::specWaterTorsionDelta );

						///jjh Make a copy of the base water
						IC_Info expanded_water( *(this_w->begin()) );

						///jjh Adjust
						expanded_water.angle += workTheta;
						expanded_water.dihedral += workPhi;

						///jjh Store
						this_w->push_back( expanded_water );
					}
				}

			///jjh Quick check - how many expanded waters?
//			std::cout << "Have a total of " << this_w->size() <<
//			" expanded waters defined " << std::endl;

			}
		}

		///jjh Now create the actual variant combinations
		///jjh For now just make all combinations of all positions.
		///jjh This code doesn't need to be changed if you add a third
		///jjh (minor groove) position, but does if you want to change
		///jjh the combinatorics to an M choose N type situation.

		///jjh Start up a fresh, empty vector into which accumulate waters
		std::vector< IC_Info > accum_waters;

		create_dna_water_combinations( na, this_variant, water_positions.begin(),
			water_positions.end(), accum_waters );

	} // done loop over pre-existing variants

//	std::cout << "NA " << na << " now has " << nvar( na ) << " variants " << std::endl;

}


////////////////////////////////////////////////////////////////////////////////
/// @begin create_dna_water_combinations
///
/// @brief
///
/// @detailed  Recursive helper function to create combinations of waters
///            around DNA bases
///
/// @param[in]
///
/// @global_read
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Jim Havranek 08/20/06
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////

void
create_dna_water_combinations(
	int na,
	int nav,
	std::vector< std::vector< water::IC_Info > >::iterator this_pos,
	std::vector< std::vector< water::IC_Info > >::iterator end_pos,
	std::vector< water::IC_Info > accum_waters
)
{
	using namespace aaproperties_pack;

	///jjh If this is the 'end' iterator, there are no more
	///jjh positions to consider and it's time to create a
	///jjh variant with what we have accumulated.
	if( this_pos == end_pos ) {
		///jjh If there are no accumulated waters, this is the combination
		///jjh with no waters, which we already have as the parental (aav = 1),
		///jjh so exit without duplicating.
		if( accum_waters.size() < 1 ) return;

		///jjh Make the new variant and add the waters
		int const new_nav = create_new_variant(na, nav, aav_water);
		for( std::vector< water::IC_Info >::iterator this_w = accum_waters.begin(),
					end_w = accum_waters.end() ; this_w !=end_w ; ++this_w ) {
			add_exact_water_to_variant( this_w->name, na, new_nav,
					this_w->template_atom_1, this_w->template_atom_2,
					this_w->template_atom_3, this_w->template_atom_3,
					this_w->length,
					this_w->angle, this_w->dihedral );
		}
		/// Check to see if built waters clash.  Only necessary if more than one water.
		/// If so, 'undo' this variant by rolling back the nvar() array by one
		if( accum_waters.size() > 1 && clashing_waters_found(na, new_nav ) ) {
//			std::cout << "Found clashing waters on same DNA base!" << std::endl;
			nvar( na ) -= 1;
		}
		return;
	///jjh else go through the possibilities at this position - either no
	///jjh water or each water in turn.
	} else {
		///jjh first consider no waters at this position
		create_dna_water_combinations( na, nav, this_pos+1, end_pos, accum_waters);

		///jjh Add each water to a copy of the accum_water vector and
		///jjh move on to the next position
		for( std::vector< water::IC_Info >::iterator this_w = this_pos->begin(),
					end_w = this_pos->end() ; this_w !=end_w ; ++this_w ) {
			std::vector< water::IC_Info > new_accum( accum_waters );
			new_accum.push_back( *this_w );
			create_dna_water_combinations( na, nav, this_pos+1, end_pos, new_accum);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
///
bool
clashing_waters_found(
	int na,
	int nav
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace param_aa;

	int const end_h2o( nh2o( na,nav ) );
	float const waters_too_close( 2.8 );

	for( int first_h2o = 1 ; first_h2o <= end_h2o ; ++first_h2o ){
		int first_pos = h2opos( first_h2o, na, nav );
		for( int second_h2o = first_h2o + 1 ; second_h2o <= end_h2o ; ++second_h2o ){
			int second_pos = h2opos( second_h2o, na, nav );
			float water_dist;
			distance_bk(  icoor( 1, first_pos, na, nav ),
										icoor( 1, second_pos, na, nav ),
										water_dist );
//			std::cout << "Water-water dist is " << water_dist << std::endl;
			if( water_dist < waters_too_close ) return true;
		}
	}
	return false;		// Must be ok if we didn't skip out above
}


////////////////////////////////////////////////////////////////////////////////
/// @begin create_backbone_h2o_variants
///
/// @brief create water rotamers for backbone water
///
/// @detailed  create the new variants which contain water attached to backbone atoms
///
/// @param[in]   aa - in - amino acid
///
/// @global_read
/// variables from "param_aa.h"
///     aa_pro  -  proline (treat differently for proline)
/// variables from "aaproperties_pack.h"
///     HNpos   -  position of the hydrogren atom attached to backbone nitrogen
///     nvar    -  the current number of variants
///
/// @global_write none
///
/// @remarks  check the global variable change in
///        function "create_new_variant" and "add_water_to_variant"
/// @references
///
/// @authors Lin Jiang 08/19/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
create_backbone_h2o_variants( int aa )
{
//bk create amino acid variants that permute the different combinations
//bk of water hbonding to the backbone

	using namespace aaproperties_pack;
	using namespace param_aa;

	int starting_variant,new_variant;

	int old_nvar = nvar(aa);
	float rot_angle = 0.0;
	float dis = 0.0;

//lin  skip cys and DNA RNA
	if ( aa == aa_cys || aa > 20 ) return;

//bk   add new variations to all existing variations (ev)
	for ( starting_variant = 1; starting_variant <= old_nvar;
	 ++starting_variant ) {

//bk      make variant with water on the nitrogen
		if ( aa != aa_pro ) {
			new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$            if ( aa != aa_gly ) {
//$$$               dis = 1.95;
//$$$            } else {
//$$$               dis = 2.30;
//$$$            }
			dis = 1.95;
			add_water_to_variant("1WN ",aa,new_variant,HNpos(aa,new_variant),1,2,1,
			 dis,true,0.0,true,rot_angle);
		}

//bk      make variant with water on the carbonyl
		new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$         if ( aa != aa_gly ) {
//$$$            dis = 2.7;
//$$$         } else {
//$$$            dis = 3.2;
//$$$         }
		dis = 2.8;
		rot_angle = 55.0;
		add_water_to_variant("1WO ",aa,new_variant,4,3,2,4,dis,true,0.0,false,
		 rot_angle);

		new_variant = create_new_variant(aa,starting_variant,aav_water);
		rot_angle = -50.0;
		add_water_to_variant("2WO ",aa,new_variant,4,3,2,4,dis,true,0.0,false,
		 rot_angle);

//bk      make variant with water on the carbonyl and the nitrogen
		if ( aa != aa_pro ) {
			new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$            if ( aa != aa_gly ) {
//$$$               dis = 1.95;
//$$$            } else {
//$$$               dis = 2.30;
//$$$            }
			dis = 1.95;
			add_water_to_variant("1WN ",aa,new_variant,HNpos(aa,new_variant),1,2,1,
			 dis,true,0.0,true,rot_angle);
//$$$            if ( aa != aa_gly ) {
//$$$               dis = 2.7;
//$$$            } else {
//$$$               dis = 3.2;
//$$$            }
			dis = 2.8;
			rot_angle = 55.0;
			add_water_to_variant("1WO ",aa,new_variant,4,3,2,4,dis,true,0.0,false,
			 rot_angle);

			new_variant = create_new_variant(aa,starting_variant,aav_water);
//$$$            if ( aa != aa_gly ) {
//$$$               dis = 1.95;
//$$$            } else {
//$$$               dis = 2.30;
//$$$            }
			dis = 1.95;
			add_water_to_variant("1WN ",aa,new_variant,HNpos(aa,new_variant),1,2,1,
			 dis,true,0.0,true,rot_angle);
//$$$            if ( aa != aa_gly ) {
//$$$               dis = 2.7;
//$$$            } else {
//$$$               dis = 3.2;
//$$$            }
			dis = 2.8;
			rot_angle = -55.0;
			add_water_to_variant("2WO ",aa,new_variant,4,3,2,4,dis,true,0.0,false,
			 rot_angle);
		}
//         if ( aa != aa_pro ) {
//            new_variant = create_new_variant(aa,starting_variant,aav_water);
//            add_water_to_variant('1WN ',aa,new_variant,
//                HNpos(aa,new_variant),1,2,1,true,0.0);
//            add_water_to_variant('1WO ',aa,new_variant,4,3,2,4,
//             true,0.0);
//            new_variant = create_new_variant(aa,starting_variant,aav_water);
//            add_water_to_variant('1WN ',aa,new_variant,
//                HNpos(aa,new_variant),1,2,1,true,0.0);
//            add_water_to_variant('2WO ',aa,new_variant,4,3,2,4,
//             true,0.0);
//         }

	}  // starting variants

}

////////////////////////////////////////////////////////////////////////////////
/// @begin add_water_to_variant
///
/// @brief adding water to current rotamer by geometrical parameter
///
/// @detailed
///    adding water to current variant, build up the topology of
///    this water and attached atoms. The water is attached to a polar atom,
///    based on the geometrical parameters: such as distance (dis), dihedral
///    angle (dihedral) and rotation angle (rot_ang).
///
/// @param[in]  name     - in -  the name of this water molecule
/// @param[in]  aa       - in -  amino acid
/// @param[in]  var      - in -  varient of this rotamer
/// @param[in]  ta1      - in -  template atoms 1 for building water
/// @param[in]  ta2      - in -  template atoms 2 for building water
/// @param[in]  ta3      - in -  template atoms 3 for building water
/// @param[in]  ha       - in -  heavy atom water is attached to
/// @param[in]  dis      - in -  distance between water and template atoms 1
/// @param[in]  fixed    - in -  if true, water doesn't rotate around heavy atom
///                         -  it is false only for water connected to OH groups
/// @param[in]  dihedral - in -  for rotable water, what is the dihedral angle
/// @param[in]  rot_fixed- in -  if true, water doesn't rotate in the heavy atom plane
/// @param[in]  rot_ang  - in -  for rotable water, what is the rotating angle
///
/// @global_read
/// variables from "param.h"
///     MAX_CHI         -  max number of chi angles
/// variables from "aaproperties_pack.h"
///     natoms -  complete number of atoms
///     nh2o   -   number of water atoms
///
/// @global_write
/// variables from "aaproperties_pack.h"
///     natoms            -  number of atoms per aa
///     nh2o              -  number of water
///     fullatom_type     -  fullatom type
///     h2opos_complete            -  position of water
///     nh2o_on_atm       -  how many water are attached to each atom
///     icoor             -  template coordinates of each atom pre aa
///     h2o_on_atm                 -  what waters are connected to each atom
///     heavy_atm_on_h2o           -  what heavy atoms are connected to each water
///     hyd_atm_on_h2o             -  what hydrogen atoms are connected to each acceptor water
///     template_atm_on_h2o -  what template atoms are connected to each water
///     chi_required      -  chi angles needed for building each hdyrogen and water
///     ta                         -  template atoms for building each water
///
/// @remarks
///        Be careful. Currently, no rotatable chi angle for water atoms
///        is allowed when repacking the side chains.
///
/// @references
///
/// @authors  Lin Jiang 08/19/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
add_water_to_variant(
	std::string const & name,
	int & aa,
	int & var,
	int ta1,
	int ta2,
	int ta3,
	int ha, // heavy atom water is connected to
	float & dis, // distance between water and attached heavy atom
	bool fixed, // if true, water doesn't rotate around heavy atom
	float dihedral,
	bool rot_fixed, // if true, water doesn't rotate around heavy atom
	float & rot_ang // for rotable water, what is the dihedral
)
{
///    Placing water on nitrogen:
///    following the linear placement
///
///             N----H''''O
///            /
///           /
///
///   distance - dis
///
///   Placing water on OH groups:
///   The parameter "fixed" and "dihedral" is only for water which is
///   connected to OH groups. The default for the parameter "fixed" is "true".
///
///            O     O
///             +   :
///              + :
///               O---H''''O
///              /
///             /
///
///   distance - dis;      dihedral angle - dihedral
///
///   Placing water on carboxyl oxygen (C == O groups):
///   need rotate cetain angle in the plane
///
///                    O
///           \       :
///            \     :
///             C===O.....
///            /     :
///           /       :
///                    O
///
///   distance -  dis;      rotation angle  -  rot_ang
///

	using namespace aaproperties_pack;
	using namespace etable;
	using namespace param;
	using namespace param_aa;
	using namespace water;
	using numeric::conversions::radians;

	// cases where it is false are waters connected
	// to OH groups
	// cases where it is false are waters connected
	// to C == O groups
	FArray1D_float vec( 3 );
	FArray2D_float mat( 3, 3 );
	float schi, rot;
	int c1,c2,c3,c4;


	int pos = natoms(aa,var) + 1;
	natoms(aa,var) = pos;
	atom_name( pos, aa, var ) = name;
	fullatom_type(pos,aa,var) = type_h2o; // H2O
	atom_type_char(pos,aa,var) = "HOH ";
  atom_base(pos,aa,var) = ha; // JSS: lin, please check this // also check if heavy_atm_on_h2o subsumed by atom_base.
  abase2(pos,aa,var) = ta1;

	int mynh2o = ++nh2o(aa,var);
	h2opos(mynh2o,aa,var) = pos;
	heavy_atm_on_h2o(mynh2o,aa,var) = ha;
	hyd_atm_on_h2o(mynh2o,aa,var) = ta1;
	if ( fa_acceptor(fullatom_type(ha,aa,var)) ) {
		template_atm_on_h2o(mynh2o,aa,var) = ta2;
	} else {
		template_atm_on_h2o(mynh2o,aa,var) = ta1;
	}
	++nh2o_on_atm(ha,aa,var);
	h2o_on_atm(nh2o_on_atm(ha,aa,var),ha,aa,var) = pos;

//bk   templates for building water
	ta(1,pos,aa,var) = ta1;
	ta(2,pos,aa,var) = ta2;
	ta(3,pos,aa,var) = ta3;

//bk   what chi angles define position of water; set same as heavy atom
//bk   it is attached to
	for ( int i = 1; i <= MAX_CHI; ++i ) {
		chi_required(i,pos,aa,var) = chi_required(i,ha,aa,var);
	}

//bk   build the water
	place_atom_linear(icoor(1,ta1,aa,var),icoor(1,ta2,aa,var),  icoor(1,pos,aa,var),dis);

	if ( !rot_fixed ) {
		rotate_in_plane(icoor(1,ha,aa,var),icoor(1,pos,aa,var),
		 icoor(1,ta1,aa,var),icoor(1,ta2,aa,var),
		 icoor(1,ta3,aa,var),rot_ang);
	}

	if ( !fixed ) {   // rotate water into correct position

		if ( aa != aa_ser && aa != aa_thr && aa != aa_tyr ) {
			std::cout << "rotating water not on ser or thr or tyr " << aa << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

//bk retrieve atoms that determine torsion angle
//bk it is the atoms that determine the chi angle of the hydrogen on the
//bk oxygen, which is the second chi angle for ser and thr
		c1 = chi_atoms(1,2,aa,var);
		c2 = chi_atoms(2,2,aa,var);
		c3 = chi_atoms(3,2,aa,var);
		c4 = pos;

//bk calculate intitial chi angle
		dihedral_bk(icoor(1,c1,aa,var),icoor(1,c2,aa,var),
		 icoor(1,c3,aa,var),icoor(1,c4,aa,var),schi);

//bk rotate angle by new-initial degrees
		rot = radians( dihedral - schi );

//bk generate rotation vector and matrix
		getrot_bk(icoor(1,c2,aa,var),icoor(1,c3,aa,var), rot,
		 mat, vec);

//bk move atom
		move_bk(icoor(1,pos,aa,var),mat,vec);

		distance_bk(icoor(1,pos,aa,var),icoor(1,ha,aa,var),dis);
	}

}



////////////////////////////////////////////////////////////////////////////////
/// @begin add_exact_water_to_variant
///
/// @brief adding water to current rotamer by superimpose
///
/// @detailed
///       build each water based on superimposing the conserved water site
///       around functional groups
///       only for five polar residue: Asp,Asn,Glu,Gln and Arg
///
/// @param[in]   name     - in -  the name of this water molecule
/// @param[in]   aa       - in -  amino acid
/// @param[in]   var      - in -  varient of this rotamer
/// @param[in]   ta1      - in -  template atoms 1 for building water
/// @param[in]   ta2      - in -  template atoms 2 for building water
/// @param[in]   ta3      - in -  template atoms 3 for building water
/// @param[in]   ha       - in -  heavy atom water is attached to
/// @param[in]   twx,twy.twz - in - coordinate for building water
///
/// @global_read
///    the same as function "add_water_to_variant"
///
/// @global_write
///    the same as function "add_water_to_variant"
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang 09/19/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
add_exact_water_to_variant(
	std::string const & name,
  int const aa,
  int const var,
  int const ta1,
  int const ta2,
  int const ta3,
  int const ha, // heavy atom water is connected to
  float const twx,
  float const twy,
  float const twz
)
{
	using namespace aaproperties_pack;
	using namespace etable;
	using namespace param;
	using namespace param_aa;
	using namespace water;

	int pos = natoms(aa,var) + 1;
	natoms(aa,var) = pos;
	atom_name(pos,aa,var) = name;
	fullatom_type(pos,aa,var) = type_h2o; // H2O
	atom_type_char(pos,aa,var) = "HOH ";
  atom_base(pos,aa,var) = ha; // JSS: lin, please check this
  abase2(pos,aa,var) = ta1;

//	std::cout << "AA " << aa << " VAR " << var << " adding water to ha " << ha << std::endl;

	int mynh2o = ++nh2o(aa,var);
	h2opos(mynh2o,aa,var) = pos;
	heavy_atm_on_h2o(mynh2o,aa,var) = ha;
	hyd_atm_on_h2o(mynh2o,aa,var) = ta1;
	if ( fa_acceptor(fullatom_type(ha,aa,var)) ) {
		template_atm_on_h2o(mynh2o,aa,var) = ta2;
	} else {
		template_atm_on_h2o(mynh2o,aa,var) = ta1;
	}
	++nh2o_on_atm(ha,aa,var);
	h2o_on_atm(nh2o_on_atm(ha,aa,var),ha,aa,var) = pos;

// Adjust bonded info
	if( nbonded_neighbors( ha, aa, var ) == max_bonded_neighbors ) {
		std::cout << "FATAL ERROR:  too many bonded neighbors when adding water" <<
		std::endl << " AA: " << aa << " atom number " << ha << std::endl;
		std::exit( EXIT_FAILURE );
	}

	bonded_neighbor( ++nbonded_neighbors( ha, aa, var ), ha, aa, var ) = pos;
	nbonded_neighbors( pos, aa, var ) = 1;
	bonded_neighbor( 1, pos, aa, var ) = ha;

//bk   templates for building water
	ta(1,pos,aa,var) = ta1;
	ta(2,pos,aa,var) = ta2;
	ta(3,pos,aa,var) = ta3;

//bk   what chi angles define position of water; set same as heavy atom
//bk   it is attached to
	for ( int i = 1; i <= MAX_CHI; ++i ) {
		chi_required(i,pos,aa,var) = chi_required(i,ha,aa,var);
	}

//lin   build the water
	if( is_protein( aa ) ) {
		place_water_by_superimpose(aa,var,twx,twy,twz,icoor(1,pos,aa,var));
	} else {
		///jjh Waters on DNA are placed using internal coordinates
		place_water_by_internal_coords(icoor(1,ta1,aa,var),
			icoor(1,ta2,aa,var), icoor(1,ta3,aa,var),twx,twy,twz,
			icoor(1,pos,aa,var));
	}
	float dis; // distance between water and attached heavy atom
	distance_bk(icoor(1,pos,aa,var),icoor(1,ha,aa,var),dis);

}


////////////////////////////////////////////////////////////////////////////////
/// @begin place_water_by_superimpose
///
/// @brief get the water position
///
/// @detailed  superimpose the water postion (twx,twy,twz) to the template coordinate
///       return the final water postion. only for five polar residue:
///       Asp,Asn,Glu,Gln and Arg
///
///       the co-ordinates of the basis side-chain for
///       template and Roe's model (Boston College)
///       Roe SM & Teeter MM (1993) JMB 229, 419-427
///
/// @param[in]   aa          - in -  amino acid
/// @param[in]   var         - in -  varient of this rotamer
/// @param[in]   twx,twy.twz - in - coordinate for building water
/// @param[out]   xyz_h2o     - out- output the  co-ordinates of water
///
/// @global_read
/// variables from "aaproperties_pack.h"
///     icoor  - template coordinates of each atom pre aa
/// variables from "param_aa.h"
///     aa_arg,aa_asp,aa_asn,aa_glu,aa_gln
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang 09/19/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
place_water_by_superimpose(
	int const aa,
	int const var,
	float const twx,
	float const twy,
	float const twz,
	FArray1Da_float xyz_h2o // output the  co-ordinates of water
)
{
	using namespace aaproperties_pack;
	using namespace param_aa;

	xyz_h2o.dimension( 3 );

//lin superimpose water on the template of polar rotamers based on the
//lin co-ordinates of basic side chain atoms, return the  co-ordinates
//lin of water

//lin local
	int i,j,k;
	FArray2D_float xyz1( 3, 5 ); // an array of atom co-ordinates including water
	FArray2D_float xyz2( 3, 4 ); // an array of atom co-ordinates of template
	FArray2D_double p1( 3, 4 );
	FArray2D_double p2( 3, 4 );
	FArray1D_double ww( 4 );
	FArray1D_double p1_offset( 3 );
	FArray1D_double p2_offset( 3 );
	FArray2D_double uu( 3, 3 );
	double sigma3;


	if ( aa == aa_arg ) {
//lin  for arg
		xyz1(1,1) = 0.000; // NE
		xyz1(2,1) = 0.000;
		xyz1(3,1) = 0.000;
		xyz1(1,2) = 0.000; // CZ
		xyz1(2,2) = 1.332;
		xyz1(3,2) = 0.000;
		xyz1(1,3) = 1.148; // NH1
		xyz1(2,3) = 2.003;
		xyz1(3,3) = 0.000;
		xyz1(1,4) = -1.148; // NH2
		xyz1(2,4) = 2.003;
		xyz1(3,4) = 0.000;
		for ( i = 1; i <= 3; ++i ) {
			xyz2(i,1) = icoor(i,8,aa,var); // NE
		}
		for ( i = 1; i <= 3; ++i ) {
			xyz2(i,2) = icoor(i,9,aa,var); // CZ
		}
		for ( i = 1; i <= 3; ++i ) {
			xyz2(i,3) = icoor(i,10,aa,var); // NH1
		}
		for ( i = 1; i <= 3; ++i ) {
			xyz2(i,4) = icoor(i,11,aa,var); // NH2
		}

	}

	if ( (aa == aa_asn) || (aa == aa_gln) ) {
//lin  for asn or gln
		xyz1(1,1) = 0.000; // CB
		xyz1(2,1) = 0.000;
		xyz1(3,1) = 0.000;
		xyz1(1,2) = 0.000; // CG
		xyz1(2,2) = 1.516;
		xyz1(3,2) = 0.000;
		xyz1(1,3) = 1.067; // OD1
		xyz1(2,3) = 2.165;
		xyz1(3,3) = 0.000;
		xyz1(1,4) = -1.192; // OD2
		xyz1(2,4) = 2.097;
		xyz1(3,4) = 0.000;
		if ( aa == aa_asn ) {
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,1) = icoor(i,5,aa,var); // CB
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,2) = icoor(i,6,aa,var); // CG
			}

			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,3) = icoor(i,7,aa,var); // OD1
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,4) = icoor(i,8,aa,var); // ND2
			}
		} else {
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,1) = icoor(i,6,aa,var); // CG
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,2) = icoor(i,7,aa,var); // CD
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,3) = icoor(i,8,aa,var); // OE1
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,4) = icoor(i,9,aa,var); // NE2
			}
		}

	}

	if ( (aa == aa_asp) || (aa == aa_glu) ) {
//lin  for asp or glu

		xyz1(1,1) = 0.000; // CB
		xyz1(2,1) = 0.000;
		xyz1(3,1) = 0.000;
		xyz1(1,2) = 0.000; // CG
		xyz1(2,2) = 1.500;
		xyz1(3,2) = 0.000;
		xyz1(1,3) = 1.064; // OD1
		xyz1(2,3) = 2.118;
		xyz1(3,3) = 0.000;
		xyz1(1,4) = -1.119; // OD2
		xyz1(2,4) = 2.073;
		xyz1(3,4) = 0.000;
		if ( aa == aa_asp ) {
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,1) = icoor(i,5,aa,var); // CB
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,2) = icoor(i,6,aa,var); // CG
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,3) = icoor(i,7,aa,var); // OD1
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,4) = icoor(i,8,aa,var); // OD2
			}
		} else {
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,1) = icoor(i,6,aa,var); // CG
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,2) = icoor(i,7,aa,var); // CD
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,3) = icoor(i,8,aa,var); // OE1
			}
			for ( i = 1; i <= 3; ++i ) {
				xyz2(i,4) = icoor(i,9,aa,var); // OE2
			}
		}

	}

//lin  get the co-ordinates of water
	xyz1(1,5) = twx; // for water
	xyz1(2,5) = twy;
	xyz1(3,5) = twz;

//car pack arrays for find_UU,UU_rotate
	for ( j = 1; j <= 4; ++j ) {
		for ( k = 1; k <= 3; ++k ) {
			p1(k,j) = xyz1(k,j);
			p2(k,j) = xyz2(k,j);
		}
		ww(j) = 1.0; // weight all atoms equally
	}
//	for ( j = 1; j <= 4; ++j ) {
//		std::cout << "p1(k," << j << ")  " << SS( p1(1,j) ) << SS( p1(2,j) ) <<
//		 SS( p1(3,j) ) << std::endl;
//	}
//	std::cout << "tw(xyz) " << SS( twx ) << SS( twy ) << SS( twz ) << std::endl;
//	for ( j = 1; j <= 4; ++j ) {
//		std::cout << "p2(k," << j << ")  " << SS( p2(1,j) ) << SS( p2(2,j) ) <<
//		 SS( p2(3,j) ) << std::endl;
//	}
//	std::cout << "sigma3" << SS( sigma3 ) << std::endl;

	findUU_trans(p1,p2,ww,4,uu,sigma3,p1_offset,p2_offset);

//      std::cout << "sigma3 " << sigma3 << std::endl;
//      std::cout << "uu " << uu << std::endl;
//      std::cout << "p1_offset " << p1_offset << std::endl;
//      std::cout << "p2_offset " << p2_offset << std::endl;

	UU_rotate(xyz1,5,p1_offset,p2_offset,uu);
//      for ( j = 1; j <= 5; ++j ) {
//         std::cout << "xyz1(k," << j << ")  " << SS( xyz1(1,j) ) <<
//				  SS( xyz1(2,j) ) << SS( xyz1(3,j) ) << std::endl;
//      }
//
	for ( i = 1; i <= 3; ++i ) {
		xyz_h2o(i) = xyz1(i,5); // the co-ordinates of water
	}
//      std::cout << "change_tw" << SS( xyz_h2o(1) ) << SS( xyz_h2o(2) ) <<
//			 SS( xyz_h2o(3 ) << std::endl;
//      if ( xyz_h2o(1) == twx || xyz_h2o(2) == twy || xyz_h2o(3) == twz ) {
//        std::cout << "ERROR!!!" << std::endl;
//      }

}


////////////////////////////////////////////////////////////////////////////////
/// @begin place_water_by_internal_coords
///
/// @brief get the water position
///
/// @detailed  place a water molecule relative to three reference atoms
///				using a length, angle, and torsion
///       return the final water postion.
///
///
/// @param[in]   aa          - in -  amino acid
/// @param[in]   var         - in -  varient of this rotamer
/// @param[in]   twx,twy.twz - in - coordinate for building water
/// @param[out]   xyz_h2o     - out- output the  co-ordinates of water
///
/// @global_read
/// variables from "aaproperties_pack.h"
///     icoor  - template coordinates of each atom pre aa
/// variables from "param_aa.h"
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Jim Havranek 08/20/2006
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
place_water_by_internal_coords(
	FArray1Da_float ref1,
	FArray1Da_float ref2,
	FArray1Da_float ref3,
	float length,
	float angle,
	float torsion,
	FArray1Da_float xyz_h2o // output the  co-ordinates of water
)
{
	using namespace aaproperties_pack;
	using namespace param_aa;

	float const DEG2RAD = { 3.141592654f/180.0f };

	ref1.dimension( 3 );
	ref2.dimension( 3 );
	ref3.dimension( 3 );
	xyz_h2o.dimension( 3 );

	angle *= DEG2RAD;
	torsion *= DEG2RAD;

	float sin_angle = std::sin( angle );
	float cos_angle = std::cos( angle );

	float sin_torsion = std::sin( torsion );
	float cos_torsion = std::cos( torsion );

	FArray1D_float tmp1( 3 );
	FArray1D_float tmp2( 3 );

	tmp1(1) = ref2(1) - ref3(1);
	tmp1(2) = ref2(2) - ref3(2);
	tmp1(3) = ref2(3) - ref3(3);
	tmp2(1) = ref1(1) - ref2(1);
	tmp2(2) = ref1(2) - ref2(2);
	tmp2(3) = ref1(3) - ref2(3);

	float mag_tmp1 = std::sqrt( tmp1( 1 ) * tmp1( 1 ) +
		tmp1( 2 ) * tmp1( 2 ) +  tmp1( 3 ) * tmp1( 3 ) );

	tmp1(1) = tmp1(1) / mag_tmp1;
	tmp1(2) = tmp1(2) / mag_tmp1;
	tmp1(3) = tmp1(3) / mag_tmp1;

	FArray1D_float tmp3( 3 );

	tmp3( 1 ) = tmp2(2)*tmp1(3)-tmp2(3)*tmp1(2);
	tmp3( 2 ) = tmp2(3)*tmp1(1)-tmp2(1)*tmp1(3);
	tmp3( 3 ) = tmp2(1)*tmp1(2)-tmp2(2)*tmp1(1);

	float mag_tmp3 = std::sqrt( tmp3( 1 ) * tmp3( 1 ) +
		tmp3( 2 ) * tmp3( 2 ) +  tmp3( 3 ) * tmp3( 3 ) );

	tmp3(1) = tmp3(1) / mag_tmp3;
	tmp3(2) = tmp3(2) / mag_tmp3;
	tmp3(3) = tmp3(3) / mag_tmp3;

	tmp2( 1 ) = tmp1(2)*tmp3(3)-tmp1(3)*tmp3(2);
	tmp2( 2 ) = tmp1(3)*tmp3(1)-tmp1(1)*tmp3(3);
	tmp2( 3 ) = tmp1(1)*tmp3(2)-tmp1(2)*tmp3(1);

	FArray1D_float tmp4( 3 );

	tmp4( 1 ) = length * cos_angle;
	tmp4( 2 ) = length * sin_angle * cos_torsion;
	tmp4( 3 ) = length * sin_angle * sin_torsion;

	xyz_h2o( 1 ) = ref3( 1 ) + tmp4(1)*tmp1(1)+tmp4(2)*tmp2(1)+tmp4(3)*tmp3(1);
	xyz_h2o( 2 ) = ref3( 2 ) + tmp4(1)*tmp1(2)+tmp4(2)*tmp2(2)+tmp4(3)*tmp3(2);
	xyz_h2o( 3 ) = ref3( 3 ) + tmp4(1)*tmp1(3)+tmp4(2)*tmp2(3)+tmp4(3)*tmp3(3);

}

//==========================================
// functions for native water input/output
// Lin Jiang 09/19/2003
//==========================================

////////////////////////////////////////////////////////////////////////////////
/// @begin  read_pdb_water
///
/// @brief  read water from pdbfiles
///
/// @detailed   read water information from pdb files. Waters are treated as hetero
///        atoms. Only buried water is considered, whose neighbor number is
///        >=10.
///
/// @param[in]   iunit   - in - point for the reading line // changing
/// @param[in]   aan_in  - in - the input sequence
/// @param[in]   xyz_in  - in - the input coordinate array
/// @param[in]   nres_in - in - the total residue number
///
/// @global_read
/// variables from "param.h"
///      MAX_H2OATOM - size of hetero waters
///
/// @global_write
/// variables from "water.h"
///      h2o_position     - each water positon
///      water_neighbors  - how many neighbors of each water
///      N_h2oatom        - number of hetero water
///      h2o_pdbline      - this info from input pdbfiles
///
/// @remarks just reading water oxygen!
///
/// @references
///
/// @authors Lin Jiang 09/19/2003
///
/// @last_modified jk 06/08/2005
/////////////////////////////////////////////////////////////////////////////////
void
read_pdb_water(
	utility::io::irstream & iunit, // stream of file
	FArray1Da_int aan_in,
	FArray3Da_float xyz_in,
	int & nres_in
)
{
	using namespace misc;
	using namespace param;
	using namespace water;

	aan_in.dimension( MAX_RES() );
	xyz_in.dimension( 3, MAX_ATOM(), MAX_RES() );

//**  LOCAL VARIABLES
	std::string pdb_card;
	std::string atom_name;
	std::string res_name;
	char chain_id; // key to id chain
	char conf_id; // key to id multiple atom conformations
	int pdb_res; // residue number in pdb file
	char insert_id; // key to id insertions
	FArray1D_float h2opos( 3 ); // coordinates
	float bfactor;
	float occ;
	int h2o_neighbors; // the neighbor number of water
	bool done_full_coord_init = false; // is full_coord initialized?
	bool is_buried; // if ture, it is bured water
	int atom_num; // atom# as defined in global.h
	int h2oatom_count;
	std::string line;
	std::istringstream line_stream;


//******************************************************************************
	if ( !read_hetero_h2o ) return;

	iunit.seek_beg();

	std::cout << "reading native water into structures" << std::endl;

	h2oatom_count = 0; // initialize, all old water atoms gone

L650:
	iunit.getline( line );
	if ( iunit.eof() ) goto L550;
	line_stream.clear();
	line_stream.str( line );
	line_stream.seekg( std::ios_base::beg );
	line_stream >> bite( 6, pdb_card ) >> skip( 6 ) >>
	 bite( 4, atom_name ) >> bite( conf_id ) >> bite( 3, res_name ) >>
	 skip( 1 ) >> bite( chain_id ) >> bite( 4, pdb_res ) >>
	 bite( insert_id ) >> skip( 3 ) >>
	 bite( 8, h2opos(1) ) >> bite( 8, h2opos(2) ) >> bite( 8, h2opos(3) ) >>
	 bite( 6, occ ) >> bite( 6, bfactor ) >> skip;
	if ( line_stream.fail() ) {
		goto L650;
	}

	if ( res_name != "HOH" ) goto L650; // just reading water
	if ( pdb_card != "HETATM" ) goto L650; // just reading hetero waters
	if ( atom_name != " O  " ) goto L650; // just reading water oxygen

	if ( pdb_card == "END   " ) goto L550;
	if ( pdb_card == ".     " ) goto L550;
	if ( pdb_card[1] == '%' )   goto L550; // rosetta output
	if ( pdb_card == "ENDMDL" ) goto L550;

	if ( h2oatom_count < MAX_H2OATOM - 1 ) {

		if ( hetero_h2oneighbors_cutoff > 0 ) {
			// jk The transfer of coors in the Eposition array to the
			// jk full_coord array hasn't happened yet, but we need this to
			// jk assess burial. Do it now (but only once, not for every water)!
			if ( ! done_full_coord_init ) {
				initialize_fullcoord_array( Eposition, xyz_in, total_residue, res, res_variant );
				done_full_coord_init = true;
			}
			is_buried_water(aan_in,nres_in,xyz_in,h2opos,h2o_neighbors,is_buried);
		} else {
			is_buried = true;
		}

		if ( is_buried ) {
			atom_num = 25; // assign the atom number for water
			++h2oatom_count;
			h2o_position(1,h2oatom_count) = h2opos(1);
			h2o_position(2,h2oatom_count) = h2opos(2);
			h2o_position(3,h2oatom_count) = h2opos(3);
			hetero_water_neighbors(h2oatom_count) = h2o_neighbors;
			h2o_pdbline(h2oatom_count) = line;
		}
	}
	goto L650;

L550:
	N_h2oatom = h2oatom_count;
	std::cout << "Number of native water is " << N_h2oatom << std::endl;

}


////////////////////////////////////////////////////////////////////////////////
/// @begin make_pdb_water
///
/// @brief output the water infomation
///
/// @detailed  This just appends the input hetero water info and water neighbors
///       to the end of the pdb file
///
/// @param[out]   iunit   - in - point for the output line
///
/// @global_read
/// variables from "water.h"
///     N_h2oatom        - number of hetero water
///     water_neighbors  - how many neighbors of each water
///     h2o_pdbline      - this info from input pdbfiles
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang 09/19/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
make_pdb_water( utility::io::orstream & iunit )
{
//lin copy from make_pdb_hetero

	using namespace water;

  if ( N_h2oatom == 0 ) return;

	for ( int i = 1; i <= N_h2oatom; ++i ) {
		iunit << h2o_pdbline(i) << ' ' <<
		 I( 8, hetero_water_neighbors(i) ) << "\n";
	}
  iunit << A( 3, "TER" ) << std::endl;

}


void
water_use_atom_initializer( FArray1D_int & use_atom )
{
	int i = 0;
	use_atom( ++i ) = 5; // A,C,D,E,F
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 2; // G,H,I,K,L
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5; // M,N,P,Q,R
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5; // S,T,V,W,Y
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	use_atom( ++i ) = 5;
	if ( add_pser() ) {
		//KMa phospho_ser
		use_atom( ++i ) = 5;
	}
	if ( design::dna_interface ) {
		use_atom( ++i ) = 5;  // KMa phospho_ser
		use_atom( ++i ) = 11; // G,A,C,T
		use_atom( ++i ) = 11;
		use_atom( ++i ) = 11;
		use_atom( ++i ) = 11;
		use_atom( ++i ) = 12; // rG,rA,rC,rT
		use_atom( ++i ) = 12;
		use_atom( ++i ) = 12;
		use_atom( ++i ) = 12;
	}
	if( get_enable_ligaa_flag() ){
		use_atom( ++i ) = 1; // ligand
		use_atom( ++i ) = 1;
	}
}


//=========================================
// functions for counting water neighbors
// Lin Jiang 09/19/2003
//=========================================

////////////////////////////////////////////////////////////////////////////////
/// @begin is_buried_water
///
/// @brief judge whether this water is buried
///
/// @detailed  count the Cb neighbors around this water, define this water is
///       buried or not.
///
/// @param[in]   aan           - in  - the input sequence
/// @param[in]   nres          - in  - the total residue number
/// @param[in]   xyz           - in  - the input coordinate array of protein
/// @param[in]   coordh2o      - in  - the coordinate of this water
/// @param[out]   h2o_neighbors - out - how many neighbors this water have
/// @param[out]   is_buried     - out - true if this water is buried
///
/// @global_read
/// variables from "water.h"
///    h2o_interaction_dis2_cutoff - close water distance cutoff
///    hetero_h2oneighbors_cutoff  - native water neighbor number cutoff
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors  Lin Jiang  09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
is_buried_water(
	FArray1Da_int aan,
	int nres,
	FArray3Da_float xyz,
	FArray1Da_float coordh2o,
	int & h2o_neighbors,
	bool & is_buried
)
{
	using namespace param;
	using namespace water;

	aan.dimension( MAX_RES() );
	xyz.dimension( 3, MAX_ATOM(), MAX_RES() );
	coordh2o.dimension( 3 );

	static FArray1D_int const use_atom( MAX_AA(), water_use_atom_initializer );

	float dis2;

	h2o_neighbors = 0;
	is_buried = false;

	for ( int res1 = 1; res1 <= nres; ++res1 ) {
		int aa1 = aan(res1);
		distance2_bk(xyz(1,use_atom(aa1),res1),coordh2o,dis2);
		if ( dis2 <= h2o_interaction_dis2_cutoff ) {
			++h2o_neighbors;
		}
	}
	if ( h2o_neighbors >= hetero_h2oneighbors_cutoff ) is_buried = true;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin count_native_water_neighbors
///
/// @brief get neighbor number information of all native water
///
/// @detailed  count the Cb neighbors number around all native water
///
/// @param[in]   aan_in           - in  - the input sequence
/// @param[in]   nres_in          - in  - the total residue number
/// @param[in]   xyz_in           - in  - the coordinate of current structure
/// @param[in]   N_h2oatm         - in  - the total native water number
/// @param[in]   coordw           - in  - the native water position
/// @param[out]   neighbors        - out - neighbor numbers of all the water
///
/// @global_read
/// variables from "param.h"
///    MAX_RES, MAX_ATOM
/// variables from "water.h"
///    MAX_H2OATOM
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors  Lin Jiang  09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
count_native_water_neighbors(
	FArray1Da_int aan_in,
	int nres_in,
	FArray3Da_float xyz_in,
	int N_h2oatm, // # of water in the list
	FArray2Da_float coordw, // postion of water in the water list
	FArray1Da_int neighbors
)
{
	using namespace param;
	using namespace water;

	aan_in.dimension( MAX_RES() );
	xyz_in.dimension( 3, MAX_ATOM(), MAX_RES() );
	coordw.dimension( 3, MAX_H2OATOM );
	neighbors.dimension( MAX_H2OATOM );

//  local
	int counts;
	bool is_buried;


	for ( int h2o1 = 1; h2o1 <= MAX_H2OATOM; ++h2o1 ) {
		neighbors(h2o1) = 0;
	}

	for ( int h2o1 = 1; h2o1 <= N_h2oatm; ++h2o1 ) {
		is_buried_water(aan_in,nres_in,xyz_in,coordw(1,h2o1),counts,is_buried);
		neighbors(h2o1) = counts;
	}
}


////////////////////////////////////////////////////////////////////////////////
/// @begin count_explicit_water_neighbors
///
/// @brief get neighbor number information of all native water
///
/// @detailed  count the Cb neighbors number around all native water
///
/// @param[in]   aan_in           - in  - the input sequence
/// @param[in]   aav_in           - in  - the input sequence variant
/// @param[in]   nres_in          - in  - the total residue number
/// @param[in]   xyz_in           - in  - the coordinate of current structure
/// @param[out]   neighbors        - out - neighbor numbers of all the water
///
/// @global_read
/// variables from "param.h"
///    MAX_RES, MAX_ATOM
/// variables from "water.h"
///    MAX_H2OATOM
///    MAX_H2O_PER_AA    - max water number attached to each amino acid
///
/// @global_write  none
///
/// @remarks
///
/// @references
///
/// @authors  Lin Jiang  09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
count_explicit_water_neighbors(
	FArray1DB_int const & aan_in,
	FArray1DB_int const & aav_in,
	int nres_in,
	FArray3DB_float const & xyz_in,
	FArray2DB_int & neighbors
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace water;


	neighbors = 0;

//lin  loop1 going through all atoms
	int counts;
	bool is_buried;
	for ( int res1 = 1; res1 <= nres_in; ++res1 ) {
		int aa1 = aan_in(res1);
		int aav1 = aav_in(res1);
		for ( int n = 1, l = h2opos.index(n,aa1,aav1), ne = nh2o(aa1,aav1); n <= ne;
		 ++n, ++l ) {
			int h2o1 = h2opos[ l ]; // h2opos(n,aa1,aav1);
			is_buried_water(aan_in,nres_in,xyz_in,xyz_in(1,h2o1,res1),counts,
			 is_buried);
			neighbors(n,res1) = counts;
		}
	}
}


////////////////////////////////////////////////////////////////////////////////
/// @begin buried_water_check
///
/// @brief check whether there are exposed water in this aa variant
///
/// @detailed  check whether there are exposed water in this aa variant
///
/// @param[in]   aa         - in - amino acid index
/// @param[in]   aav        - in - amino acid variant index
/// @param[in]   res        - in - residue number
/// @param[in]   coord      - in - coordinates of sidechain
/// @param[in]   xyz        - in - coordinates of protein
/// @param[in]   aan        - in - protein sequence
/// @param[in]   aa_variant - in - sequence variants
/// @param[in]   nres       - in - number of residues in the protein
/// @param[out]   is_exposed - out- return value is true if this aa variant has
///                           an exposed water
///
/// @global_read
/// variables from "aaproperties_pack.h"
///    nh2o      - water number of this variant
///    h2opos    - water postion
/// variables from "water.h"
///    h2o_interaction_dis2_cutoff - close water distance cutoff
///    buried_h2oneighbors_cutoff  - aa variant water neighbor number cutoff
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors  Lin Jiang 09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
water_rotamer_check(
	int aa,
	int aav,
	FArray2Da_float coord,
	FArray3Da_float xyz,
	FArray1Da_int aan,
	FArray1Da_int aa_variant,
	int nres,
	FArray1Da_int h2o_nb, // water neighbors
	bool & is_exposed,
	float & h2o_intra_repE,
	float & h2o_intra_hbE
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace water;

	coord.dimension( 3, MAX_ATOM() );
	xyz.dimension( 3, MAX_ATOM(), star );
	aan.dimension( star );
	aa_variant.dimension( star );
	h2o_nb.dimension( MAX_H2O_PER_AA );

//bk local variables
	float dis2;
	h2o_intra_repE = 0.0;
	h2o_intra_hbE = 0.0;

	static FArray1D_int const use_atom( MAX_AA(), water_use_atom_initializer );

	is_exposed = false;
	for ( int n = 1; n <= MAX_H2O_PER_AA; ++n ) {
		h2o_nb(n) = 0;
	}

	for ( int n = 1, ne = nh2o( aa, aav ); n <= ne; ++n ) {
		int neighbors_l = 0;
		int h2o1 = h2opos( n, aa, aav );
		h2o_intra_hbE = 0.0;

		for ( int atm2 = 1, atome = natoms( aa, aav ); atm2 <= atome; ++atm2 ) {
			int atm2_type = fullatom_type( atm2, aa, aav );
			if ( atm2_type != type_h2o ) {
				fast_pairenergy_h2o( type_h2o, coord(1,h2o1), atm2_type, coord(1,atm2), h2o_intra_repE );
				if ( h2o_intra_repE > h2oE_clash_cut ) return;
// 				h2o_hbenergy(type_h2o,coord(1,h2o1),explicit_water_neighbors(n,res),
// 						atm2_type,coord2(1,atm2),atm0_type,coord1(1,atm0),atm2a_type,
// 						coord2(1,atm2a),atm0a_type,coord1(1,atm0a),h2ohbE,false);
			}
		}



		for ( int bbres = 1; bbres <= nres; ++bbres ) {
		 // loop through backbone positions
			int bbaa = aan(bbres);
			distance2_bk(xyz(1,use_atom(bbaa),bbres),coord(1,h2o1),dis2);
			if ( dis2 <= h2o_interaction_dis2_cutoff ) {
				++neighbors_l;
			}
		} // end looping through backbone positions
		if ( neighbors_l < buried_h2oneighbors_cutoff ) {
			is_exposed = true;
			return;
		}
//lin put the neighbor number here!
//         h2o_nb(n) = neighbors_l;
	}

}

//==============================================================================
// functions for getting energies between water and proteins
// Lin Jiang 09/19/2003
//==============================================================================

////////////////////////////////////////////////////////////////////////////////
/// @begin get_h2oE
///
/// @brief get the water energy between two amino acids
///
/// @detailed  get the lj repulsive and water-mediated H-bonding interactions
///       between water and protein atoms (including backbone and sidechain).
///       The water interaction of native water is also included.
///
/// @param[in]   aa1,aa2       - in - two amino acids
/// @param[in]   aav1,aav2     - in - the variants of this two amino acids
/// @param[in]   coord1,coord2 - in - the coordinate
/// @param[in]   nbin1,nbin2   - in - neighbor bin
/// @param[in]   res1,res2     - in - residue id
/// @param[out]   h2oE          - out- lj repulsive energy
/// @param[out]   h2ohbE        - out- water-mediated H-bond energy
///
/// @global_read
/// variables from "param.h"
///     MAX_ATOM         -  max number of atoms per amino acid
/// variables from "water.h"
///     Wh2ohb_env_dep   -  environment dependent weight for water-mediated H-bond
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang 09/20/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_h2oE(
	int const aa1,
	int const aa2,
	int const aav1,
	int const aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	int const res1,
	int const res2,
	float & h2oE,
	float & h2ohbE
)
{
	using namespace param;

	coord1.dimension( 3, MAX_ATOM() );
	coord2.dimension( 3, MAX_ATOM() );

//lin residue-residue water energies,
//lin only water-mediated H-bond and LJ replusive energy

	float h2o,h2ohb;

	h2oE = 0.0;
	h2ohbE = 0.0;

//bk sidechain-sidechain
	get_sc_sc_h2oE(aa1,aav1,coord1,aa2,aav2,coord2,res1,res2,h2o,h2ohb);
	h2oE += h2o;
	h2ohbE += h2ohb;

//bk sidechain-backbone
	get_sc_bb_h2oE(aa1,aav1,aa2,aav2,coord1,coord2,res1,res2,h2o,h2ohb);
	h2oE += h2o;
	h2ohbE += h2ohb;

	get_sc_bb_h2oE(aa2,aav2,aa1,aav1,coord2,coord1,res2,res1,h2o,h2ohb);
	h2oE += h2o;
	h2ohbE += h2ohb;

//bk backbone-backbone energy
//lin  currently no backbone-backbone water energy

}

///////////////////////////////////////////////////////////////////////////////
// water mediate hbonds with the rosetta hbond potential
//
//
float
get_h2oE_hbond_potential(
	int const aa_water,
	int const aav_water,
	int const seqpos_water,
	int const aa_solute,
	int const aav_solute,
	int const seqpos_solute,
	FArray2Da_float coord_water,
	FArray2Da_float coord_solute,
	bool const count_bb,
	bool const count_sc
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace param_aa;
	using namespace param_pack;
	using namespace water;

	float h2ohbE = 0.0;

	float const packer_weight( pack_wts.Wh2o() * pack_wts.Wh2o_hb() / -1.50f );

	if ( is_DNA( aa_water ) && is_DNA( aa_solute ) ) return 0.0;

	coord_water.dimension( 3, MAX_ATOM() );
	coord_solute.dimension( 3, MAX_ATOM() );

	///////////
	//// params
	float const max_acceptor_acceptor_d2( 16.0 );

	// data for building the H on the water:
	//
	static float const HO_dist( 0.96 );
	static float const theta( numeric::conversions::radians( 107.0 ) );
	static float const HO_x_pos( HO_dist * std::cos( theta ) );
	static float const HO_y_pos( HO_dist * std::sin( theta ) );

	// reuse
  float energy;
	FArray1D_float hxyz(3);
	typedef numeric::xyzVector_float Vec;
	static FArray2D_float deriv(3,2);
  // global HBDerivType water_hbond_deriv_type defined in water_ns  : hbderiv_NONE;


	// first calculate the water-mediated hbond energy
	//
	// this is currently not quite right: the water is not exactly oriented
	// correctly
	//
	// we should really be considering whether the heavy atom that the water is
	// attached to is a donor or an acceptor and modify the orientation of the
	// water accordingly
	//

	for ( int n = 1, ne = nh2o( aa_water, aav_water ); n <= ne; ++n ) {
		int const watm = h2opos( n, aa_water, aav_water );
		int const wbatm = heavy_atm_on_h2o( n, aa_water, aav_water );
		Vec const
			wxyz ( &coord_water(1, watm) ),
			x( ( Vec(&coord_water(1,wbatm)) - wxyz ).normalized() );

		// first cycle through polar hydrogens, then acceptors
		for ( int hnum=1; hnum <= nH_polar(aa_solute,aav_solute); ++hnum ) {
			int const hatm( Hpos_polar(hnum,aa_solute,aav_solute) );
			int const datm( atom_base(hatm,aa_solute,aav_solute) );
			bool const datm_is_sc( !atom_is_backbone( datm, aa_solute, aav_solute ));
			if ( !count_bb && !datm_is_sc || !count_sc && datm_is_sc ) continue;
      HBEvalType const hbe_type = hbond_evaluation_type_HOHacceptor(datm, aa_solute, aav_solute);

			// call hbond energy routine
      hb_energy_deriv(hbe_type,
				coord_solute(1,datm),
				coord_solute(1,hatm),
				coord_water(1,watm),
				coord_water(1,wbatm), // atom_base
				coord_water(1,wbatm), //JSS fix abase2
        energy, water_hbond_deriv_type, deriv);
			if ( energy < 0.0 ) {
				h2ohbE += energy;
				if ( water_hbond_deriv_type != hbonds::hbderiv_NONE ) {
					// sum the contributions at the acceptor and donor
					// the sign is +1 for the donor and -1 for the acceptor
					for ( int j=1; j<= 2; ++j ) { // F1 then F2
						for ( int k=1; k<= 3; ++k ) {
							water_hbond_deriv( k, j, hatm, seqpos_solute ) += deriv(k,j);
							water_hbond_deriv( k, j, watm, seqpos_water  ) -= deriv(k,j);
						}
					}
				}
#ifdef GL_GRAPHICS
				if ( inside_fullatom_energy() ) {
					gl_graphics_store_bond( seqpos_solute, datm, seqpos_water, watm,
						packer_weight * energy, graphics::WATER_HBOND );
				}
#endif
			} // energy < 0.0
		} // hnum =1,nH_polar

		// now the acceptors
		for ( int anum=1; anum<= nacceptors(aa_solute,aav_solute); ++anum ) {
			int const aatm( accpt_pos(anum,aa_solute,aav_solute) );
			bool const aatm_is_sc( !atom_is_backbone( aatm, aa_solute, aav_solute ));
			if ( !count_bb && !aatm_is_sc || !count_sc && aatm_is_sc ) continue;

			// check distance
			Vec const v( Vec(&coord_solute(1,aatm)) - wxyz );
			if ( v.length_squared() > max_acceptor_acceptor_d2 ) continue;
			HBEvalType const hbe_type = hbond_evaluation_type_HOHdonor(aatm,aa_solute,aav_solute);
			int const base  = atom_base(aatm,aa_solute,aav_solute);
			int const base2	( abase2(aatm,aa_solute,aav_solute) ); //base2 is defined for all acceptors

			// build the hydrogen position
			Vec const z( cross( x, v ).normalized() ),
				y( cross( z, x ) );
			for ( int k=1; k<= 3; ++k ) {
				hxyz(k) = wxyz(k) + HO_x_pos * x(k) + HO_y_pos * y(k);
			}

			// call hbond energy routine
			float energy(0.0);
			deriv = 0.0;
			hb_energy_deriv(hbe_type,
				coord_water(1,watm),
				hxyz,
				coord_solute(1,aatm),
				coord_solute(1,base),
				coord_solute(1,base2),
				energy, water_hbond_deriv_type, deriv);

			if ( energy < 0.0 ) {
				h2ohbE += energy;

				if ( water_hbond_deriv_type != hbonds::hbderiv_NONE ) {
					// sum in the contributions at the acceptor and donor
					// the sign is +1 for the donor and -1 for the acceptor
					for ( int j=1; j<= 2; ++j ) { // F1 then F2
						for ( int k=1; k<= 3; ++k ) {
							water_hbond_deriv( k, j, watm, seqpos_water  ) += deriv(k,j);
							water_hbond_deriv( k, j, aatm, seqpos_solute ) -= deriv(k,j);
						}
					}
				}
#ifdef GL_GRAPHICS
				if ( inside_fullatom_energy() ) {
					gl_graphics_store_bond( seqpos_water, watm, seqpos_solute, aatm,
						packer_weight * energy, graphics::WATER_HBOND );
				}
#endif
			} // energy<0
		} // anum=1,nacceptors
	}
	return h2ohbE * packer_weight;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_bb_h2oE
///
/// @brief get the energy between waters and backbone atoms
///
/// @detailed  get the lj repulsive and water-mediated H-bond interactions
///       between water and protein backbone atoms
///
/// @param[in]   aasc    - in  - amino acid which the waters belong to
/// @param[in]   aavsc   - in  - the variant that the waters belong to
/// @param[in]   aabb    - in  - amino acid which the backbone atoms belong to
/// @param[in]   aavbb   - in  - the variant that the backbone atoms belong to
/// @param[in]   coordsc - in  - the coordinate of the residue the waters belong to
/// @param[in]   coordbb - in  - the coordinate of the residue the backbone atoms belong to
/// @param[in]   ressc   - in  - residue id in which the waters are
/// @param[in]   resbb   - in  - residue id in which the backbone atoms are
/// @param[out]   h2oE    - out - the lj repulsive energy
/// @param[out]   h2ohbE  - out - the water-mediated H-bond energy
///
/// @global_read
/// variables from "param.h"
///     MAX_ATOM         -  max number of atoms per amino acid
/// variables from "aaproperties_pack.h"
///     nh2o             -  number of water atoms
///     fullatom_type    -  fullatom type
///     h2opos           -  position of water
///
/// @global_write none
///
/// @remarks only lj repulsive interactions between water and protein atoms
///
/// @references
///
/// @authors Lin Jiang 08/19/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_sc_bb_h2oE(
	int const & aasc,
	int const & aavsc,
	int const & aabb,
	int const & aavbb,
	FArray2Da_float coordsc,
	FArray2Da_float coordbb,
	int const & ressc,
	int const & resbb,
	float & h2oE,
	float & h2ohbE
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace param_aa;
	using namespace water;

	h2oE = 0.0;
	h2ohbE = 0.0;

	if( is_DNA( aasc ) && is_DNA( aabb ) ) return;

	coordsc.dimension( 3, MAX_ATOM() );
	coordbb.dimension( 3, MAX_ATOM() );

//bk energy between waters attached to sidechain and backbone atoms

	int atmref = -1;
	int atmref_type = -1;
	float ang_tmp;

	for ( int n = 1, ne = nh2o( aasc, aavsc ); n <= ne; ++n ) {
		int atmsc = h2opos( n, aasc, aavsc );
		int atmsc_type = fullatom_type( atmsc, aasc, aavsc );
		int atmsc0 = heavy_atm_on_h2o( n, aasc, aavsc );
		int atmsc0_type = fullatom_type( atmsc0, aasc, aavsc );
		int atmsc0a = template_atm_on_h2o( n, aasc, aavsc );
		int atmsc0a_type = fullatom_type( atmsc0a, aasc, aavsc );
//$$$$clin
//$$$$clin    if atmsc is water, find the heavy atom the water is connected with
//$$$$clin
//$$$$         if ( atmsc_type == type_h2o ) {
//$$$$            for ( int i = 1, ie = natoms( aasc, aavsc ); i <= ie; ++i ) {
//$$$$               for ( int j = 1, je = nh2o_on_atm( i, aasc, aavsc ); j <= je; ++j ) {
//$$$$                  if ( h2o_on_atm( j, i, aasc, aavsc ) == atmsc ) {
//$$$$                     atmref = i;
//$$$$                     atmref_type = fullatom_type( atmref, aasc, aavsc );
//$$$$                  }
//$$$$               }
//$$$$            }
//$$$$         }
		for ( int atmbb = 1; atmbb <= 4; ++atmbb ) {
			int atmbb_type = fullatom_type( atmbb, aabb, aavbb );
			fast_pairenergy_h2o( atmsc_type, coordsc(1,atmsc), atmbb_type,
			 coordbb(1,atmbb), h2oE );
//lin  water_mediated hydrogen bonding energy
			find_h2ohb_template_atom(atmsc_type,coordsc(1,atmsc),atmbb,aabb,aavbb,
			 atmbb_type,coordbb,atmref,atmref_type,ang_tmp);
			h2o_hbenergy(atmsc_type,coordsc(1,atmsc),
			 explicit_water_neighbors(n,ressc),atmbb_type,coordbb(1,atmbb),atmsc0_type,
			 coordsc(1,atmsc0),atmref_type,coordbb(1,atmref),atmsc0a_type,
			 coordsc(1,atmsc0a),h2ohbE,use_water_bonus);
		}
	}

//lin  water_mediated H-bond energy formed by native water
//lin  Be carreful! the atmsc is not water atom but protein atom from aav1
	if ( use_hetero_h2o ) {
		for ( int atmsc = 5, atmsce = natoms( aasc, aavsc ); atmsc <= atmsce; ++atmsc ) {
			int atmsc_type = fullatom_type( atmsc, aasc, aavsc );
			for ( int atmbb = 1; atmbb <= 4; ++atmbb ) {
				int atmbb_type = fullatom_type( atmbb, aabb, aavbb );
				fast_pairenergy_hetero_h2ohb( atmsc, aasc, aavsc, atmsc_type, coordsc, atmbb,
				 aabb, aavbb, atmbb_type, coordbb, N_h2oatom, h2o_position, h2ohbE );
			}
		}
	}

	if ( use_hbond_potential ) {
		// recalculate!
//		float const old_h2ohbE( h2ohbE );
		h2ohbE = get_h2oE_hbond_potential( aasc, aavsc, ressc, aabb, aavbb, resbb,
							 coordsc, coordbb, true/*count_bb*/, false /*count_sc*/);
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_hetero_h2oE
///
/// @brief get energy between side-chain and native waters
///
/// @detailed  get the lj repulsive energy between side-chain and native waters
///
/// @param[in]   aasc    - in - amino acid
/// @param[in]   aavsc   - in - amino acid variant
/// @param[in]   coordsc - in - coordinate
/// @param[out]   h2oE    - out- lj repulsive energy
///
/// @global_read
/// variables from "param.h"
///     MAX_ATOM         -  max number of atoms per amino acid
/// variables from "aaproperties_pack.h"
///     natoms, N_h2oatom, fullatom_type
/// variables from "water.h"
///     water_repulsive_cutoff
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang 09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_sc_hetero_h2oE(
	int const aasc,
	int const aavsc,
	FArray2Da_float coordsc,
	float & h2oE
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace water;

	coordsc.dimension( 3, MAX_ATOM() );

//lin lj repulsive energy between side-chain and native waters

	float dis;

	h2oE = 0.0;

//lin loop through the side chain atoms
	for ( int atmsc = 5, atmsce = natoms( aasc, aavsc ); atmsc <= atmsce; ++atmsc ) {
//lin loop through hetero water atoms, get rotamer-water energies
		for ( int n = 1; n <= N_h2oatom; ++n ) {
			distance_bk(coordsc(1,atmsc),h2o_position(1,n), dis );
			if ( dis < water_repulsive_cutoff ) {
//lin   lj repulsive interaction between water and protein atoms
				fast_pairenergy_h2o( fullatom_type(atmsc,aasc,aavsc), coordsc(1,atmsc),
				 type_h2o, h2o_position(1,n), h2oE );
			}
		}                  // end looping through hetero water positions
	}    // end looping through the side chain atoms
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_hetero_h2oEhb
///
/// @brief get Hbond energy between side-chain and native waters
///
/// @detailed  get the Hbond energy between side-chain and native waters
///
///
/// @remarks
///   Uses the full_coord array for the environment of the desired sidechain
///
/// @references
///
/// @authors jk, Nov. 2005
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_sc_hetero_h2oEhb(
	int const aasc,
	int const aavsc,
	FArray2Da_float rotcoord,
	float & h2ohb_E
)
{
	using namespace aaproperties_pack;
	using namespace misc;
	using namespace param;
	using namespace param_aa;
	using namespace water;

	rotcoord.dimension( 3, MAX_ATOM() );

	h2ohb_E = 0.0;

	for ( int atmsc = 5, atmsce = natoms( aasc, aavsc ); atmsc <= atmsce; ++atmsc ) {
		int atmsc_type = fullatom_type( atmsc, aasc, aavsc );
		for ( int i = 1; i <= total_residue; ++i ) {
			int const aa2 = res(i);
			int const aav2 = res_variant(i);
			int const atm2e = natoms(aa2,aav2);
			FArray2Da_float coord2 = full_coord(1,1,i);
			for ( int atm2=1; atm2 <= atm2e; ++atm2 ) {
				int atm2_type = fullatom_type( atm2, aa2, aav2 );
				fast_pairenergy_hetero_h2ohb( atmsc, aasc, aavsc, atmsc_type, rotcoord, atm2,
				 aa2, aav2, atm2_type, coord2, N_h2oatom, h2o_position, h2ohb_E );
			}
		}
	}

	return;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_sc_h2oE
///
/// @brief get the energy between waters and sidechain atoms
///
/// @detailed  get the lj repulsive and water-mediated H-bond interactions
///       between water and protein sidechain atoms
///
/// @param[in]   aa1      - in  - one sidechain amino acid
/// @param[in]   aav1     - in  - one sidechain amino acid variant
/// @param[in]   coord1   - in  - one sidechain amino acid coordinate
/// @param[in]   aa2      - in  - another sidechain amino acid
/// @param[in]   aav2     - in  - another sidechain amino acid variant
/// @param[in]   coord2   - in  - another sidechain amino acid coordinate
/// @param[in]   res1     - in  - one sidechain residue id
/// @param[in]   res2     - in  - another sidechain residue id
/// @param[out]   h2oE     - out - the lj repulsive energy
/// @param[out]   h2ohbE   - out - the water-mediated H-bond energy
///
/// @global_read
/// variables from "param.h"
///     MAX_ATOM     -  max number of atoms per amino acid
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang 08/19/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_sc_sc_h2oE(
	int const & aa1,
	int const & aav1,
	FArray2Da_float coord1,
	int const & aa2,
	int const & aav2,
	FArray2Da_float coord2,
	int const & res1,
	int const & res2,
	float & h2oE,
	float & h2ohbE
)
{
	using namespace param;

	coord1.dimension( 3, MAX_ATOM() );
	coord2.dimension( 3, MAX_ATOM() );

//bk compute all atom pair energies between sidechains that involve
//bk at least water molecule


// local
	float energy11,energy12,energy21,energy22;

	h2oE   = 0.0;
	h2ohbE = 0.0;

	if ( param_aa::is_DNA( aa1 ) && param_aa::is_DNA( aa2 ) ) return;

	get_sc_sc_h2oE_1way(aa1,aav1,coord1,aa2,aav2,coord2,res1,res2,energy11,
											energy12);
	get_sc_sc_h2oE_1way(aa2,aav2,coord2,aa1,aav1,coord1,res2,res1,energy21,
											energy22);
	h2oE = energy11 + energy21;
	h2ohbE = energy12 + energy22;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_sc_h2oE_1way
///
/// @brief get the energy of interactions from water to sidechain atoms
///
/// @detailed  get the lj repulsive and water-mediated H-bond interactions
///       from water to protein sidechain atoms
///
/// @param[in]   aa1      - in  - one sidechain amino acid
/// @param[in]   aav1     - in  - one sidechain amino acid variant
/// @param[in]   coord1   - in  - one sidechain amino acid coordinate
/// @param[in]   aa2      - in  - another sidechain amino acid
/// @param[in]   aav2     - in  - another sidechain amino acid variant
/// @param[in]   coord2   - in  - another sidechain amino acid coordinate
/// @param[in]   res1     - in  - one sidechain residue id
/// @param[in]   res2     - in  - another sidechain residue id
/// @param[out]   h2oE     - out - the lj repulsive energy
/// @param[out]   h2ohbE   - out - the water-mediated H-bond energy
///
/// @global_read
/// variables from "param.h"
///     MAX_ATOM     -  max number of atoms per amino acid
///
/// @global_write
///
/// @remarks only lj repulsive interactions between water and protein atoms
///       no lj repulsive interactions between waters
///
/// @references
///
/// @authors Lin Jiang 09/20/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_sc_sc_h2oE_1way(
	int const aa1,
	int const aav1,
	FArray2DB_float const & coord1,
	int const aa2,
	int const aav2,
	FArray2DB_float const & coord2,
	int const res1,
	int const res2,
	float & h2oE,
	float & h2ohbE
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace param_aa;
	using namespace water;


	h2oE = 0.0;
	h2ohbE = 0.0;

	if( is_DNA( aa1 ) && is_DNA( aa2 ) ) return;

	int atm2a, atm2a_type;
	float ang_tmp;
	int const atm1e = natoms( aa1, aav1 ), atm2e = natoms( aa2, aav2 );
	for ( int n = 1, ne = nh2o( aa1, aav1 ); n <= ne; ++n ) {
		int atm1 = h2opos(n,aa1,aav1);
		int atm1_type = fullatom_type(atm1,aa1,aav1);
		int atm0 = heavy_atm_on_h2o(n,aa1,aav1);
		int atm0_type = fullatom_type(atm0,aa1,aav1);
		int atm0a = template_atm_on_h2o(n,aa1,aav1);
		int atm0a_type = fullatom_type(atm0a,aa1,aav1);
		for ( int atm2 = 5; atm2 <= atm2e; ++atm2 ) {
			int atm2_type = fullatom_type( atm2, aa2, aav2 );
			fast_pairenergy_h2o(atm1_type,coord1(1,atm1),atm2_type,coord2(1,atm2), h2oE);
//lin  water_mediate hydrogen bonding energy
			find_h2ohb_template_atom(atm1_type,coord1(1,atm1),atm2,aa2,aav2,atm2_type,
			 coord2,atm2a,atm2a_type,ang_tmp);
			h2o_hbenergy( atm1_type, coord1(1,atm1), explicit_water_neighbors(n,res1),
			 atm2_type, coord2(1,atm2), atm0_type, coord1(1,atm0), atm2a_type,
			 coord2(1,atm2a), atm0a_type, coord1(1,atm0a), h2ohbE, use_water_bonus );
		}
	}

//lin  water_mediated H-bond energy formed by native water
//lin  Be carreful! the atm1 is not water atom but protein atom from aav1
	if ( use_hetero_h2o ) {
		for ( int atm1 = 5; atm1 <= atm1e; ++atm1 ) {
			int atm1_type = fullatom_type( atm1, aa1, aav1 );
			for ( int atm2 = 5; atm2 <= atm2e; ++atm2 ) {
				int atm2_type = fullatom_type( atm2, aa2, aav2 );
				fast_pairenergy_hetero_h2ohb( atm1, aa1, aav1, atm1_type, coord1, atm2, aa2,
				 aav2, atm2_type, coord2, N_h2oatom, h2o_position, h2ohbE );
			}
		}
	}

	if ( use_hbond_potential ) {
		// recalculate!
//		float const old_h2ohbE( h2ohbE );
		h2ohbE = get_h2oE_hbond_potential(
							 aa1, aav1, res1, aa2, aav2, res2, coord1, coord2,
							 false/*count_bb*/, true /*_sc*/);
	}
}


////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_atm_h2oE
///
/// @brief get the Hbond energy between a single atom and all waters
///
/// @detailed
///
///
/// @param[in]   seqpos   - in  - residue number
/// @param[in]   atomno   - in  - atom number within this residue
/// @param[out]  total_h2ohbE - out - returns sum over all Hbonds to water
///
/// @global_read
/// variables from "param.h"
///     MAX_ATOM     -  max number of atoms per amino acid
///
/// @global_write
///
/// @remarks only lj repulsive interactions between water and protein atoms
///       no lj repulsive interactions between waters
///
/// @references
///
/// @authors Phil Bradley, John Karanicolas
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
get_sc_atm_h2oE(
	int const seqpos,
	int const atomno
)
{
	using namespace misc;
	using namespace aaproperties_pack;
	using namespace template_pack;
	using namespace param;
	using namespace water;

	int aa ( res(seqpos) );
	int aav ( res_variant(seqpos) );

	float const water_bonus( -1.5 );

	float total_h2ohbE( 0.0 );

	for ( int n = 1, ne = nh2o(aa,aav); n <= ne; ++n ) {
		if ( ( atomno == heavy_atm_on_h2o(n,aa,aav) ) ||
		 ( atomno == hyd_atm_on_h2o(n,aa,aav) ) ) {
			return water_bonus;
		}
	}

	for ( int i = 1; i <= total_residue; ++i ) {
		//jk Allow an Hbond to a water owned by another atom
		//jk in this residue (not uncommon for Arg especially)
		if ( ( i == seqpos ) || ( neighborlist(seqpos,i) ) ) {
			float h2ohbE( 0.0 );
			get_sc_atm_h2oE_1way( res(i), res_variant(i), full_coord(1,1,i),
			 aa, aav, atomno, full_coord(1,1,seqpos), i, h2ohbE );
			total_h2ohbE += h2ohbE;
		}
	}

	return total_h2ohbE;
}

///////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_atm_h2oE_1way
///
/// @brief get the Hbond energy between a single atom and all waters on a
///            selected residue
/// @detailed (called by get_sc_atm_h2oE)
///
///
/// @param[in]   aa1      - in  - one sidechain amino acid
/// @param[in]   aav1     - in  - one sidechain amino acid variant
/// @param[in]   coord1   - in  - one sidechain amino acid coordinate
/// @param[in]   aa2      - in  - another sidechain amino acid
/// @param[in]   aav2     - in  - another sidechain amino acid variant
/// @param[in]   atm2     - in  - atom of choice in residue 2
/// @param[in]   coord2   - in  - another sidechain amino acid coordinate
/// @param[in]   res1     - in  - one sidechain residue id
/// @param[out]   h2ohbE   - out - the water-mediated H-bond energy
///
///
/// @global_read
/// variables from "param.h"
///     MAX_ATOM     -  max number of atoms per amino acid
///
/// @global_write
///
/// @remarks only lj repulsive interactions between water and protein atoms
///       no lj repulsive interactions between waters
///
/// @references
///
/// @authors Phil Bradley, John Karanicolas
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_sc_atm_h2oE_1way(
	int const aa1,
	int const aav1,
	FArray2Da_float coord1,
	int const aa2,
	int const aav2,
	int const atm2,
	FArray2Da_float coord2,
	int const res1,
	float & h2ohbE
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace param_aa;
	using namespace water;

	h2ohbE = 0.0;

	if( is_DNA( aa1 ) && is_DNA( aa2 ) ) return;

	coord1.dimension( 3, MAX_ATOM() );
	coord2.dimension( 3, MAX_ATOM() );


	//jk if called from decoystats, atm2 is either an accepting
	//jk heavy atom or a donating hydrogen. in the latter case,
	//jk we can only compute h2o_hbenergy using the heavy atom,
	//jk NOT the hydrogen.
	int orig_atm2 = atm2;
	int new_atm2 = atm2;
	int atype = fullatom_type(atm2,aa2,1);
	bool isHyd = false;
	if ( ( atype == 25 ) || ( atype == 22 ) ) {
		new_atm2 = atom_base(atm2,aa2,1);
		isHyd = true;
	}

	int atm2a, atm2a_type;
	float ang_tmp;
	for ( int n = 1, ne = nh2o(aa1,aav1); n <= ne; ++n ) {

		int atm1 = h2opos(n,aa1,aav1);
		int atm1_type = fullatom_type(atm1,aa1,aav1);
		int atm0 = heavy_atm_on_h2o(n,aa1,aav1);
		int atm0_type = fullatom_type(atm0,aa1,aav1);
		int atm0a = template_atm_on_h2o(n,aa1,aav1);
		int atm0a_type = fullatom_type(atm0a,aa1,aav1);
		int atm2_type = fullatom_type(new_atm2,aa2,aav2);

		//jk if isHyd is true, look for an Hbond to this water only
		//jk if the water is closer to the H than the heavy atom
		bool Hdist_test = true;
		if ( isHyd ) {
			float heavy_dist, hyd_dist;
			distance2_bk( coord2(1,new_atm2), coord1(1,atm1), heavy_dist );
			distance2_bk( coord2(1,orig_atm2), coord1(1,atm1), hyd_dist );
			if ( heavy_dist < hyd_dist ) {
				Hdist_test = false;
			}
		}

		if ( Hdist_test ) {

			find_h2ohb_template_atom(atm1_type,coord1(1,atm1),new_atm2,aa2,aav2,atm2_type,
															 coord2,atm2a,atm2a_type,ang_tmp);
			h2o_hbenergy(atm1_type,coord1(1,atm1),explicit_water_neighbors(n,res1),
									 atm2_type,coord2(1,new_atm2),atm0_type,coord1(1,atm0),atm2a_type,
									 coord2(1,atm2a),atm0a_type,coord1(1,atm0a),h2ohbE,use_water_bonus);

		}
	}

}


////////////////////////////////////////////////////////////////////////////////
/// @begin find_h2ohb_template_atom
///
/// @brief find template atom for water-mediated H-bond calculation
///
/// @detailed  find template atom in order to determine the angles of water-mediated
///       H-bonds.
///       Find out the base atom for water H binding to the polar atom (H-bond
///       acceptor or donor) with a good geometry.
///
///
/// @param[in]   type1   - in - fullatom type of water
/// @param[in]   coord1  - in - coordinate of this water
/// @param[in]   atm2    - in - polar atom (H-bond acceptor or donor)
/// @param[in]   aa2     - in - amino acid that the polar atom belong to
/// @param[in]   aav2    - in - amino acid variant
/// @param[in]   type2   - in - fullatom type of this polar atom
/// @param[in]   coord2  - in - coordinate of this polar atom
/// @param[out]   atm2a   - out - the base atom involving in the water-mediated H-bond of
///                         the water and atm2
/// @param[out]   type2a  - out - the fullatom type of the base atom
/// @param[out]   best_ang - out - the angle of water, polar atom and the base atom
///
/// @global_read
/// variables from "param.h"
///     MAX_ATOM         -  max number of atoms per amino acid
/// variables from "etable.h"
///     fa_donor, fa_acceptor
/// variables from "aaproperties_pack.h"
///     nh2o, h2opos, heavy_atm_on_h2o, fullatom_type,
///     nhydrogens_on_atm, hydrogens_on_atm,
/// variables from "water.h"
///     type_h2o
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang 09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
find_h2ohb_template_atom(
	int type1,
	FArray1Da_float coord1,
	int atm2,
	int aa2,
	int aav2,
	int type2,
	FArray2Da_float coord2,
	int & atm2a,
	int & type2a,
	float & best_ang
)
{
	using namespace aaproperties_pack;
	using namespace etable;
	using namespace param;
	using namespace water;

	best_ang = -1.0;
	atm2a = 1;
	type2a = 1;
	if ( type1 != type_h2o ) return;
	if ( !( fa_acceptor(type2) || fa_donor(type2) ) ) return;

	coord1.dimension( 3 );
	coord2.dimension( 3, MAX_ATOM() );

// local
	float ang;

//lin
//lin    if atm2 is water, find the heavy atom the water is connected with
//lin
	if ( type2 == type_h2o ) {
		int h2o1 = 0;
		for ( int n = 1, ne = nh2o(aa2,aav2); n <= ne; ++n ) {
			if ( atm2 == h2opos(n,aa2,aav2) ) h2o1 = n;
		}
//   if ( h2o1 == 0 ) {
//      std::cout << "Fail!" << SS( atm2 ) << SS( aa2 ) << SS( aav2 ) << std::endl;
//   }
		atm2a = heavy_atm_on_h2o(h2o1,aa2,aav2);
		type2a = fullatom_type(atm2a,aa2,aav2);
		angle_bk(coord2(1,atm2),coord2(1,atm2a),coord2(1,atm2),coord1(1),ang);
		numeric::conversions::to_degrees(ang);
		best_ang = ang;
//         if ( best_ang < wat_acc_ang_cutoff )
//          std::cout << "water angle" << SS( best_ang ) << std::endl;
		return;
	}

//lin if atm2 is both acceptor and donor, treat as acceptor, such as ser thr tyr
	if ( fa_acceptor(type2) ) {
		atm2a = atom_base(atm2,aa2,aav2);
		type2a = fullatom_type(atm2a,aa2,aav2);
		angle_bk(coord2(1,atm2),coord2(1,atm2a),coord2(1,atm2),coord1(1),ang);
		numeric::conversions::to_degrees(ang);
		best_ang = ang;
//         if ( best_ang < wat_acc_ang_cutoff )
//          std::cout << "acceptor angle" << SS( best_ang ) << std::endl;
	} else {
		for ( int i = 1, e = nhydrogens_on_atm(atm2,aa2,aav2); i <= e; ++i ) {
			int hatm0 = hydrogens_on_atm(i,atm2,aa2,aav2);
			angle_bk(coord2(1,hatm0),coord2(1,atm2),coord2(1,hatm0),coord1(1),ang);
			numeric::conversions::to_degrees(ang);

			if ( ang > best_ang ) {
				best_ang = ang;
				atm2a = hatm0;
				type2a = fullatom_type(atm2a,aa2,aav2);
			}
		}
//         if ( best_ang < wat_don_ang_cutoff )
//          std::cout << "donor angle" << SS( ang ) << std::endl;
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin h2o_hbenergy
///
/// @brief get water-mediated H-bond energy
///
/// @detailed
///   calculate the water-mediated H-bonds between atm1(water) and atm2
///
///   distance-dependent term  from statistics of 14 protein complexes
///   adding angle constraint to this calculation
///
///   the geometrical parameters of water-mediated H-bonds:
///
///                  W
///                .  .
///              . d1  . d2
///        N---H        .
///                      O===C
///
///    atom:     N - polar atom that water attached to (atm0),
///              H - the base atom help form water H-bond between
///                  polar atom and water(atom0a),
///              W - bridging water(atm1),
///              O - polar atom that water H-bond to(atm2),
///              C - the base atom help form water H-bond between
///                  polar atom and water(atm2a)
///    distance: d1  - distance between atm0 and water (NH->W),
///              d2  - distance between atm2 and water(CO->W)
///    angle:    thelta0(N--H--W)  -  water-donor angle
///              thelta1(H--W--O)  -  bridging water angle
///              thelta2(W--O--C)  -  water-acceptor angle
///
///   09/04/2003
///
///   consider angle
///   05/14/2003
///
///   use statistical energy score from 14 protein complexes
///   the effective distance range is (2.6-3.6)
///   this energy score is more explicit and accurate than
///   the bonus score. The energy array is in the data "h2o_hb"
///   04/09/2003
///
///   take out the angular dependence, because
///   the angular dependence is not found in the statistics.
///   the favorable distance range is (2.6-3.5)
///   03/17/2003
///
///   simple water_mediated hydrogen bonding energy term
///   give a bonus of W within the range:
///      1. distance dependence
///           favorable range   2.95 (2.8-3.1)
///      2. angular dependence
///           favorable range   108.25 (100-120)
///   02/25/2003
///
///
/// @param[in]   type1   - in - fullatom type of atom1,bridging water
/// @param[in]   coord1  - in - coordinate of atom1
/// @param[in]   type2   - in - fullatom type of atom2,polar atom that water H-bond to
/// @param[in]   coord2  - in - coordinate of atom2
/// @param[in]   type0   - in - fullatom type of atom0,polar atom that water attached to
/// @param[in]   coord0  - in - coordinate of atom0
/// @param[in]   type2a  - in - fullatom type of atom2a,the base atom for atom2-atom1
/// @param[in]   coord2a - in - coordinate of atom2a
/// @param[in]   type0a  - in - fullatom type of atom0a,the base atom for atom0-atom1
/// @param[in]   coord0a - in - coordinate of atom0a
/// @param  energy  - [in/out]? - the accumulative energy
/// @param[in]   bonus   - in - true if simple bonus function is used
///
/// @global_read
/// variables from "param_pack.h" : pack_wts.Wh2o_hb()
/// variables from "etable.h"
///     fa_acceptor, fa_donor, fa_hbondH
/// variables from "water.h"
///     type_h2o - fullatom type of water
///     angle cutoff: wat_don_ang_lowcut, wat_acc_ang_lowcut,wat_acc_ang_highcut,
///     water_ang_lowcut, water_ang_highcut
///     distace cutoff: h2ohb_high_limit,h2ohb_low_limit
///     distance-dependent score: h2o_hb,h2ohb_bins_per_A,
///
/// @global_write none.
///
/// @remarks  distance for calculation is d2 (distance between atm2 and water).
///
/// @references
///
/// @authors Lin Jiang 09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
h2o_hbenergy(
	int type1, // atom type of bridging water
	FArray1Da_float coord1,
	int nb1, // neighbor number of water
	int type2, // the other atom that water contacts with
	FArray1Da_float coord2,
	int type0, // the atom that water is attached to
	FArray1Da_float coord0,
	int type2a,
	FArray1Da_float coord2a,
	int type0a,
	FArray1Da_float coord0a,
	float & energy,
	bool & bonus
)
{
	using namespace etable;
	using namespace param_pack;
	using namespace water;

	if (pack_wts.Wh2o_hb() == 0.) return;

	if ( type1 != type_h2o ) return; // water
	// PBHACK
	if ( type2 == type_h2o ) return; // water

	if ( type2 == type_h2o || type0 == type_h2o ) return; // No h2o-h2o hbonds

	if ( !( fa_acceptor(type2) || fa_donor(type2) ) ||
	 !( fa_acceptor(type0) || fa_donor(type0) ) ) return;

	coord1.dimension( 3 );
	coord2.dimension( 3 );
	coord0.dimension( 3 );
	coord2a.dimension( 3 );
	coord0a.dimension( 3 );

//lin   hydrogen bond energy between two waters
//lin   or 1 water and another atom type

//     local
	int disbin1,disbin2;
	float d12,d22; // geometry of water_mediated hydrogen bond
//      float h2o_ang1;
	float d,d_bin,frac;
	float h2ohb1,h2ohb2;
	float thelta0,thelta1,thelta2;
	float weight;
	bool const angle_output = { false };

//     bonus = true

	if ( h2ohb_angle_check ) {
// the angle thelta2 for atom 2
		if ( fa_hbondH(type2a) ) {
			angle_bk(coord2a,coord2,coord2a,coord1,thelta2);
			numeric::conversions::to_degrees(thelta2);
			if ( thelta2 < wat_don_ang_lowcut ) return;
		} else {
			angle_bk(coord2,coord2a,coord2,coord1,thelta2);
			numeric::conversions::to_degrees(thelta2);
			if ( thelta2 < wat_acc_ang_lowcut || thelta2 > wat_acc_ang_highcut ) return;
		}

// the angle thelta0 for atom 0
		if ( fa_hbondH(type0a) ) {
			angle_bk(coord0a,coord0,coord0a,coord1,thelta0);
			numeric::conversions::to_degrees(thelta0);
			if ( thelta0 < wat_don_ang_lowcut ) return;
		} else {
			angle_bk(coord0,coord0a,coord0,coord1,thelta0);
			numeric::conversions::to_degrees(thelta0);
			if ( thelta0 < wat_acc_ang_lowcut || thelta0 > wat_acc_ang_highcut ) return;
		}

//     the angle thelta1 for atom 1 (water)
		if ( fa_hbondH(type2a) ) {
			if ( fa_hbondH(type0a) ) {
				angle_bk(coord1,coord2a,coord1,coord0a,thelta1);
				numeric::conversions::to_degrees(thelta1);
			} else {
				angle_bk(coord1,coord2a,coord1,coord0,thelta1);
				numeric::conversions::to_degrees(thelta1);
			}
		} else {
			if ( fa_hbondH(type0a) ) {
				angle_bk(coord1,coord2,coord1,coord0a,thelta1);
				numeric::conversions::to_degrees(thelta1);
			} else {
				angle_bk(coord1,coord2,coord1,coord0,thelta1);
				numeric::conversions::to_degrees(thelta1);
			}
		}

		if ( thelta1 < water_ang_lowcut || thelta1 > water_ang_highcut ) return;
	}

//lin   use environmental dependent weight of h2o_hb
	if ( use_h2o_hb_env_dep_lin ) {
		get_buried_h2ohb_weight(nb1,weight);
	} else {
		weight = 1.0;
	}

//      std::cout << "h2o_hb energy calculation " << bonus << std::endl;
	if ( bonus ) {
		distance2_bk(coord0,coord1,d12);
		distance2_bk(coord2,coord1,d22);
//         angle_bk(coord1,coord0,coord1,coord2,h2o_ang1);
//         numeric::conversions::to_degrees(h2o_ang1); // convert to degree
//         std::cout << "distance2" << SS( d12 ) << SS( d22 ) << std::endl;
		if ( angle_output ) {
			if ( d22 < 12.25 && d22 > 6.76 ) {
				std::cout << "angle_check: d2" << SS( d22 ) <<
				 "protein angle thelta2" << SS( fa_hbondH(type2a) ) << SS( thelta2 ) <<
				 std::endl;
			}
			if ( d12 < 12.25 && d12 > 6.76 ) {
				std::cout << "angle_check: d2" << SS( d12 ) <<
				 "protein angle thelta0" << SS( fa_hbondH(type0a) ) << SS( thelta0 ) <<
				 std::endl;
			}
		}

//lin  distance range: from 2.6 to 3.5A
		if ( (d22 < 12.25 && d22 > 6.76) && (d12 < 12.25 && d12 > 6.76) ) {
			energy += pack_wts.Wh2o_hb()*weight;
			if ( angle_output ) {
				std::cout << "angle_check:water angle thelta1" << SS( thelta1 ) << std::endl;
			}
		}

		return;
	}

	distance_bk(coord2,coord1,d);

	if ( d >= h2ohb_high_limit || d <= h2ohb_low_limit ) return;
//ctsa
//ctsa  get bins and interpolation fraction
//ctsa
//lin  here distance bin is NOT A**2
	d_bin = h2ohb_bins_per_A*(d-h2ohb_low_limit);
	disbin1 = static_cast< int >(d_bin)+1;
	disbin2 = disbin1+1;
	frac = d_bin-float(disbin1-1);

//ctsa
//ctsa   tables have been hacked so that if disbin2 = lastbin, all values = 0.
//ctsa

	h2ohb1 = h2o_hb(disbin1);
	h2ohb2 = h2o_hb(disbin2);
	energy += weight*pack_wts.Wh2o_hb()*(h2ohb1 + frac*(h2ohb2-h2ohb1));
//      std::cout << "h2o_score is " << h2ohb1 + frac*(h2ohb2-h2ohb1) << std::endl;

}

///////////////////////////////////////////////////////////////////////////////
void
compute_atom_h2o_hb_deriv(
													int const atomno,
													int const seqpos,
													float const weight,
													numeric::xyzVector_float & F1,
													numeric::xyzVector_float & F2
													)
{
	for ( int k=1; k<=3; ++k ) {
		F1(k) += weight * water::water_hbond_deriv(k,1,atomno,seqpos);
		F2(k) += weight * water::water_hbond_deriv(k,2,atomno,seqpos);
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin fast_pairenergy_h2o
///
/// @brief energy between two waters or one water and another atom types
///
/// @detailed  LJ repulsive energy between two waters or one water and another atom types
///
/// @param[in]   type1  - in     - fullatom type of atom 1
/// @param[in]   coord1 - in     - coordinate of atom 1
/// @param[in]   type2  - in     - fullatom type of atom 2
/// @param[in]   coord2 - in     - coordinate of atom 2
/// @param  energy - [in/out]? - the accumulative water energy
///
/// @global_read
/// variables from "pdbstatistics_pack.h"
///     safe_max_dis2  - prevent 'trickling' over the disbin boundary
///     ljrep          - lennard-jones repulsive energy array
///     fa_bins_per_A2 - number of disbins in etable per A**2
///
/// @global_write none
///
/// @remarks  energy = energy+newenergy
///
/// @references
///
/// @authors  Lin Jiang 08/20/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fast_pairenergy_h2o(
	int type1,
	FArray1Da_float coord1,
	int type2,
	FArray1Da_float coord2,
	float & energy
)
{
	using namespace pdbstatistics_pack;
	using namespace water;

	if ( type1 != type_h2o && type2 != type_h2o ) return; // not waters

//lin  calculate energy between waters
//      if ( type1 == type_h2o && type2 == type_h2o ) return; // no energy between waters

	coord1.dimension( 3 );
	coord2.dimension( 3 );

//bk lj repulsive energy between two waters or 1 water and another atom type

	float const d2 = distance_squared( coord1, coord2 );

	if ( d2 >= safe_max_dis2 || d2 == 0 ) return;

//bk   calculate repulsive energy
//ctsa
//ctsa  get bins and interpolation fraction
//ctsa
	float const d2_bin = fa_bins_per_A2 * d2;
	int const disbin1 = static_cast< int >( d2_bin ) + 1;
//	int const disbin2 = disbin1 + 1;
	float const frac = d2_bin - ( disbin1 - 1 );

//ctsa
//ctsa   tables have been hacked so that if disbin2 = lastbin, all values = 0.
//ctsa

	int const l = pCurrentEtable->ljrep.index(disbin1,type2,type1);
	float const repulse1 = pCurrentEtable->ljrep[ l   ]; // ljrep(disbin1,type2,type1)
	float const repulse2 = pCurrentEtable->ljrep[ l+1 ]; // ljrep(disbin2,type2,type1)
	energy += repulse1 + frac * ( repulse2 - repulse1 );

//bk   calculate hbonding of water with other atom
//$$$      if ( type1 == type_h2o ) {                              // water
//$$$         if ( fa_acceptor(type2) || fa_donor(type2) ) {
//$$$            if ( d2 < 12.25 && d2 > 6.25 ) energy -= 1.0;
//$$$         }
//$$$      } else {                                           // 2 is water
//$$$         if ( fa_acceptor(type1) || fa_donor(type1) ) {
//$$$            if ( d2 < 12.25 && d2 > 6.25 ) energy -= 1.0;
//$$$         }
//$$$      }

}

////////////////////////////////////////////////////////////////////////////////
/// @begin fast_pairenergy_hetero_h2ohb
///
/// @brief  native water energy between two atoms
///
/// @detailed   water-mediaed H-bond energy bridged by native water
///
/// @param[in]   atm1   - in     - the atom 1
/// @param[in]   aa1    - in     - amino acid that atom1 in
/// @param[in]   aav1   - in     - the variant of amino acid that atom1 in
/// @param[in]   atm1_type - in  - fullatom type of atom 1
/// @param[in]   coord1 - in     - the coordinate of amino acid 1
/// @param[in]   atm2   - in     - the atom 2
/// @param[in]   aa2    - in     - amino acid that atom2 in
/// @param[in]   aav2   - in     - the variant of amino acid that atom2 in
/// @param[in]   atm2_type - in  - fullatom type of atom 2
/// @param[in]   coord2 - in     - the coordinate of amino acid 2
/// @param[in]   N_h2oatm - in   - the native water number
/// @param[in]   coordw - in     - the native water coordinate array
/// @param  h2ohbE - [in/out]? - the accumulative water energy
///
/// @global_read
/// variables from "etable.h"
///     fa_acceptor, fa_donor
/// variables from "param.h"
///     MAX_ATOM         -  max number of atoms per amino acid
/// variables from "water.h"
///     water_repulsive_cutoff
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang 09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fast_pairenergy_hetero_h2ohb(
	int atm1,
	int aa1,
	int aav1,
	int atm1_type,
	FArray2Da_float coord1,
	int atm2,
	int aa2,
	int aav2,
	int atm2_type,
	FArray2Da_float coord2,
	int N_h2oatm, // # of water in the list
	FArray2Da_float coordw, // postion of water in the water list
	float & h2ohbE // energy of water-mediated hydrogen bond
)
{
	using namespace etable;
	using namespace param;
	using namespace water;

	if ( !( fa_acceptor(atm1_type) || fa_donor(atm1_type) ) ||
	 !( fa_acceptor(atm2_type) || fa_donor(atm2_type) ) ) return;

	coord1.dimension( 3, MAX_ATOM() );
	coord2.dimension( 3, MAX_ATOM() );
	coordw.dimension( 3, MAX_H2OATOM );

//lin   water-mediated hydrogen bonding energies between atom1 and atom2
//lin   involving hetero close waters to these atoms
//lin

//     local
	int atm1a,atm2a,atm1a_type,atm2a_type;
	float d1,d2,ang_tmp1,ang_tmp2; // distance between water and atom1 or atom2
	float d_tmp;

	bool const dis_output = { false };
	float const h2o_dis_cutoff = { 6.0 };

	for ( int n1 = 1; n1 <= N_h2oatm; ++n1 ) {
		d1 = 0;
		d2 = 0;
		distance_bk(coord1(1,atm1),coordw(1,n1),d1);
		distance_bk(coord2(1,atm2),coordw(1,n1),d2);
//
		if ( d1 <= water_repulsive_cutoff && d2 <= water_repulsive_cutoff ) {

//lin  water_mediated hydrogen bonding energy for native water
//lin  pick the longer distance to calculate the h2o_hb energy
			find_h2ohb_template_atom(type_h2o,coordw(1,n1),atm1,aa1,aav1,atm1_type,
			 coord1,atm1a,atm1a_type,ang_tmp1);
			find_h2ohb_template_atom(type_h2o,coordw(1,n1),atm2,aa2,aav2,atm2_type,
			 coord2,atm2a,atm2a_type,ang_tmp2);

			if ( dis_output ) {
				if ( d1 <= h2o_dis_cutoff ) {
					if ( fa_acceptor(atm1_type) ) {
						std::cout << "DIS_CHECK: h2o_acceptor_dis d1 is " << d1 <<
						 std::endl;
					} else {
						std::cout << "DIS_CHECK: h2o_donor_dis d1 is " << d1 << std::endl;
						distance_bk(coord1(1,atm1a),coordw(1,n1),d_tmp);
						std::cout << "DIS_CHECK: h2o_hydrogen_dis d1 is " << d_tmp <<
						 std::endl;
					}
				}
				if ( d2 <= h2o_dis_cutoff ) {
					if ( fa_acceptor(atm2_type) ) {
						std::cout << "DIS_CHECK: h2o_acceptor_dis d2 is " << d2 <<
						 std::endl;
					} else {
						std::cout << "DIS_CHECK: h2o_donor_dis d2 is " << d2 << std::endl;
						distance_bk(coord1(1,atm2a),coordw(1,n1),d_tmp);
						std::cout << "DIS_CHECK: h2o_hydrogen_dis d2 is " << d_tmp <<
						 std::endl;
					}
				}
			}

			if ( d1 < d2 ) {
				h2o_hbenergy(type_h2o,coordw(1,n1),hetero_water_neighbors(n1),atm2_type,
				 coord2(1,atm2),atm1_type,coord1(1,atm1),atm2a_type,coord2(1,atm2a),
				 atm1a_type,coord1(1,atm1a),h2ohbE,use_water_bonus);
			} else {
				h2o_hbenergy(type_h2o,coordw(1,n1),hetero_water_neighbors(n1),atm1_type,
				 coord1(1,atm1),atm2_type,coord2(1,atm2),atm1a_type,coord1(1,atm1a),
				 atm2a_type,coord2(1,atm2a),h2ohbE,use_water_bonus);
			}
		}
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin fast_pairenergy_attached_h2o
///
/// @brief water energies between atom1 and atom2
///
/// @detailed  the accumulative water lj repulsive and ater-medaited H-bond energy
///       including native water and water-rotamer
///
/// @param[in]   atom1  - in     - the atom 1
/// @param[in]   atom2  - in     - the atom 2
/// @param[in]   aa1    - in     - amino acid that atom1 in
/// @param[in]   aa2    - in     - amino acid that atom2 in
/// @param[in]   aav1   - in     - the variant of amino acid that atom1 in
/// @param[in]   aav2   - in     - the variant of amino acid that atom2 in
/// @param[in]   coord1 - in     - the coordinate of amino acid 1
/// @param[in]   coord2 - in     - the coordinate of amino acid 2
/// @param  h2oE   - [in/out]? - the accumulative water lj repulsive energy
/// @param  h2ohbE - [in/out]? - the accumulative water-medaited H-bond energy
///
/// @global_read
/// variables from "param.h"
///     MAX_ATOM           -  max number of atoms per amino acid
/// variables from "aaproperties_pack.h"
///     nh2o_on_atm        -  how many water are attached to each atom
///     fullatom_type      -  fullatom type
///     h2o_on_atm         -  what waters are connected to each atom
/// variables from "water.h"
///     use_water_bonus    -  true if water bonus function is used
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang 09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fast_pairenergy_attached_h2o(
	int atom1,
	int atom2,
	int aa1,
	int aa2,
	int aav1,
	int aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	float & h2oE,
	float & h2ohbE
)
{
	using namespace aaproperties_pack;
	using namespace param;
	using namespace param_aa;
	using namespace water;

	if( is_DNA( aa1 ) && is_DNA( aa2 ) ) return;
	assert( false );
	coord1.dimension( 3, MAX_ATOM() );
	coord2.dimension( 3, MAX_ATOM() );

//bk   energies involving waters attached to atom1 and atom2

// local
	int atom2a,type2a,atom0a,type0a,atom1a,type1a;
	float ang_tmp;

	int atom0 = atom1;
	int type0 = fullatom_type(atom1,aa1,aav1);
	for ( int n1 = 1, n1e = nh2o_on_atm(atom1,aa1,aav1); n1 <= n1e; ++n1 ) {
		int h2o1 = h2o_on_atm(n1,atom1,aa1,aav1);
		int type1 = fullatom_type(h2o1,aa1,aav1);
		int type2 = fullatom_type(atom2,aa2,aav2);
//      std::cout << "type0 " << type0 << " typeh2o " << type1 << " type2 " <<
//       type2 << std::endl;
		fast_pairenergy_h2o(type1,coord1(1,h2o1),type2,coord2(1,atom2),h2oE);
//lin  water_mediated hydrogen bonding energy
		find_h2ohb_template_atom(type1,coord1(1,h2o1),atom0,aa1,aav1,
		 type0,coord1,atom0a,type0a,ang_tmp);
//         std::cout << "h2o1-atm1-atm1a" << SS( ang_tmp ) << std::endl;
		find_h2ohb_template_atom(type1,coord1(1,h2o1),atom2,aa2,aav2,
		 type2,coord2,atom2a,type2a,ang_tmp);
//         std::cout << "h2o1-atm2-atm2a" << SS( ang_tmp ) << std::endl;
//         distance_bk(coord1(1,h2o1),coord2(1,atom2),d_tmp);
//         std::cout << "d " << SS( d_tmp ) << std::endl;
		h2o_hbenergy(type1,coord1(1,h2o1),10,type2,coord2(1,atom2),type0,
		 coord1(1,atom0),type2a,coord2(1,atom2a),type0a,coord1(1,atom0a),h2ohbE,
		 use_water_bonus);

		for ( int n2 = 1, n2e = nh2o_on_atm(atom2,aa2,aav2); n2 <= n2e; ++n2 ) {
			int h2o2 = h2o_on_atm(n2,atom2,aa2,aav2);
			type2 = fullatom_type(h2o2,aa2,aav2);
//        std::cout << "type0 " << type0 << " typeh2o " << type1 <<
//         " type2 " << type2 << std::endl;
			fast_pairenergy_h2o(type1,coord1(1,h2o1),type2,coord2(1,h2o2),h2oE);
//lin  water_mediated hydrogen bonding energy
			find_h2ohb_template_atom(type1,coord1(1,h2o1),h2o2,aa2,aav2,
			 type2,coord2,atom2a,type2a,ang_tmp);
//            std::cout << "h2o1-h2o2-h2o2a" << SS( ang_tmp ) << std::endl;
//            distance_bk(coord1(1,h2o1),coord2(1,h2o2),d_tmp);
//            std::cout << "d " << SS( d_tmp ) << std::endl;
			h2o_hbenergy(type1,coord1(1,h2o1),10,type2,coord2(1,h2o2),type0,
			 coord1(1,atom0),type2a,coord2(1,atom2a),type0a,coord1(1,atom0a),h2ohbE,
			 use_water_bonus);
		}
	}

	for ( int n2 = 1, n2e = nh2o_on_atm(atom2,aa2,aav2); n2 <= n2e; ++n2 ) {
		int h2o2 = h2o_on_atm(n2,atom2,aa2,aav2);
		int type2 = fullatom_type(h2o2,aa2,aav2);
		int type1 = fullatom_type(atom1,aa1,aav1);
//      std::cout << "type0 " << type1 << " typeh2o " << type2 << " type2 " <<
//      fullatom_type(atom2,aa2,aav2) << std::endl;
		fast_pairenergy_h2o(type1,coord1(1,atom1),type2,coord2(1,h2o2),h2oE);
//lin  water_mediated hydrogen bonding energy
		find_h2ohb_template_atom(type2,coord2(1,h2o2),atom2,aa2,aav2,
		 fullatom_type(atom2,aa2,aav2),coord2,atom2a,type2a,ang_tmp);
//         std::cout << "h2o2-atm2-atm2a" << SS( ang_tmp ) << std::endl;
		find_h2ohb_template_atom(type2,coord2(1,h2o2),atom1,aa1,aav1,
		 type1,coord1,atom1a,type1a,ang_tmp);
//       std::cout << "atm1-atm1a-h2o2" << SS( ang_tmp ) << SS( atom1 ) <<
//        SS( aa1 ) << SS( aav1 ) << SS( type1 ) << SS( atom1a ) <<
//        SS( type1a ) << std::endl;
//       distance_bk(coord2(1,h2o2),coord1(1,atom1),d_tmp);
//       std::cout << "d " << SS( d_tmp ) << std::endl;
		h2o_hbenergy(type2,coord2(1,h2o2),10,type1,coord1(1,atom1),
		 fullatom_type(atom2,aa2,aav2),coord2(1,atom2),type1a,coord1(1,atom1a),
		 type2a,coord2(1,atom2a),h2ohbE,use_water_bonus);
//     std::cout << "h2oE " << SS( h2oE ) << " h2ohbE " << SS( h2ohbE ) << std::endl;
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin fill_h2ototalE_arrays
///
/// @brief
///
/// @detailed
///       water-medaited H-bond energy
///
/// @param   aan - [in/out]? -
/// @param   aav - [in/out]? - aa variant
/// @param   xyz - [in/out]? -
/// @param   nres - [in/out]? -
/// @param   neighborlist - [in/out]? -
/// @param   neighbors - [in/out]? -
///
/// @global_read
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fill_h2ototalE_arrays(
	FArray1DB_int const & aan,
	FArray1DB_int const & aav, // aa variant
	FArray3DB_float const & xyz,
	int const nres,
	FArray2DB_bool const & neighborlist,
  hbonds::HBDerivType const deriv_type // = hbderiv_NONE
)
{
	using namespace param;

	if ( ! design::explicit_h2o &&
				! water::use_hetero_h2o &&
				! design::hydrate_dna ) return;

	assert( water_exists() );

	water::water_hbond_deriv_type = deriv_type;
  if (deriv_type != hbonds::hbderiv_NONE) {
		water::water_hbond_deriv = 0.0;
		assert( int(water::water_hbond_deriv.size4()) >= nres );
	}

	float h2o_E,h2o_hbE;
	for ( int res1 = 1; res1 <= nres; ++res1 ) {
		int aa1 = aan(res1);
		int aav1 = aav(res1);
		float const & xyz_111( xyz(1,1,res1) );
		for ( int res2 = res1+1; res2 <= nres; ++res2 ) {
			int aa2 = aan(res2);
			int aav2 = aav(res2);
			if ( neighborlist(res1,res2) ) {
				get_h2oE(aa1,aa2,aav1,aav2,xyz_111,xyz(1,1,res2),res1,
				 res2,h2o_E,h2o_hbE);
				fill_h2oE_array(res1,res2,h2o_E,h2o_hbE);
			}
		}
	}

  water::water_hbond_deriv_type = hbonds::hbderiv_NONE; // back to no derivatives

	return;
}
///////////////////////////////////////////////////////////////////////////////
bool
water_exists()
{
	return ( design::explicit_h2o ||
					 water::use_hetero_h2o ||
					 design::hydrate_dna );
}

////////////////////////////////////////////////////////////////////////////////
/// @begin fill_h2oE_array
///
/// @brief fill water energy array for scoring
///
/// @detailed  fill in the water energy array to record the lj repulsive and
///       water-medaited H-bond energy
///
/// @param[in]   res1    - in - residue 1
/// @param[in]   res2    - in - residue 2
/// @param[in]   energy1 - in - water lj repulsive energy between residue 1 and 2
/// @param[in]   energy2 - in - water-medaited H-bond energy between residue 1 and 2
///
/// @global_read
/// variables from "water.h"
///   use_h2o_hb_env_dep_lin, Wh2ohb_env_dep, Wh2o_score
/// variables from "template_pack.h"
///   hb_neighbors - CB neighbors for H-bond calculation
/// variables from "param_apck.h"
///   Who2_lj      - water lj repulsive weight
///
/// variables from "fullatom_energies.h"
///   These variables are accumulative.
///   h2oenergy    - lj repulsive energy array
///   h2ohbenergy  - water-medaited H-bond energy array
///   h2o_pair     - lj repulsive energy pair
///   h2o_hb_pair  - water-medaited H-bond energy pair
///
/// @remarks  environment dependent weight is used for water-mediated H-bond
///
/// @references
///
/// @authors Lin Jiang 09/19/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fill_h2oE_array(
	int res1,
	int res2,
	float energy1,
	float energy2
)
{
	using namespace fullatom_energies;
	using namespace param_pack;

//lin  the lj repulsive energy
	float temp = 0.5*pack_wts.Wh2o()*pack_wts.Wh2o_lj()*energy1;
	h2oenergy(res1) += temp;
	h2oenergy(res2) += temp;
	temp *= 2;
	h2o_pair(res1,res2) += temp;
	h2o_pair(res2,res1) += temp;

//lin  the water-mediated hydrogen bond energy
	temp = 0.5*pack_wts.Wh2o()*energy2;
	h2ohbenergy(res1) += temp;
	h2ohbenergy(res2) += temp;
	temp *= 2;
	h2o_hb_pair(res1,res2) += temp;
	h2o_hb_pair(res2,res1) += temp;

}


////////////////////////////////////////////////////////////////////////////////
/// @begin get_buried_h2ohb_weight
///
/// @brief get the environ weight based on neighbors number of water
///
/// @detailed
///    the environ weight is based on neighbors number of water
///    Only buried water is calculated, otherwise the zero weight is return
///
/// @param[in]   h2ohb          - in  -  neigbor number of the water
/// @param[out]   environ_weight - out -  the environment weight for calculating
///                                 water-mediated H-bond
///
/// @global_read
///  buried_h2oneighbors_cutoff  in "water.h"
///
/// @global_write None
///
/// @remarks
///
/// @references
///
/// @authors  Lin Jiang  09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_buried_h2ohb_weight(
	int h2o_nb,
	float & environ_weight
)
{
	using namespace water;

	if ( h2o_nb >= buried_h2oneighbors_cutoff ) {
		environ_weight = 1;
	} else {
		environ_weight = 0;
	}

}


//===============================================
// functions for setting the packer weights
// Lin Jiang 09/19/2003
//===============================================

////////////////////////////////////////////////////////////////////////////////
/// @begin set_weights_for_packer
///
/// @brief set packer weight when repacking
///
/// @detailed
///
/// @param[in]   mode         - in  -  the packer mode
///
/// @global_read  Wint_repack_only from "water.h"
///
/// @global_write none
///
/// @remarks More information about int weight see "analyze_interface_ddg.cc"
///
/// @references
///
/// @authors Lin Jiang  10/13/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_weights_for_packer()
{
//lin  set the weight for packer before calculate the energy in DDG mode
//lin  set weights to int weights if they should be used by the packer
//lin  as well (option Wint_repack_only set in command line)

	using namespace water;

	// jk  read weights from a file, if desired
	if ( weightfile::use_weightfile ) {
		ReadWeights( weightfile::weight_fname );
		return;
	}

	if ( Wint_repack_only ) {
		RetrieveWeightsToCurrent( PW_INTERFACE );
//lin  revise the dunbrack and lj repulsive for packer
		revise_Wdun_Wrep_to_packer();
	} else {
		save_pack_weights();
		RetrieveWeightsToCurrent( PW_SAVE_PACK );
	}

}


////////////////////////////////////////////////////////////////////////////////
/// @begin set_weights_for_score
///
/// @brief set packer weight when scoring
///
/// @detailed
///
/// @global_read  Wint_score_only from "water.h"
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang  10/13/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_weights_for_score()
{
//lin  set the weight for packer before calculate the energy in DDG mode
//tk   set weights to int weights if they should be used by the packer
//tk   as well (option Wint_score_only set in command line)

	using namespace water;

	// jk  read weights from a file, if desired
	if ( weightfile::use_weightfile ) {
		ReadWeights( weightfile::weight_fname );
		return;
	}

	if ( Wint_score_only ) {
		RetrieveWeightsToCurrent( PW_INTERFACE );
	} else {
		save_pack_weights();
		RetrieveWeightsToCurrent( PW_SAVE_PACK );
	}

}


////////////////////////////////////////////////////////////////////////////////
/// @begin revise_Wdun_Wrep_to_packer
///
/// @brief reset repulsive and dunbrack weight for repacking
///
/// @detailed
///
/// @param[in]   mode         - in  -  the packer mode
///
/// @global_read
/// variables in "param_pack.h'
///     pack_wts.Watr()     -  current lj atractive weight
///     pack_wts.Wh2o_hb()  -  current water-mediated H-bond weight
///
/// @global_write
/// variables in "param_pack.h'
///     pack_wts.Wh2o_lj()   -  current water lj repulsive weight
///     pack_wts.Wdun()      -  current dunbrack weight
///     pack_wts.Wrep()      -  current lj repulsive weight
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang  10/13/03
///
/// @last_modified
/// This should go away and be replaced by a call to the weights manager.
/////////////////////////////////////////////////////////////////////////////////
void
revise_Wdun_Wrep_to_packer()
{
	using namespace analyze_interface_ddg_ns;
	using namespace param_pack;
	using namespace water;
	using namespace design;

	pack_wts.set_Wdun(0.41);
	pack_wts.set_Wpair(0.36);
	pack_wts.set_Wrep(0.32);
	pack_wts.set_Wintra(0.32);

	if ( explicit_h2o || read_hetero_h2o ) pack_wts.set_Wh2o_lj(0.40);

}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_water_rotamer_for_packer
///
/// @brief set some flags for water rotamers when repacking
///
/// @detailed
///
/// @param[in]   mode         - in  -  the packer mode
///
/// @global_read  none
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang  10/13/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_water_rotamer_for_packer( std::string const & mode )
{
	using namespace water;
	using namespace design;

	if ( !explicit_h2o && !read_hetero_h2o ) return;

	set_use_W_h2o_hb_env_dep(true);

	set_use_simple_bonus_for_h2ohb(false);

	if ( mode == "optimizeH" ) {
		set_use_angle_check_for_h2ohb(true);
	} else {
		set_use_angle_check_for_h2ohb(true);
	}

}


////////////////////////////////////////////////////////////////////////////////
/// @begin set_water_rotamer_for_score
///
/// @brief set some flags for water romtaer when scoring
///
/// @detailed
///
/// @param[in]   mode         - in  -  the packer mode
///
/// @global_read  none
///
/// @global_write none
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang  10/13/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_water_rotamer_for_score()
{
	using namespace water;
	using namespace design;

	if ( !explicit_h2o && !read_hetero_h2o ) return;

	set_use_W_h2o_hb_env_dep(true);
	set_use_simple_bonus_for_h2ohb(false);

	if ( use_hetero_h2o ) {
		set_use_angle_check_for_h2ohb(true);
	} else {
		set_use_angle_check_for_h2ohb(true);
	}

}


//===============================================
// functions for setting the flags
// Lin Jiang 09/19/2003
//===============================================

////////////////////////////////////////////////////////////////////////////////
/// @begin set_use_W_int_repack
///
/// @brief
///
/// @detailed set the flag Wint_repack_only:
///      using int weight when repacking
///
/// @global_read
///
/// @global_write  Wint_repack_only in "water.h"
///
/// @remarks
///
/// @references
///
/// @authors  Lin Jiang 10/13/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_use_W_int_repack( bool truefalse )
{
	using namespace water;

	Wint_repack_only = truefalse;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_use_W_int_score
///
/// @brief
///
/// @detailed set the flag Wint_score_only:
///      using int weight when scoring
///
/// @global_read
///
/// @global_write  Wint_score_only in "water.h"
///
/// @remarks
///
/// @references
///
/// @authors  Lin Jiang 10/13/03
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_use_W_int_score( bool truefalse )
{
	using namespace water;

	Wint_score_only = truefalse;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_use_simple_bonus_for_h2ohb
///
/// @brief
/// set flag use_water_bonus determining whether to use simple bonus function
/// for water-mediated H-bond calculation.
///
/// @detailed
///
/// @param[out]   use_water_bonus - out -
///
/// @global_read
///
/// @global_write use_water_bonus in water.h
///
/// @remarks
///
/// @references
///
/// @authors  Lin Jiang 09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_use_simple_bonus_for_h2ohb( bool truefalse )
{
	using namespace water;

	use_water_bonus = truefalse;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_use_angle_check_for_h2ohb
///
/// @brief
/// set flag use_water_bonus determining whether to use angle constraints
/// for water-mediated H-bond calculation.
///
/// @detailed
///
/// @param[out]   h2ohb_angle_check - out -
///
/// @global_read
///
/// @global_write h2ohb_angle_check in water.h
///
/// @remarks
///
/// @references
///
/// @authors  Lin Jiang 09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_use_angle_check_for_h2ohb( bool truefalse )
{
	using namespace water;

	h2ohb_angle_check = truefalse;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_use_W_h2o_hb_env_dep
///
/// @brief
/// set flag use_h2o_hb_env_lin determining whether to use environment
/// dependent water-mediated hydrogen bonding
///
/// @detailed
///
/// @global_read
///
/// @global_write      use_h2o_hb_env_dep_lin in water.h
///
/// @remarks
///
/// @references
///
/// @authors  Lin Jiang 09/20/2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_use_W_h2o_hb_env_dep( bool truefalse )
{
	using namespace water;

	use_h2o_hb_env_dep_lin = truefalse;
}


