// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 17358 $
//  $Date: 2007-09-24 20:08:09 -0700 (Mon, 24 Sep 2007) $
//  $Author: harrison $

#include <iostream>

#include "param.h"
#include "param_aa.h"
#include "param_pack.h"
#include "packer_weights.h"
#include "pH_ns.h"
#include "weights_manager.h"
//KMa phospho_ser
#include "add_pser.h"

// ObjexxFCL Headers
#include <ObjexxFCL/formatted.io.hh>
#include <ObjexxFCL/string.functions.hh>

// C++ Headers
#include <cstdlib>
#include <fstream>
#include <string>

//jjh Typedef for pointer to the PackerWeights class
typedef PackerWeights *pPackerWeights;

//jjh Typedef for the map-based container and an iterator
typedef std::map< packerweights_id, PackerWeights > PackerWeightsMap;
typedef PackerWeightsMap::iterator PackerWeightsMap_Iter;

//jjh Instantiate the container
PackerWeightsMap WS_db;


//Utility Headers
#include <utility/basic_sys_util.hh>

namespace weightfile {
	bool use_weightfile = { false };
	std::string weight_fname;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin StoreCurrentWeights
///
/// @brief
///  Saves the current set of packer weights stored in pack_wts
///   (declared in param_pack.h). This also includes the
///   ligand weights.  The function takes as an argument a
///   packerweights_id, which is an enumeration defined in
///   weights_manager.h.  This id is used as a key to store the
///   object in a map.
///
/// @detailed
///
/// @global_read
///  namespaces param_pack in param_pack.h
///
///
/// @remarks
///
/// @refrences
///
/// @authors Jim Havranek
///
/// @last_modified 13 October 2004
////////////////////////////////////////////////////////////////////////////////
void
StoreCurrentWeights( packerweights_id const & ws_id )
{
	using namespace param_pack;

	//jjh First check to see if this id is present in the DB.
	//jjh If not, it probably indicates a problem.

	PackerWeightsMap_Iter p = WS_db.find( ws_id );
	if ( p != WS_db.end() ) {
		//jjh Whoops - this id is in use!
		std::cout << "ERROR in StoreCurrentWeights()!" << std::endl;
		std::cout << "Attempt to overwrite PackerWeights id " << ws_id << std::endl;
		std::cout << "ABORTING..." << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	//jjh insert into the map
	WS_db[ ws_id ] = pack_wts;
}


//////////////////////////////////////////////////////////////////////////////
/// @begin ReadWeights
///
/// @brief
///  Read weights from a file.
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified July 2005
////////////////////////////////////////////////////////////////////////////////
void
ReadWeights( std::string const & weightfile )
{
	using namespace param;
	using namespace param_aa;
	using namespace param_pack;

	// declare a PackerWeights object. note that all weights not present in the input file
	// will be set to the default values specified in the constructor
	PackerWeights ws;

	//	PackerWeightsMap_Iter p = WS_db.find( PW_FILE_INPUT );
	//	if ( p != WS_db.end() ) {
	//		// This id is already in use
	//		std::cout << "ERROR in StoreCurrentWeights()!" << std::endl;
	//		std::cout << "Attempt to overwrite PackerWeights id PW_FILE_INPUT" << std::endl;
	//		std::cout << "ABORTING..." << std::endl;
	//		std::exit( EXIT_FAILURE );
	//	}

	std::ifstream wdata( weightfile.c_str() );

	if ( !wdata ) {
	  std::cout << "Error! Could not open weight file: " <<
	    weightfile << std::endl;
	  std::exit( EXIT_FAILURE );
	}

	std::string line;
	while ( std::getline( wdata, line ) ) {

	  std::istringstream line_stream (line);
	  std::string id;
	  float inW;

	  line_stream >> id >> inW >> skip;

	  if ( id == "Watr" ) {
			ws.set_Watr( inW );
	  } else if ( id == "Wrep" ) {
			ws.set_Wrep( inW );
	  } else if ( id == "Wsol" ) {
	    ws.set_Wsol( inW );
	  } else if ( id == "Wdun" ) {
	    ws.set_Wdun( inW );
	  } else if ( id == "Wref" ) {
	    ws.set_Wref( inW );
	  } else if ( id == "Wone" ) {
	    ws.set_Wone( inW );
	  } else if ( id == "Wpair" ) {
	    ws.set_Wpair( inW );
	  } else if ( id == "Wplane_total" ) {
	    ws.set_Wplane_total( inW );
	  } else if ( id == "Wintra" ) {
	    ws.set_Wintra( inW );
	  } else if ( id == "Wh2o" ) {
	    ws.set_Wh2o( inW );
	  } else if ( id == "Wh2o_intra" ) {
	    ws.set_Wh2o_intra( inW );
	  } else if ( id == "Wh2o_lj" ) {
	    ws.set_Wh2o_lj( inW );
	  } else if ( id == "Wh2o_hb" ) {
	    ws.set_Wh2o_hb( inW );
	  } else if ( id == "Whbond_bb" ) {
	    ws.set_Whbond_bb( inW );
	  } else if ( id == "Whbond_sc" ) {
	    ws.set_Whbond_sc( inW );
	  } else if ( id == "Whbond_bb_sc" ) {
	    ws.set_Whbond_bb_sc( inW );
	  } else if ( id == "Wgb_elec" ) {
	    ws.set_Wgb_elec( inW );
	  } else if ( id == "Wdna_bs" ) {
	    ws.set_Wdna_bs( inW );
	  } else if ( id == "Wdna_bp" ) {
	    ws.set_Wdna_bp( inW );
	  } else if ( id == "Wlig_atr" ) {
	    ws.set_Wlig_atr( inW );
	  } else if ( id == "Wlig_sol" ) {
	    ws.set_Wlig_sol( inW );
	  } else if ( id == "Wlig_cou" ) {
	    ws.set_Wlig_cou( inW );
	  } else if ( id == "Wlig_rep" ) {
	    ws.set_Wlig_rep( inW );
	  } else if ( id == "Wlig_hb" ) {
	    ws.set_Wlig_hb( inW );
	  } else if ( id == "Wlig_h2o" ) {
	    ws.set_Wlig_h2o( inW );
	  } else if ( id == "Wlig_vir" ) {
	    ws.set_Wlig_vir( inW );

	    // jk Reference weights by aa name
	  } else if ( id == "Waa_ALA" ) {
			ws.set_Waa( aa_ala, inW);
	  } else if ( id == "Waa_CYS" ) {
			ws.set_Waa( aa_cys, inW);
	  } else if ( id == "Waa_ASP" ) {
			ws.set_Waa( aa_asp, inW);
	  } else if ( id == "Waa_GLU" ) {
			ws.set_Waa( aa_glu, inW);
	  } else if ( id == "Waa_PHE" ) {
			ws.set_Waa( aa_phe, inW);
	  } else if ( id == "Waa_GLY" ) {
			ws.set_Waa( aa_gly, inW);
	  } else if ( id == "Waa_HIS" ) {
			ws.set_Waa( aa_his, inW);
	  } else if ( id == "Waa_ILE" ) {
			ws.set_Waa( aa_ile, inW);
	  } else if ( id == "Waa_LYS" ) {
			ws.set_Waa( aa_lys, inW);
	  } else if ( id == "Waa_LEU" ) {
			ws.set_Waa( aa_leu, inW);
	  } else if ( id == "Waa_MET" ) {
			ws.set_Waa( aa_met, inW);
	  } else if ( id == "Waa_ASN" ) {
			ws.set_Waa( aa_asn, inW);
	  } else if ( id == "Waa_PRO" ) {
			ws.set_Waa( aa_pro, inW);
	  } else if ( id == "Waa_GLN" ) {
			ws.set_Waa( aa_gln, inW);
	  } else if ( id == "Waa_ARG" ) {
			ws.set_Waa( aa_arg, inW);
	  } else if ( id == "Waa_SER" ) {
			ws.set_Waa( aa_ser, inW);
	  } else if ( id == "Waa_THR" ) {
			ws.set_Waa( aa_thr, inW);
	  } else if ( id == "Waa_VAL" ) {
			ws.set_Waa( aa_val, inW);
	  } else if ( id == "Waa_TRP" ) {
			ws.set_Waa( aa_trp, inW);
	  } else if ( id == "Waa_TYR" ) {
			ws.set_Waa( aa_tyr, inW);

	    // jk Reference weights by aa number
	  } else if ( id == "Waa_1" ) {
			ws.set_Waa( aa_ala, inW);
 	  } else if ( id == "Waa_2" ) {
	    ws.set_Waa( aa_cys, inW);
	  } else if ( id == "Waa_3" ) {
	    ws.set_Waa( aa_asp, inW);
	  } else if ( id == "Waa_4" ) {
	    ws.set_Waa( aa_glu, inW);
	  } else if ( id == "Waa_5" ) {
	    ws.set_Waa( aa_phe, inW);
	  } else if ( id == "Waa_6" ) {
	    ws.set_Waa( aa_gly, inW);
	  } else if ( id == "Waa_7" ) {
	    ws.set_Waa( aa_his, inW);
	  } else if ( id == "Waa_8" ) {
	    ws.set_Waa( aa_ile, inW);
	  } else if ( id == "Waa_9" ) {
	    ws.set_Waa( aa_lys, inW);
	  } else if ( id == "Waa_10" ) {
	    ws.set_Waa( aa_leu, inW);
	  } else if ( id == "Waa_11" ) {
	    ws.set_Waa( aa_met, inW);
	  } else if ( id == "Waa_12" ) {
	    ws.set_Waa( aa_asn, inW);
	  } else if ( id == "Waa_13" ) {
	    ws.set_Waa( aa_pro, inW);
	  } else if ( id == "Waa_14" ) {
	    ws.set_Waa( aa_gln, inW);
	  } else if ( id == "Waa_15" ) {
	    ws.set_Waa( aa_arg, inW);
	  } else if ( id == "Waa_16" ) {
	    ws.set_Waa( aa_ser, inW);
	  } else if ( id == "Waa_17" ) {
	    ws.set_Waa( aa_thr, inW);
	  } else if ( id == "Waa_18" ) {
	    ws.set_Waa( aa_val, inW);
	  } else if ( id == "Waa_19" ) {
	    ws.set_Waa( aa_trp, inW);
	  } else if ( id == "Waa_20" ) {
	    ws.set_Waa( aa_tyr, inW);

	  } else {
	    std::cout << "Error! Unrecognized weight: " << id << std::endl;
	    std::exit( EXIT_FAILURE );
	  }
	}

	wdata.close();

	//jk insert into the map
	WS_db[ PW_FILE_INPUT ] = ws;

	// jk make these weights active
	RetrieveWeightsToCurrent(PW_FILE_INPUT);

}


//////////////////////////////////////////////////////////////////////////////
/// @begin RetrieveWeights
///
/// @brief
///  Recall a PackerWeights object by id
///  The id must be one of the enumerated options in weights_manager.h.
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors Jim Havranek
///
/// @last_modified JSS 30 Nov 06
////////////////////////////////////////////////////////////////////////////////
PackerWeights &
RetrieveWeights( packerweights_id const & ws_id )
{

	//jjh First check to see if this id is  in use.
	//jjh If not, it probably indicates a problem.

	PackerWeightsMap_Iter p = WS_db.find( ws_id );
	if ( p == WS_db.end() ) {
		//jjh Whoops - this id doesn't exist
		std::cout << "ERROR in RetrieveWeights()!" << std::endl;
		std::cout << "Failed to retrieve PackerWeights id " << ws_id << std::endl;
		std::cout << "Not in Weight Set database!!!" << std::endl;
		std::cout << "ABORTING..." << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	return p->second;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin SetCurrentWeights
///
/// @brief
///  Set the global weights pack_wts (declared in param_pack.h) to the
///  weights stored in the PackerWeights database by id
///  The id must be one of the enumerated options in weights_manager.h.
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors Jack Snoeyink
///
/// @last_modified 30 Nov 2006
////////////////////////////////////////////////////////////////////////////////
void
RetrieveWeightsToCurrent( packerweights_id const & ws_id )
{
	using namespace param;
	using namespace param_pack;

	pack_wts = RetrieveWeights(ws_id);  // copy weights to global
}




//////////////////////////////////////////////////////////////////////////////
/// @begin InitializePackerWeightsDB
///
/// @brief
///  Defined all the standard packer weights sets and inserts
///  them into a map for later retrieval by id.
///
/// @detailed
///
/// @global_read
///  namespaces param_aa in param_aa.h
///
///
/// @remarks
///
/// @refrences
///
/// @authors Jim Havranek
///
/// @last_modified 13 October 2004
////////////////////////////////////////////////////////////////////////////////
void
InitializePackerWeightsDB()
{
	using namespace param_aa;

	static bool init = false;

	if ( init ) {
		return;
	} else {
		init = true;
	}

	//jjh The purpose of this function is to store commonly used
	//jjh fullatom/packer weight sets for easy recall

	//jjh First, fill with the standard packer weights


	//////////////BEGIN STANDARD WEIGHTS//////////////////
	{
		PackerWeights ws; // initialized to standard weights in packer_weights.cc
		WS_db[ PW_STANDARD] = ws;
	}
	//////////////DONE  STANDARD  WEIGHTS//////////////////

	//gc Monomer protein ddG weights
	//////////////BEGIN PW_DDG_MONOMER WEIGHTS//////////////////
	{
		PackerWeights ws; // initialized to standard weights in packer_weights.cc

		ws.set_Wsol( 1.00 );
		ws.set_Wdun( 0.86 );
		ws.set_Wref( 0.48 );
		ws.set_Wone( 0.29 );
		ws.set_Wpair( 0.00 );
		ws.set_Watr( 0.59 );
		ws.set_Wrep( 0.01 );
		ws.set_Wintra( 0.01 );
		ws.set_Wh2o( 1.00 );
		ws.set_Wh2o_intra( 0.00 );
		ws.set_Wh2o_lj( 0.01 );
		ws.set_Wh2o_hb( -1.20 );
		ws.set_Whbond_bb( 0.40 );
		ws.set_Whbond_sc( 1.00 );
		ws.set_Whbond_bb_sc( 1.0 );
		ws.set_Wdna_bs( 0.0 );
		ws.set_Wdna_bp( 0.0 );

		// all other weights from PW_STANDARD
		//jjh Add to the database
		WS_db[ PW_DDG_MONOMER] = ws;
	}
	//////////////DONE  PW_DDG_MONOMER WEIGHTS//////////////////


	//jjh Interface ddG weights
	//////////////BEGIN INTERFACE WEIGHTS//////////////////
	{
		PackerWeights ws = RetrieveWeights(PW_DDG_MONOMER);

		ws.set_Wsol( 0.37 );
		ws.set_Wdun( 0.00 );
		// all other weights same as PW_DDG_MONOMER
		//jjh Add to the database
		WS_db[ PW_INTERFACE ] = ws;
	}
	//////////////DONE  INTERFACE WEIGHTS//////////////////

	//jjh Weights for DNA-interfaces

	//////////////BEGIN    DNA    WEIGHTS//////////////////
	{
		PackerWeights ws; // initialized to standard weights

		ws.set_Watr( 0.947733 );
		ws.set_Wrep( 0.577238 );
		ws.set_Wsol( 0.507356 );
		ws.set_Wdun( 0.682290 );
		ws.set_Wpair( 0.00 );
		ws.set_Wone( 0.612065 );
		ws.set_Wintra( 0.00 );

		ws.set_Wh2o( 1.00 );
		ws.set_Wh2o_lj( 0.80 );
		ws.set_Wh2o_intra( 0.50 );
		ws.set_Wh2o_hb( -1.50 );

		ws.set_Whbond_bb( 2.802529 );
		ws.set_Whbond_sc( 1.596235 );
		ws.set_Whbond_bb_sc( 2.802529 );
		ws.set_Wgb_elec( 0.203353 );
		ws.set_Wdna_bs( 0.1 ); // dna_bs weight
		ws.set_Wdna_bp( 0.1 ); // dna_bp weight

		// ref, lig, sasa, pH weights standard

		ws.set_Waa( aa_ala,  1.585483);
		ws.set_Waa( aa_cys,  1.182246);
		ws.set_Waa( aa_asp, -3.390001);
		ws.set_Waa( aa_glu, -1.617822);
		ws.set_Waa( aa_phe, -0.104050);
		ws.set_Waa( aa_gly,  2.197785);
		ws.set_Waa( aa_his, -0.838118);
		ws.set_Waa( aa_ile,  1.817350);
		ws.set_Waa( aa_lys,  1.538237);
		ws.set_Waa( aa_leu,  1.265827);
		ws.set_Waa( aa_met,  1.401874);
		ws.set_Waa( aa_asn, -1.061438);
		ws.set_Waa( aa_pro,  2.580971);
		ws.set_Waa( aa_gln,  0.207520);
		ws.set_Waa( aa_arg, -9.936887);
		ws.set_Waa( aa_ser,  2.594272);
		ws.set_Waa( aa_thr,  1.184337);
		ws.set_Waa( aa_val,  1.422931);
		ws.set_Waa( aa_trp, -1.820990);
		ws.set_Waa( aa_tyr, -0.209525);
		if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

		//jjh Add to the database
		WS_db[ PW_DNA ] = ws;
	}

	//ja non-GB DNA-interface weights, for speed
	// one cycle--very rough!
	///////////////////////////////
	{
		PackerWeights ws; // initialized to standard weights

		ws.set_Watr( 1.0806 );
		ws.set_Wrep( 0.6500 );
		ws.set_Wsol( 0.5842 );
		ws.set_Wdun( 0.7506 );
		ws.set_Wone( 0.9560 );
		ws.set_Wpair( 0.0 );
		ws.set_Wintra( 0.00 );
		ws.set_Wh2o( 1.00 );
		ws.set_Wh2o_lj( 0.80 );

		// trunk
//		ws.set_Wh2o_intra( 0.50 );
//		ws.set_Wh2o_hb( -1.50 );
		// ja
		ws.set_Wh2o_intra( 0.0 ); // waters placement neutral
		ws.set_Wh2o_hb( -0.30 ); // 'competed out by full-strength hbonds'

		ws.set_Whbond_bb( 3.1097 );
		ws.set_Whbond_sc( 2.5413 );
		ws.set_Whbond_bb_sc( 3.1097 );
		ws.set_Wgb_elec( 0.0 );
		ws.set_Wdna_bs( 0.1 ); // dna_bs weight
		ws.set_Wdna_bp( 0.1 ); // dna_bp weight

		ws.set_Waa( aa_ala, -0.2227);
		ws.set_Waa( aa_cys, -0.0000);
		ws.set_Waa( aa_asp, -0.1247);
		ws.set_Waa( aa_glu, -0.4745);
		ws.set_Waa( aa_phe, -1.1517);
		ws.set_Waa( aa_gly, -0.1945);
		ws.set_Waa( aa_his, -0.9436);
		ws.set_Waa( aa_ile,  0.1300);
		ws.set_Waa( aa_lys,  1.7573);
		ws.set_Waa( aa_leu,  0.2934);
		ws.set_Waa( aa_met, -0.4600);
		ws.set_Waa( aa_asn,  1.0555);
		ws.set_Waa( aa_pro, -0.8702);
		ws.set_Waa( aa_gln,  1.1015);
		ws.set_Waa( aa_arg,  1.7525);
		ws.set_Waa( aa_ser,  0.5713);
		ws.set_Waa( aa_thr,  0.8629);
		ws.set_Waa( aa_val, -0.0197);
		ws.set_Waa( aa_trp, -2.1569);
		ws.set_Waa( aa_tyr, -0.9058);

		if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

		WS_db[ PW_DNA_noGB ] = ws;
	}
	//////////////DONE     DNA    WEIGHTS//////////////////


	//////////////BEGIN    OPTE   WEIGHTS//////////////////
	{
		PackerWeights ws; // initialized to standard weights

		ws.set_Wsol( 1.000 );
		ws.set_Wdun( 1.000 );
		ws.set_Wref( 1.000 );
		ws.set_Wone( 1.000 );
		ws.set_Wpair( 1.000 );
		ws.set_Watr( 1.000 );
		ws.set_Wrep( 1.000 );
		ws.set_Wintra( 1.000 );
		ws.set_Wh2o( 1.000 );
		ws.set_Wh2o_intra( 1.000 );
		ws.set_Wh2o_lj( 0.800 );
		ws.set_Wh2o_hb(-1.200 );
		ws.set_Whbond_bb( 1.000 );
		ws.set_Whbond_sc( 1.000 );
		ws.set_Whbond_bb_sc( 1.000 );
		ws.set_Wgb_elec( 1.000 );
		ws.set_Wdna_bs( 0.000 );
		ws.set_Wdna_bp( 0.000 );

		ws.set_Wlig_atr( 1.000 );
		ws.set_Wlig_sol( 1.000 );
		ws.set_Wlig_cou( 1.000 );
		ws.set_Wlig_rep( 1.000 );
		ws.set_Wlig_hb(  1.000 );
		ws.set_Wlig_h2o( 1.000 );
		ws.set_Wlig_vir( 0.000 );

		ws.set_Waa( aa_ala,  0.000);
		ws.set_Waa( aa_cys,  0.000);
		ws.set_Waa( aa_asp,  0.000);
		ws.set_Waa( aa_glu,  0.000);
		ws.set_Waa( aa_phe,  0.000);
		ws.set_Waa( aa_gly,  0.000);
		ws.set_Waa( aa_his,  0.000);
		ws.set_Waa( aa_ile,  0.000);
		ws.set_Waa( aa_lys,  0.000);
		ws.set_Waa( aa_leu,  0.000);
		ws.set_Waa( aa_met,  0.000);
		ws.set_Waa( aa_asn,  0.000);
		ws.set_Waa( aa_pro,  0.000);
		ws.set_Waa( aa_gln,  0.000);
		ws.set_Waa( aa_arg,  0.000);
		ws.set_Waa( aa_ser,  0.000);
		ws.set_Waa( aa_thr,  0.000);
		ws.set_Waa( aa_val,  0.000);
		ws.set_Waa( aa_trp,  0.000);
		ws.set_Waa( aa_tyr,  0.000);
		if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

		//jjh Add to the database
		WS_db[ PW_OPTE ] = ws;
	}
	//////////////DONE     OPTE   WEIGHTS//////////////////

	//////////////BEGIN  SOFT_REP WEIGHTS//////////////////
	{
		PackerWeights ws; // initialized to standard weights

		ws.set_Wsol( 0.520 );
		ws.set_Wdun( 0.320 );
		ws.set_Wone( 0.410 );
		ws.set_Wpair( 0.270 );
		ws.set_Watr( 0.800 );
		ws.set_Wrep( 0.730 );
		ws.set_Wintra( 0.260 );
		ws.set_Wh2o( 1.000 );
		ws.set_Wh2o_intra( 0.000 );
		ws.set_Wh2o_lj( 0.800 );
		ws.set_Wh2o_hb(-1.200 );
		ws.set_Whbond_bb( 1.390 );
		ws.set_Whbond_sc( 1.330 );
		ws.set_Whbond_bb_sc( 1.390 );
		ws.set_Wgb_elec( 0.000 );
		ws.set_Wdna_bs( 0.000 );
		ws.set_Wdna_bp( 0.000 );

		// ref, lig, sasa, pH weights standard

		ws.set_Waa( aa_ala,  0.540);
		ws.set_Waa( aa_cys,  0.060);
		ws.set_Waa( aa_asp,  0.560);
		ws.set_Waa( aa_glu,  0.570);
		ws.set_Waa( aa_phe, -1.330);
		ws.set_Waa( aa_gly,  0.950);
		ws.set_Waa( aa_his, -1.110);
		ws.set_Waa( aa_ile,  0.040);
		ws.set_Waa( aa_lys,  0.610);
		ws.set_Waa( aa_leu,  0.120);
		ws.set_Waa( aa_met, -0.120);
		ws.set_Waa( aa_asn,  0.680);
		ws.set_Waa( aa_pro,  0.310);
		ws.set_Waa( aa_gln,  0.520);
		ws.set_Waa( aa_arg,  0.130);
		ws.set_Waa( aa_ser,  0.620);
		ws.set_Waa( aa_thr,  0.530);
		ws.set_Waa( aa_val,  0.170);
		ws.set_Waa( aa_trp, -2.710);
		ws.set_Waa( aa_tyr, -1.150);
		if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

		//jjh Add to the database
		WS_db[ PW_SOFT_REP ] = ws;
	}
	//////////////DONE   SOFT_REP WEIGHTS//////////////////

	//////////////BEGIN  SOFT_REP_DESIGN WEIGHTS//////////////////
	{
		PackerWeights ws; // initialized to standard weights

		ws.set_Wsol( 0.648 );
		ws.set_Wdun( 0.569 );
		ws.set_Wone( 0.915 );
		ws.set_Wpair( 0.452 );
		ws.set_Watr( 0.800 );
		ws.set_Wrep( 0.657 );
		ws.set_Wintra( 0.000 );
		ws.set_Wh2o( 1.000 );
		ws.set_Wh2o_intra( 0.000 );
		ws.set_Wh2o_lj( 0.800 );
		ws.set_Wh2o_hb(-1.200 );
		ws.set_Whbond_bb( 0.857 );
		ws.set_Whbond_sc( 0.857 );
		ws.set_Whbond_bb_sc( 0.857 );
		ws.set_Wgb_elec( 0.000 );
		ws.set_Wdna_bs( 0.000 );
		ws.set_Wdna_bp( 0.000 );

		// ref, lig, sasa, pH weights standard

		ws.set_Waa( aa_ala,  0.029);
		ws.set_Waa( aa_cys,  0.000);
		ws.set_Waa( aa_asp,  0.699);
		ws.set_Waa( aa_glu,  0.654);
		ws.set_Waa( aa_phe, -1.652);
		ws.set_Waa( aa_gly,  0.449);
		ws.set_Waa( aa_his, -0.890);
		ws.set_Waa( aa_ile, -0.526);
		ws.set_Waa( aa_lys,  0.749);
		ws.set_Waa( aa_leu, -0.226);
		ws.set_Waa( aa_met, -0.328);
		ws.set_Waa( aa_asn,  0.877);
		ws.set_Waa( aa_pro, -0.214);
		ws.set_Waa( aa_gln,  0.834);
		ws.set_Waa( aa_arg,  0.797);
		ws.set_Waa( aa_ser,  0.492);
		ws.set_Waa( aa_thr,  0.743);
		ws.set_Waa( aa_val, -0.177);
		ws.set_Waa( aa_trp, -1.232);
		ws.set_Waa( aa_tyr, -1.077);
		if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

		//jjh Add to the database
		WS_db[ PW_SOFT_REP_DESIGN ] = ws;
	}
	////////////DONE SOFT_REP_DESIGN WEIGHTS///////////////

	//////////////BEGIN  GEN_BORN WEIGHTS//////////////////
	{
		PackerWeights ws; // initialized to standard weights

		ws.set_Wsol( 0.500 );
		ws.set_Wdun( 0.340 );
		ws.set_Wone( 0.520 );
		ws.set_Wpair( 0.000 );
		ws.set_Watr( 0.800 );
		ws.set_Wrep( 0.490 );
		ws.set_Wintra( 0.050 );
		ws.set_Wh2o( 1.000 );
		ws.set_Wh2o_intra( 0.000 );
		ws.set_Wh2o_lj( 0.800 );
		ws.set_Wh2o_hb(-1.200 );
		ws.set_Whbond_bb( 1.830 );
		ws.set_Whbond_sc( 1.830 );
		ws.set_Whbond_bb_sc( 1.830 );
		ws.set_Wgb_elec( 0.07 );
		ws.set_Wdna_bs( 0.000 );
		ws.set_Wdna_bp( 0.000 );

		// ref, lig, sasa, pH weights standard

		ws.set_Waa( aa_ala,  1.100);
		ws.set_Waa( aa_cys, 15.130);
		ws.set_Waa( aa_asp, -2.580);
		ws.set_Waa( aa_glu, -1.640);
		ws.set_Waa( aa_phe, -1.310);
		ws.set_Waa( aa_gly,  1.170);
		ws.set_Waa( aa_his, -1.630);
		ws.set_Waa( aa_ile,  0.820);
		ws.set_Waa( aa_lys, -0.170);
		ws.set_Waa( aa_leu,  0.280);
		ws.set_Waa( aa_met,  0.300);
		ws.set_Waa( aa_asn, -1.530);
		ws.set_Waa( aa_pro,  1.420);
		ws.set_Waa( aa_gln, -0.820);
		ws.set_Waa( aa_arg, -8.430);
		ws.set_Waa( aa_ser,  1.370);
		ws.set_Waa( aa_thr,  0.440);
		ws.set_Waa( aa_val,  0.700);
		ws.set_Waa( aa_trp, -3.070);
		ws.set_Waa( aa_tyr, -1.530);
		if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

		//jjh Add to the database
		WS_db[ PW_GEN_BORN ] = ws;
	}
	//////////////DONE   GEN_BORN WEIGHTS//////////////////

	//////////////BEGIN  SOFT_REP & GEN_BORN  WEIGHTS//////////////////
	{
		PackerWeights ws; // initialized to standard weights

		ws.set_Wsol( 0.440 );
		ws.set_Wdun( 0.290 );
		ws.set_Wref( 1.000 );
		ws.set_Wone( 0.400 );
		ws.set_Wpair( 0.000 );
		ws.set_Watr( 0.800 );
		ws.set_Wrep( 0.750 );
		ws.set_Wintra( 0.300 );
		ws.set_Wh2o( 1.000 );
		ws.set_Wh2o_intra( 0.000 );
		ws.set_Wh2o_lj( 0.800 );
		ws.set_Wh2o_hb(-1.200 );
		ws.set_Whbond_bb( 1.270 );
		ws.set_Whbond_sc( 1.350 );
		ws.set_Whbond_bb_sc( 1.270 );
		ws.set_Wgb_elec( 0.06 );
		ws.set_Wdna_bs( 0.00 );
		ws.set_Wdna_bp( 0.00 );

		// lig, sasa, pH weights standard

		ws.set_Waa( aa_ala,  1.790);
		ws.set_Waa( aa_cys,  1.300);
		ws.set_Waa( aa_asp, -1.730);
		ws.set_Waa( aa_glu, -0.920);
		ws.set_Waa( aa_phe, -0.390);
		ws.set_Waa( aa_gly,  2.020);
		ws.set_Waa( aa_his, -1.050);
		ws.set_Waa( aa_ile,  1.330);
		ws.set_Waa( aa_lys,  0.420);
		ws.set_Waa( aa_leu,  0.880);
		ws.set_Waa( aa_met,  0.930);
		ws.set_Waa( aa_asn, -0.710);
		ws.set_Waa( aa_pro,  1.630);
		ws.set_Waa( aa_gln, -0.140);
		ws.set_Waa( aa_arg, -7.090);
		ws.set_Waa( aa_ser,  2.020);
		ws.set_Waa( aa_thr,  1.080);
		ws.set_Waa( aa_val,  1.300);
		ws.set_Waa( aa_trp, -1.860);
		ws.set_Waa( aa_tyr, -0.800);
		if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

		//jjh Add to the database
		WS_db[ PW_SOFT_REP_GEN_BORN ] = ws;
	}
	//////////////BEGIN  SOFT_REP & GEN_BORN  WEIGHTS//////////////////

	////////BEGIN  LIGAND WITH SOFT_REP & GEN_BORN  WEIGHTS////////////
	{
		PackerWeights ws = RetrieveWeights(PW_SOFT_REP_GEN_BORN);

		ws.set_Wsol( 0.45 );
		ws.set_Wdun( 0.30 );
		ws.set_Wone( 0.35 );
		ws.set_Wrep( 0.60 );
		ws.set_Wintra( 0.39 );
		ws.set_Whbond_bb_sc( 1.10 );
		ws.set_Whbond_bb( 1.10 );
		ws.set_Whbond_sc( 1.10 );
		ws.set_Wgb_elec( 0.04 );

		ws.set_Wlig_sol( 0.45 );
		ws.set_Wlig_cou( 0.01 );
		ws.set_Wlig_rep( 0.60 );
		ws.set_Wlig_hb( 1.10 );

		// all other weights from PW_SOFT_REP_GEN_BORN

		ws.set_Waa( aa_ala,   0.87);
		ws.set_Waa( aa_cys,   0.84);
		ws.set_Waa( aa_asp,  -0.74);
		ws.set_Waa( aa_glu,  -0.58);
		ws.set_Waa( aa_phe,  -0.76);
		ws.set_Waa( aa_gly,   1.39);
		ws.set_Waa( aa_his,  -1.04);
		ws.set_Waa( aa_ile,   1.18);
		ws.set_Waa( aa_lys,   0.48);
		ws.set_Waa( aa_leu,   0.91);
		ws.set_Waa( aa_met,   0.75);
		ws.set_Waa( aa_asn,  -0.12);
		ws.set_Waa( aa_pro,   0.71);
		ws.set_Waa( aa_gln,  -0.24);
		ws.set_Waa( aa_arg,  -4.03);
		ws.set_Waa( aa_ser,   1.27);
		ws.set_Waa( aa_thr,   0.90);
		ws.set_Waa( aa_val,   0.99);
		ws.set_Waa( aa_trp,  -2.09);
		ws.set_Waa( aa_tyr,  -0.67);
		if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

		//jjh Add to the database
		WS_db[ PW_LIGAND_SOFT_REP_GEN_BORN ] = ws;
	}
////////END    LIGAND WITH SOFT_REP & GEN_BORN  WEIGHTS////////////

/////////////BEGIN  LIGAND WITH GEN_BORN  WEIGHTS//////////////////

		{
			PackerWeights ws = RetrieveWeights(PW_GEN_BORN);

			ws.set_Wsol( 0.60 );
			ws.set_Wdun( 0.38 );
			ws.set_Wrep( 0.40 );
			ws.set_Wintra( 0.00 );
			ws.set_Whbond_bb( 2.0 );
			ws.set_Whbond_sc( 2.0 );
			ws.set_Whbond_bb_sc( 2.0 );
			ws.set_Wgb_elec( 0.04 );

			ws.set_Wlig_sol( 0.60 );
			ws.set_Wlig_cou( 0.00 );
			ws.set_Wlig_rep( 0.40 );
			ws.set_Wlig_hb( 2.0 );

			// all other weights from PW_GEN_BORN

			ws.set_Waa( aa_ala,   0.60);
			ws.set_Waa( aa_cys,   0.55);
			ws.set_Waa( aa_asp,  -0.52);
			ws.set_Waa( aa_glu,  -0.41);
			ws.set_Waa( aa_phe,  -1.41);
			ws.set_Waa( aa_gly,   1.11);
			ws.set_Waa( aa_his,  -0.78);
			ws.set_Waa( aa_ile,   1.47);
			ws.set_Waa( aa_lys,   0.65);
			ws.set_Waa( aa_leu,   1.03);
			ws.set_Waa( aa_met,   0.84);
			ws.set_Waa( aa_asn,   0.01);
			ws.set_Waa( aa_pro,   1.10);
			ws.set_Waa( aa_gln,  -0.15);
			ws.set_Waa( aa_arg,  -4.00);
			ws.set_Waa( aa_ser,   1.10);
			ws.set_Waa( aa_thr,   0.93);
			ws.set_Waa( aa_val,   1.18);
			ws.set_Waa( aa_trp,  -2.50);
			ws.set_Waa( aa_tyr,  -0.80);
			if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

			ws.set_Wref( 1.000 );
			ws.set_Wh2o( 1.000 );
			ws.set_Wh2o_intra( 0.000 );
			ws.set_Wh2o_lj( 0.800 );
			ws.set_Wh2o_hb(-1.200 );
			ws.set_Wlig_h2o( 1.00 );
			ws.set_Wlig_vir( 3.00 );

			//jjh Add to the database
			WS_db[ PW_LIGAND_GEN_BORN ] = ws;
		}
		/////////////END    LIGAND WITH GEN_BORN  WEIGHTS//////////////////

		/////////////BEGIN  LIGAND WITH SOFT_REP  WEIGHTS//////////////////
			{
				PackerWeights ws = RetrieveWeights(PW_SOFT_REP);

				ws.set_Wsol( 0.50 );
				ws.set_Wpair( 0.50 );
				ws.set_Wone( 0.32 );
				ws.set_Wdun( 0.32 );
				ws.set_Wrep( 0.60 );
				ws.set_Wintra( 0.30 );
				ws.set_Whbond_bb( 1.20 );
				ws.set_Whbond_sc( 1.20 );
				ws.set_Whbond_bb_sc( 1.20 );

				ws.set_Wlig_sol( 0.50 );
				ws.set_Wlig_rep( 0.60 );
				ws.set_Wlig_hb( 1.20 );

				// all other weights from PW_SOFT_REP

				ws.set_Waa( aa_ala,   0.21);
				ws.set_Waa( aa_cys,   0.21);
				ws.set_Waa( aa_asp,   0.41);
				ws.set_Waa( aa_glu,   0.12);
				ws.set_Waa( aa_phe,  -1.24);
				ws.set_Waa( aa_gly,   0.81);
				ws.set_Waa( aa_his,  -1.30);
				ws.set_Waa( aa_ile,   0.49);
				ws.set_Waa( aa_lys,   0.42);
				ws.set_Waa( aa_leu,   0.53);
				ws.set_Waa( aa_met,   0.21);
				ws.set_Waa( aa_asn,   0.65);
				ws.set_Waa( aa_pro,  -0.02);
				ws.set_Waa( aa_gln,   0.20);
				ws.set_Waa( aa_arg,   0.27);
				ws.set_Waa( aa_ser,   0.32);
				ws.set_Waa( aa_thr,   0.58);
				ws.set_Waa( aa_val,   0.39);
				ws.set_Waa( aa_trp,  -2.50);
				ws.set_Waa( aa_tyr,  -0.76);
				if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

				//jjh Add to the database
				WS_db[ PW_LIGAND_SOFT_REP ] = ws;
			}
			/////////////END  LIGAND WITH SOFT_REP  WEIGHTS//////////////////

			//////////////BEGIN  STANDARD LIGAND WEIGHTS//////////////////
				{
					PackerWeights ws = RetrieveWeights(PW_LIGAND_GEN_BORN);

					ws.set_Wdun( 0.40 );
					ws.set_Wone( 0.50 );
					ws.set_Wpair( 0.80 );
					ws.set_Wgb_elec( 0.0 );

					ws.set_Wlig_cou( 0.25 );

					ws.set_Waa( aa_ala,  -0.05);
					ws.set_Waa( aa_cys,  -0.09);
					ws.set_Waa( aa_asp,   0.65);
					ws.set_Waa( aa_glu,   0.27);
					ws.set_Waa( aa_phe,  -1.88);
					ws.set_Waa( aa_gly,   0.55);
					ws.set_Waa( aa_his,  -1.17);
					ws.set_Waa( aa_ile,   0.73);
					ws.set_Waa( aa_lys,   0.42);
					ws.set_Waa( aa_leu,   0.66);
					ws.set_Waa( aa_met,   0.29);
					ws.set_Waa( aa_asn,   0.76);
					ws.set_Waa( aa_pro,   0.33);
					ws.set_Waa( aa_gln,   0.29);
					ws.set_Waa( aa_arg,   0.77);
					ws.set_Waa( aa_ser,  -0.00);
					ws.set_Waa( aa_thr,   0.57);
					ws.set_Waa( aa_val,   0.57);
					ws.set_Waa( aa_trp,  -2.88);
					ws.set_Waa( aa_tyr,  -0.81);
					if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

					//jjh Add to the database
					WS_db[ PW_LIGAND ] = ws;
				}
				//////////////END    STANDARD LIGAND WEIGHTS//////////////////

				//////////////BEGIN  BETA SOFT  WEIGHTS////////////////////////////
				{
					PackerWeights ws;		// PW_STANDARD weights for all but Waa

					//ex1 ex2aro_only extrachi_cutoff 1 for beta protein
					//no_his_his_pairE flag is used
					ws.set_Waa( aa_ala,   0.14);
					ws.set_Waa( aa_cys,  -1.70);
					ws.set_Waa( aa_asp,   0.80);
					ws.set_Waa( aa_glu,   0.98);
					ws.set_Waa( aa_phe,  -1.15);
					ws.set_Waa( aa_gly,   0.33);
					ws.set_Waa( aa_his,  -0.34);
					ws.set_Waa( aa_ile,  -0.32);
					ws.set_Waa( aa_lys,   0.77);
					ws.set_Waa( aa_leu,   0.03);
					ws.set_Waa( aa_met,   0.43);
					ws.set_Waa( aa_asn,   1.00);
					ws.set_Waa( aa_pro,  -0.79);
					ws.set_Waa( aa_gln,   1.08);
					ws.set_Waa( aa_arg,   1.08);
					ws.set_Waa( aa_ser,   0.59);
					ws.set_Waa( aa_thr,   0.42);
					ws.set_Waa( aa_val,  -0.28);
					ws.set_Waa( aa_trp,  -1.44);
					ws.set_Waa( aa_tyr,  -0.93);
					if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

					// Add to the database
					WS_db[ PW_BETA_SOFT_REP ] = ws;
				}
				//////////////END BETA SOFT WEIGHTS/////////////////////////

				//////////////BEGIN  ALLFOLD SOFT  WEIGHTS/////////////////////

				{
					PackerWeights ws;		// PW_STANDARD weights for all except Waa

					//ex1 ex2aro_only for all fold protein
					ws.set_Waa( aa_ala,   0.23);
					ws.set_Waa( aa_cys,  -1.70);
					ws.set_Waa( aa_asp,   0.84);
					ws.set_Waa( aa_glu,   0.95);
					ws.set_Waa( aa_phe,  -0.98);
					ws.set_Waa( aa_gly,   0.61);
					ws.set_Waa( aa_his,   0.19);
					ws.set_Waa( aa_ile,  -0.24);
					ws.set_Waa( aa_lys,   0.76);
					ws.set_Waa( aa_leu,   0.05);
					ws.set_Waa( aa_met,   0.48);
					ws.set_Waa( aa_asn,   1.04);
					ws.set_Waa( aa_pro,  -0.44);
					ws.set_Waa( aa_gln,   1.05);
					ws.set_Waa( aa_arg,   1.07);
					ws.set_Waa( aa_ser,   0.68);
					ws.set_Waa( aa_thr,   0.53);
					ws.set_Waa( aa_val,  -0.20);
					ws.set_Waa( aa_trp,  -1.36);
					ws.set_Waa( aa_tyr,  -0.75);
					if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

					// Add to the database
					WS_db[ PW_ALLFOLD_SOFT_REP ] = ws;
				}
				//////////////END ALL FOLD SOFT WEIGHTS/////////////////////////


				//////////////BEGIN  SMALL_RADII  WEIGHTS/////////////////////
				{
					PackerWeights ws;		// PW_STANDARD weights for all but Waa

					//ex1 ex2aro_only
					ws.set_Waa( aa_ala,  -0.12);
					ws.set_Waa( aa_cys,  -1.00);
					ws.set_Waa( aa_asp,   0.67);
					ws.set_Waa( aa_glu,   0.75);
					ws.set_Waa( aa_phe,  -0.95);
					ws.set_Waa( aa_gly,   0.17);
					ws.set_Waa( aa_his,  -0.48);
					ws.set_Waa( aa_ile,  -0.44);
					ws.set_Waa( aa_lys,   0.56);
					ws.set_Waa( aa_leu,  -0.17);
					ws.set_Waa( aa_met,   0.28);
					ws.set_Waa( aa_asn,   0.89);
					ws.set_Waa( aa_pro,  -0.60);
					ws.set_Waa( aa_gln,   0.90);
					ws.set_Waa( aa_arg,   0.98);
					ws.set_Waa( aa_ser,   0.37);
					ws.set_Waa( aa_thr,   0.27);
					ws.set_Waa( aa_val,  -0.40);
					ws.set_Waa( aa_trp,  -1.75);
					ws.set_Waa( aa_tyr,  -0.69);
					if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

					// Add to the database
					WS_db[ PW_SMALL_RADII ] = ws;
				}
				//////////////END ALL FOLD SOFT WEIGHTS/////////////////////////


				//////////////BEGIN  SMOOTH_ETABLE WEIGHTS//////////////////
				{
					PackerWeights ws; // initialized to standard weights

					ws.set_Wsol( 0.55590 );
					ws.set_Wdun( 0.4545 );
					ws.set_Wone( 0.8803 );
					ws.set_Wpair( -0.3502 );
					ws.set_Watr( 0.800 );
					ws.set_Wrep( 0.3054 );
					ws.set_Wintra( 0.00 );
					ws.set_Wh2o( 1.000 );
					ws.set_Wh2o_intra( 0.000 );
					ws.set_Wh2o_lj( 0.800 );
					ws.set_Wh2o_hb(-1.200 );
					ws.set_Whbond_bb( 1.0750 );
					ws.set_Whbond_sc( 1.0750 );
					ws.set_Whbond_bb_sc( 1.0750 );
					ws.set_Wgb_elec( 0.000 );
					ws.set_Wdna_bs( 0.000 );
					ws.set_Wdna_bp( 0.000 );

		// ref, lig, sasa, pH weights standard

					ws.set_Waa( aa_ala,  0.5377);
					ws.set_Waa( aa_cys,  0.000);
					ws.set_Waa( aa_asp,  1.0186);
					ws.set_Waa( aa_glu,  0.9812);
					ws.set_Waa( aa_phe, -2.1132);
					ws.set_Waa( aa_gly,  0.5325);
					ws.set_Waa( aa_his, -1.0718);
					ws.set_Waa( aa_ile,  -0.2431);
					ws.set_Waa( aa_lys,  1.1487);
					ws.set_Waa( aa_leu,  0.1621);
					ws.set_Waa( aa_met, -0.5775);
					ws.set_Waa( aa_asn,  1.2085);
					ws.set_Waa( aa_pro,  0.6652);
					ws.set_Waa( aa_gln,  0.6658);
					ws.set_Waa( aa_arg,  0.537);
					ws.set_Waa( aa_ser,  0.8603);
					ws.set_Waa( aa_thr,  0.7266);
					ws.set_Waa( aa_val,  0.1054);
					ws.set_Waa( aa_trp, -3.7561);
					ws.set_Waa( aa_tyr, -1.3879);
					if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));

					//jjh Add to the database
					WS_db[ PW_SMOOTH_ETABLE ] = ws;
				}
				//////////////DONE  SMOOTH_ETABLE  WEIGHTS//////////////////


				//////////////BEGIN PKA WEIGHTS//////////////////
				{
					PackerWeights ws = RetrieveWeights(PW_GEN_BORN);

					ws.set_Wsol( 0.500 * pH_ns::Wscale);
					ws.set_Wdun( 0.340 * pH_ns::Wscale );
					ws.set_Wone( 0.520 * pH_ns::Wscale );
					ws.set_Wpair( 0.000 * pH_ns::Wscale );
					ws.set_Watr( 0.800 * pH_ns::Wscale );
					ws.set_Wrep( 0.490 * pH_ns::Wscale );
					ws.set_Wintra( 0.050 * pH_ns::Wscale );
					ws.set_Wh2o( 1.000 * pH_ns::Wscale );
					ws.set_Wh2o_intra( 0.000 * pH_ns::Wscale );
					ws.set_Wh2o_lj( 0.800 * pH_ns::Wscale );
					ws.set_Wh2o_hb(-1.200 * pH_ns::Wscale );
					ws.set_Whbond_bb( 1.830 * pH_ns::Wscale );
					ws.set_Whbond_sc( 1.830 * pH_ns::Wscale );
					ws.set_Whbond_bb_sc( 1.830 * pH_ns::Wscale );
					ws.set_Wgb_elec( pH_ns::Wgb ); //0.07
					ws.set_Wdna_bs( 0.000 * pH_ns::Wscale );
					ws.set_Wdna_bp( 0.000 * pH_ns::Wscale );

					ws.set_Waa( aa_ala,  0.000);
					ws.set_Waa( aa_cys,  0.000);
					ws.set_Waa( aa_asp,  0.000);
					ws.set_Waa( aa_glu,  0.000);
					ws.set_Waa( aa_phe,  0.000);
					ws.set_Waa( aa_gly,  0.000);
					ws.set_Waa( aa_his,  0.000);
					ws.set_Waa( aa_ile,  0.000);
					ws.set_Waa( aa_lys,  0.000);
					ws.set_Waa( aa_leu,  0.000);
					ws.set_Waa( aa_met,  0.000);
					ws.set_Waa( aa_asn,  0.000);
					ws.set_Waa( aa_pro,  0.000);
					ws.set_Waa( aa_gln,  0.000);
					ws.set_Waa( aa_arg,  0.000);
					ws.set_Waa( aa_ser,  0.000);
					ws.set_Waa( aa_thr,  0.000);
					ws.set_Waa( aa_val,  0.000);
					ws.set_Waa( aa_trp,  0.000);
					ws.set_Waa( aa_tyr,  0.000);
					if ( add_pser() ) ws.set_Waa( aa_sep, ws.Waa(aa_ser));


					//jjh Add to the database
					WS_db[ PW_PKA ] = ws;
				}
				//////////////DONE PKA WEIGHTS//////////////////

				RetrieveWeightsToCurrent( PW_STANDARD );  // Initialize with these weights
				return;
}

//lin packerweights_id from string
packerweights_id
packerweights_id_from_string(std::string const & wt_name ){

	packerweights_id wt_id = PW_STANDARD;

	if( wt_name == "PW_STANDARD" ) {
		wt_id = PW_STANDARD ;
	} else if( wt_name == "PW_INTERFACE" ) {
		wt_id = PW_INTERFACE ;
	} else if( wt_name == "PW_DNA" ) {
		wt_id = PW_DNA ;
	} else if( wt_name == "PW_OPTE" ) {
		wt_id = PW_OPTE ;
	} else if( wt_name == "PW_SAVE_PACK" ) {
		wt_id = PW_SAVE_PACK ;
	} else if( wt_name == "PW_SOFT_REP" ) {
		wt_id = PW_SOFT_REP ;
	} else if( wt_name == "PW_GEN_BORN" ) {
		wt_id = PW_GEN_BORN ;
	} else if( wt_name == "PW_SOFT_REP_GEN_BORN" ) {
		wt_id = PW_SOFT_REP_GEN_BORN ;
	} else if( wt_name == "PW_LIGAND_SOFT_REP_GEN_BORN" ) {
		wt_id = PW_LIGAND_SOFT_REP_GEN_BORN ;
	} else if( wt_name == "PW_LIGAND_SOFT_REP" ) {
		wt_id = PW_LIGAND_SOFT_REP ;
	} else if( wt_name == "PW_LIGAND_GEN_BORN" ) {
		wt_id = PW_LIGAND_GEN_BORN ;
	} else if( wt_name == "PW_LIGAND" ) {
		wt_id = PW_LIGAND ;
	} else if( wt_name == "PW_DDG_MONOMER" ) {
		wt_id = PW_DDG_MONOMER ;
	} else if( wt_name == "PW_BETA_SOFT_REP" ) {
		wt_id = PW_BETA_SOFT_REP ;
	} else if( wt_name == "PW_ALLFOLD_SOFT_REP" ) {
		wt_id = PW_ALLFOLD_SOFT_REP ;
	} else if( wt_name == "PW_SOFT_REP_DESIGN" ) {
		wt_id = PW_SOFT_REP_DESIGN ;
	} else if( wt_name == "PW_SMALL_RADII" ) {
		wt_id = PW_SMALL_RADII ;
	} else if( wt_name == "PW_SMOOTH_ETABLE" ) {
		wt_id = PW_SMOOTH_ETABLE ;
	} else if( wt_name == "PW_PKA" ) {
		wt_id = PW_PKA ;
	} else {
		std::cout << "STOPPING:: invalid packerweight_id: " <<
			wt_name << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	return wt_id;

}

