// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10598 $
//  $Date: 2006-10-07 20:11:41 -0700 (Sat, 07 Oct 2006) $
//  $Author: rhiju $

#ifndef INCLUDED_wobble
#define INCLUDED_wobble


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// wobble Function Declarations


void
small_wobble_move(
	int const nmoves,
	FArray1DB_int & move_list,
	int & length,
	int const nwobble,
	int const max_wobble_gap,
	int & begin,
	int & end
);


void
small_wobble_move(
	int const nmoves,
	FArray1DB_int & move_list,
	int & length,
	int const nwobble,
	int const max_wobble_gap,
	int & begin,
	int & end,
	int & total_begin,
	int & total_end
);

void
chuck_wobble_move(
	int size,
	float cutoff_max,
	int nwobble,
	int max_wobble_gap,
	int & total_begin,
	int & total_end,
	bool & gfrag // if true, powell minimized sucessfully
);


void
add_fast_wobble(
	int & frag_begin,
	int size,
	int nwobble,
	int wobble_gap,
	float & rama_score,
	float & dist_score,
	bool & gfrag,
	int & fold_begin,
	int & fold_end,
	bool allow_use_CCD = true
);


void
add_wobble(
	int & frag_begin,
	int size,
	int & mres_gap1,
	int & mres_gap2,
	int & mres_before,
	int & mres_after,
	float & rama_score,
	float & dist_score,
	bool & gfrag // true if okay, false if powell blew up
);


void
splint_set_com_weight( float com_weight_x );


void
splint_get_com_weight( float & com_weight_x );


void
build_splint(
	int const xbegin,
	int const xend,
	FArray1Da_int xmap,
	int const xcount
);

void
splint_precompute(
	FArray2Da_float pos1,
	float const phi1,
	FArray2Da_float pos2,
	float const phi2,
	FArray3Da_float pos3,
	int const nres
);


float
splint_compute();


bool
find_splint(
	FArray1Da_float phipsi,
	int nangles,
	float & msd_score,
	float & rama_score
);


float
func_wobble(
	FArray1Da_float phipsi,
	bool & gfrag,
	float & msd_score,
	float & rama_score
);

bool
splint_refold(
	FArray1Da_float phipsi
);


bool
wobble_unpack_phipsi(
	FArray1Da_float phipsi,
	FArray1Da_int angle_map,
	int map_length,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega
);

void
wobble_pack_phipsi(
	FArray1Da_int xmap,
	int const xcount,
	FArray1Da_float phipsi,
	int const nangles
);


void
wobble_cost(
	float & rama_score,
	float & msd_score
);


void
angle_in_range( float & ang );


void
dfunc_wobble(
	FArray1Da_float phipsi,
	FArray1Da_float dE_dphipsi,
	int n
);


void
make_unit_vector_from_splint(
	int & i,
	int & phi_or_psi,
	FArray1Da_float vec,
	int & end_atom,
	int & end_res
);


void
screen_move_trial(
	int & insert_start,
	int & insert_end,
	float & bump_score
);


void
screen_move_best(
	int & insert_start,
	int & insert_end,
	float & bump_score
);


void
screen_move(
	int & insert_start,
	int & insert_end,
	int & total_residue,
	FArray2Da_float position,
	FArray2Da_float best_position,
	FArray2Da_float centroid,
	FArray2Da_float best_centroid,
	FArray1Da_short atom_type,
	FArray1Da_short atom_type_cen,
	float & bump_score
);


bool
wobble_is_close_to_a_chainbreak(
	int & frag_begin,
	int size,
	int nwobble,
	int wobble_gap,
	float & rama_score,
	float & msd_score,
	bool & gfrag,
	int & fold_begin,
	int & fold_end
	);

#endif
