#ifndef CORR_SIMULATED_ANNEALER_H
#define CORR_SIMULATED_ANNEALER_H

// Rosetta Headers
#include "SimAnnealerBase.h"
#include "InteractionGraphFWD.h"


// forward declaration
class RotamerSet;

namespace pack{

extern bool use_CorrelatedSimAnnealer;

class CorrelatedSimAnnealer;

class CorrelatedSimAnnealer : public SimAnnealerBase
{
 public:
      CorrelatedSimAnnealer(
      std::vector<int> & rot_to_pack,
			std::vector< std::vector<int> > & rotamer_correlations,
      FArray1D_int & bestrotamer_at_seqpos,
      float & bestenergy,
      bool start_with_current, // start simulation with current rotamers
      InteractionGraphBase * ig,
      const RotamerSet * p_rotamer_set,
      FArray1DB_int & current_rot_index,
      bool calc_rot_freq,
      FArray1D_float & rot_freq
      );

      CorrelatedSimAnnealer(
			std::vector< std::vector<int> > & rotamer_correlations,
      FArray1D_int & bestrotamer_at_seqpos,
      float & bestenergy,
      bool start_with_current, // start simulation with current rotamers
      InteractionGraphBase * ig,
      const RotamerSet * p_rotamer_set,
      FArray1DB_int & current_rot_index,
      bool calc_rot_freq,
      FArray1D_float & rot_freq
      );

      virtual ~CorrelatedSimAnnealer();
      void run();

      int pick_a_rotamer( int, int );
			int pick_correlated_rotamer( int );

 private:
      InteractionGraphBase * ig_;
      CorrelatedSimAnnealer(const CorrelatedSimAnnealer & rhs);
      std::vector<int> rot_to_pack_;
			std::vector< std::vector<int> > rotamer_correlations_;
};
}//end of namespace

#endif


