// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef EQUIVRESFILEREADER_H
#define EQUIVRESFILEREADER_H

#include <vector>
#include <string>
#include <list>
#include <map>

using namespace std;

class EquivResfileReader
{

public:
  EquivResfileReader();
  virtual ~EquivResfileReader();
  bool valid_word(string query);         // check that string is only made up of letters
  string itos(int i);                    // convert an int to a string
  int seq_pos_from_pdb_res_num_chain( int const pdb_res_num_in, char const pdb_chain_in );
  bool merging_lists_of_strings( list<string> & LoS1, list<string> LoS2); // merges lists if they have a common string and returns true
  void merge_vectors_of_lists_of_strings( vector< list<string> > & VoLoS1, vector< list<string> > VoLoS2); // merges lists with common string and appends unique lists
  void read_equivalent_residue_file(string equiv_resfile_name, vector< list<int> > & equivalent_residues); // creates vector with lists of equivalent residues as strings in format chain:number

private:

  void expand_range_into_unordered_list(string & value);
  void expand_range_into_ordered_list(string & value);
  string process_string_without_ranges(string & value);
  string process_string_with_ranges(string & value);
  void check_size_of_ordered_lists_equal( map<string, string> query_map);
  void create_vector_of_ordered_lists( map<string, string> query_map, vector< list<string> > & vector_list );
  void create_vector_of_unordered_lists( map<string, string> query_map, vector< list<string> > & vector_list );
  void convert_vector_of_list_of_pdb_residues_to_rosetta_numbering( vector< list<string> > & equivalent_pdb_residues, vector< list<int> > & equivalent_rosetta_residues );

};

#endif
