// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef FIXBB_SIMULATED_ANNEALER_H
#define FIXBB_SIMULATED_ANNEALER_H

// Rosetta Headers
#include "InteractionGraphFWD.h"
#include "SimAnnealerBase.h"
#include "RotamerAssigningAnnealer.h"
#include "RotamerSet.h"


namespace pack{

class FixbbSimAnnealer;

class FixbbSimAnnealer : public RotamerAssigningAnnealer
{
 public:
      FixbbSimAnnealer(
      std::vector<int> & rot_to_pack,
      FArray1D_int & bestrotamer_at_seqpos,
      float & bestenergy,
      bool start_with_current, // start simulation with current rotamers
      InteractionGraphBase * ig,
      const RotamerSet * p_rotamer_set,
      FArray1DB_int & current_rot_index,
      bool calc_rot_freq,
      FArray1D_float & rot_freq
      );

      FixbbSimAnnealer(
      FArray1D_int & bestrotamer_at_seqpos,
      float & bestenergy,
      bool start_with_current, // start simulation with current rotamers
      InteractionGraphBase * ig,
      const RotamerSet * p_rotamer_set,
      FArray1DB_int & current_rot_index,
      bool calc_rot_freq,
      FArray1D_float & rot_freq
      );

      virtual ~FixbbSimAnnealer();
      void run();

 private:
      InteractionGraphBase* ig_;
      FixbbSimAnnealer(const FixbbSimAnnealer& rhs);
};
}//end of namespace

#endif


