// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef INCLUDED_HBONDSET
#define INCLUDED_HBONDSET

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// C++ headers
//#include <iosfwd>
//#include <vector>


// forward declarations

class HBond // not used yet
{
 private:
  int donh_atm_,  // record donor H and acceptor on creation
    don_res_,
    act_atm_,
    act_res_;
	
	float dist2_, cospsi_, costheta_, coschi_;
	float burial_;
	
  int type_; // type of this hbond
  float energy_;
  FArray2D_float deriv_; // xyz,f1/f2   deriv increments

 public:
  HBond(int const donh_atm, int const don_res, int const act_atm, int const act_res):
    donh_atm_(donh_atm), don_res_(don_res), act_atm_(act_atm), act_res_(act_res)
    {};

    void set_type(int const type) { type_ = type; };
    int type() const{ return type_; };
};



class HBondSet
{
 private:
  int nhbonds_; // number of hbonds in this set
//  utility::vector1<HBond> hb_; // a collection of HBond objects, one per HBond, naturally.

  FArray1D_bool hbond_allowed_; // used only in decoystats -- get rid of it for production
  FArray2D_bool hbchk_; // per residue: whether BB NH and O are involved in hbonds.  Used to throw out sc bonds and geom solvation; probably should disappear.

  FArray1D_int hbtype_; // hbond type of each hbond


 public:

  FArray1D_int hbdonh_atm; //record donor H
  FArray1D_int hbdon_res;
  FArray1D_int hbact_atm;  //record acceptor
  FArray1D_int hbact_res;

  FArray2D_short global_atm_to_hbpair_id;
  FArray2D_short hbpair_id_to_hb_id;

  FArray1D_float hbenergies;
  FArray3D_float hbderiv; // xyz,f1/f2   deriv increments

  HBondSet() { return; };

  ~HBondSet() { return; };

  void reset(int const nres);

  // Accessor functions
  int nhbonds() const { return nhbonds_; };
  void set_nhbonds(int const val) { nhbonds_ = val; };
  void addto_nhbonds(int const val) { nhbonds_ += val; };
  int incr_nhbonds() { return ++nhbonds_; };

  int hbtype(int const i) const { return hbtype_(i); };
  int &ref_hbtype(int const i) { return hbtype_(i); };
  void set_hbtype(int const i, int const val) { hbtype_(i) = val; }; //HBEvalType

  void allow_hbond(int const i) { hbond_allowed_(i) = true; };
  void forbid_hbond(int const i) { hbond_allowed_(i) = false; };
  bool hbond_allowed(int const i) const { return hbond_allowed_(i); };
	
	bool BBhbToNH_exists(int const i) const { return hbchk_(1, i); };
	bool BBhbToO_exists(int const i) const { return hbchk_(2, i); };
	bool &hbchkPair(int const i) { return hbchk_(1, i); };
	
	void symmetrize_hbchk();
	
	void IdentifyHBonds(FArray1DB_int const & aan,
								 FArray1DB_int const & aav, // aa variant
								 FArray3DB_float const & xyz,
								 int const nres,
								 FArray2DB_bool const & neighborlist,
								 FArray1DB_int const & neighbors,
											bool const fullatom);
	
	
  //  friend class ConformerLibHandler;

};



#endif
