// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef LINEAR_MEMORY_INTERACTION_GRAPH_H
#define LINEAR_MEMORY_INTERACTION_GRAPH_H

#include "OnTheFlyInteractionGraph.h"

#include <ObjexxFCL/FArray3D.hh>

namespace pack {

class LinearMemNode;
class LinearMemEdge;
class LinearMemoryInteractionGraph;

struct history_queue_struct
{
	int more_recent_ptr;
	int state_in_rh;
	int more_ancient_ptr;
};

class LinearMemNode : public OnTheFlyNode
{
public:
	LinearMemNode(
		InteractionGraphBase * owner,
		int node_id,
		int num_states
	);

	virtual ~LinearMemNode();

	//virtual methods inherited from NodeBase
	virtual void prepare_for_simulated_annealing();
	virtual void print() const;
	virtual bool state_unassigned() const { return current_state_ == 0;}
	virtual float get_totalE() const { return curr_state_total_energy_;}

	void assign_zero_state();
	void assign_state(int new_state);
	void partial_assign_state( int new_state );
	void complete_state_assignment();

	inline
	int get_current_state() const
	{ return current_state_; }

	inline
	int get_curr_state_recent_state_id() const
	{ return head_of_rh_queue_ptr_; }


	inline
	float get_one_body_energy_current_state() const
	{ return curr_state_one_body_energy_; }

	inline
	float project_deltaE_for_substitution
	(
		int alternate_state,
		float & prev_node_energy
	);

	void commit_considered_substitution();
	void acknowledge_last_substititon_not_committed();
	float compute_pair_energy_for_current_state( int edge_making_energy_request );
	float compute_pair_energy_for_alternate_state( int edge_making_energy_request );

	inline
	void acknowledge_neighbors_state_substitution(
		int edge_to_altered_neighbor,
		float new_edge_energy,
		int other_node_new_state,
		SparseMatrixIndex const & other_node_new_state_sparse_info,
		int other_node_recent_history_index
	);

	void
	acknowledge_neighbors_partial_state_substitution(
		int edge_to_altered_neighbor,
		int other_node_new_state,
		SparseMatrixIndex const & other_node_new_state_sparse_info,
		int other_state_recent_history_index
	);

	inline
	SparseMatrixIndex const &
	get_sparse_mat_info_for_curr_state() const;

	void set_recent_history_size( int num_states_to_maintain_in_recent_history );
	int get_recent_history_size() const;

	void print_internal_energies();

	void update_internal_energy_sums();

	virtual unsigned int count_static_memory() const;
	virtual unsigned int count_dynamic_memory() const;

protected:

	inline
	rotamer_trie const &
	get_current_rotamer()
	{
		return get_rotamer( current_state_ );
	}

	inline
	float &
	get_curr_rotamer_actcoords();

	//Hooks for SASANode< V, E, G > class
	float get_curr_pd_energy_total() const { return curr_state_total_energy_;}
	float get_alt_pd_energy_total() const { return alternate_state_total_energy_;}
	void set_alternate_state( int alt ) { alternate_state_ = alt; }
	int get_alternate_state() const { return alternate_state_; }
	void calc_deltaEpd( int alternate_state );
	bool considering_alternate_state() const
	{
		return alternate_state_is_being_considered_;
	}


private:
	/*
	static
	float
	compute_rotamer_pair_energy(
		int rot1_aa,
		int rot2_aa,
		rotamer_trie const & rotamer1,
		rotamer_trie const & rotamer2,
		FArray1Da_float & rotamer1_actcoords,
		FArray1Da_float & rotamer2_actcoords
	);
	*/

	void update_internal_vectors();

	inline
	LinearMemEdge* get_incident_linmem_edge( int index ) const
	{
		return ( LinearMemEdge* ) get_incident_edge( index );  // c-style cast since static_cast won't compile
	}

	inline
	LinearMemNode* get_adjacent_linmem_node( int index ) const
	{
		return ( LinearMemNode* ) get_adjacent_node( index );  // c-style cast since static_cast won't compile
	}

	inline
	LinearMemoryInteractionGraph* get_linmem_ig_owner() const
	{
		return ( LinearMemoryInteractionGraph* ) get_owner(); // c-style cast since static_cast won't compile
	}

	int update_recent_history( int state );

	int num_states_to_keep_in_recent_history_;
	int curr_num_in_recent_history_;
	FArray1D< history_queue_struct > recent_history_queue_;
	int head_of_rh_queue_ptr_;
	int end_of_rh_queue_ptr_;
	FArray1D_int states_2_recent_history_;

	FArray3D< unsigned char > aa_neighbors_for_edges_;
	std::vector< int > neighbors_curr_state_;
	std::vector< int > neighbors_state_recent_history_index_;
	std::vector< SparseMatrixIndex > neighbors_curr_state_sparse_info_;

	int current_state_;
	SparseMatrixIndex curr_state_sparse_mat_info_;
	float curr_state_one_body_energy_;
	float curr_state_total_energy_;
	std::vector< float > curr_state_two_body_energies_;

	int alternate_state_;
	SparseMatrixIndex alt_state_sparse_mat_info_;
	float alternate_state_one_body_energy_;
	float alternate_state_total_energy_;
	std::vector< float > alternate_state_two_body_energies_;

	bool alternate_state_is_being_considered_;
	bool already_prepped_for_simA_;

	FArray1D_int accepted_rejected_substitution_history_;
	int accepted_history_head_;
	int num_recently_accepted_;
	bool filled_substitution_history_;

	static const int ACCEPTED = 1;
	static const int REJECTED = 0;

	static const int ACCEPTANCE_REJECTION_HISTORY_LENGTH = 100;
	static const int THRESHOLD_ACCEPTANCE_RATE_FOR_RPE_STORAGE = 10;
};

class LinearMemEdge : public OnTheFlyEdge
{
public:
	LinearMemEdge(
		InteractionGraphBase* owner,
		int first_node_ind,
		int second_node_ind
	);

	virtual ~LinearMemEdge();

	virtual
	void
	set_sparse_aa_info(
		FArray2DB_bool const &
	);

	//virtual methods inherited from EdgeBase
	virtual void prepare_for_simulated_annealing();

	float get_current_two_body_energy() const;

	void acknowledge_state_change(
		int node_ind,
		int new_state,
		SparseMatrixIndex const & new_state_sparse_info,
		int bumped_recent_history_index,
		int new_state_recent_history_index,
		float & new_energy
	);
	void acknowledge_state_zeroed( int node_ind );

	void acknowledge_partial_state_change(
		int node_ind,
		int new_state,
		SparseMatrixIndex const & new_state_sparse_info,
		int bumped_recent_history_index,
		int new_state_recent_history_index
	);

	float get_energy_following_partial_state_assignment();

	void reset_state_energies(
		int node_index,
		int state,
		int recent_history_id
	);

	inline
	float
	get_energy_for_alt_state
	(
		bool store_rpes,
		int changing_node_index,
		int alternate_state,
		int alternate_state_recent_history_index,
		int other_node_curr_state,
		int other_node_state_recent_history_index
	);

	inline
	void acknowledge_substitution(
		int substituted_node_index,
		float const curr_state_energy,
		int nodes_new_state,
		SparseMatrixIndex const & nodes_new_state_sparse_info,
		int bumped_recent_history_index,
		int new_state_recent_history_index,
		int neighbors_curr_state
	);

	int get_two_body_table_size() const;
	virtual void declare_energies_final();

	void print_current_energy() const;


	FArray2D< unsigned char > const & get_sparse_aa_neighbor_info( );
	FArray1D_int const & get_second_node_num_states_per_aa();

	static float const NOT_YET_COMPUTED_ENERGY; //an energy lower than any RPE could ever be

	virtual unsigned int count_static_memory() const;
	virtual unsigned int count_dynamic_memory() const;

protected:

	//Hooks for SASAEdge< V, E, G > class
	void declare_energies_final_no_deletion() { LinearMemEdge::prepare_for_simulated_annealing(); }
	void prepare_for_simulated_annealing_no_deletion() { LinearMemEdge::prepare_for_simulated_annealing(); }
	bool pd_edge_table_all_zeros() const { return false;}


private:

	inline
	LinearMemNode* get_linmem_node( int index ) const
	{
		return (LinearMemNode*) get_node( index ); //c-style cast since static_cast won't compile
	}

	inline
	LinearMemoryInteractionGraph* get_linmem_ig_owner() const
	{
		return (LinearMemoryInteractionGraph*) get_owner(); //c-style cast since static_cast won't compile
	}

	inline
	void
	handle_bumped_recent_history_state_for_node(
		int node_substituted,
		int node_not_substituted,
		int bumped_recent_history_index
	);

	void store_curr_state_energy();

	void wipe( int node );

	bool store_rpes_[ 2 ];
	FArray2D_float stored_rpes_[ 2 ];
	FArray2D< unsigned char > sparse_aa_neighbors_;
	float curr_state_energy_;
	float alt_state_energy_;
	bool partial_state_assignment_;
	bool preped_for_sim_annealing_;

		//no default constructor, uncopyable
	LinearMemEdge();
	LinearMemEdge( LinearMemEdge const & );
	LinearMemEdge & operator = ( LinearMemEdge const & );

};

class LinearMemoryInteractionGraph : public OnTheFlyInteractionGraph
{
public:
	LinearMemoryInteractionGraph( int numNodes );
	virtual ~LinearMemoryInteractionGraph();

	//virtual methods inherited from InteractionGraphBase
	virtual void  blanket_assign_state_0();
	virtual float set_state_for_node(int node_ind, int new_state);
	virtual float set_network_state( FArray1DB_int & node_states);
	virtual void consider_substitution(
		int node_ind,
		int new_state,
		float & delta_energy,
		float & prev_energy_for_node
	);
	virtual float  commit_considered_substitution();
	virtual float get_energy_current_state_assignment();
	virtual int get_edge_memory_usage() const;
	virtual void print_current_state_assignment() const;
	virtual void set_errorfull_deltaE_threshold( float deltaE );
	virtual float get_energy_sum_for_vertex_group( int group_id );
	virtual void prepare_for_simulated_annealing();

	bool build_sc_only_rotamer() const;

	virtual unsigned int count_static_memory() const;
	virtual unsigned int count_dynamic_memory() const;

protected:

	virtual NodeBase* create_new_node( int node_index, int num_states);
	virtual EdgeBase* create_new_edge( int index1, int index2);

	//Hooks for SASAInterationGraph< V, E, G >
	float get_energy_PD_current_state_assignment();
	void update_internal_energy_totals();

	inline
	LinearMemNode* get_linmem_node(int index) const
	{
		return (LinearMemNode*) get_node( index ); //c-style cast since static_cast won't compile
	}

private:
	void set_recent_history_sizes();
	static int get_cmdline_history_size();

	bool first_time_prepping_for_simA_;
	int num_aa_types_;
	int num_commits_since_last_update_;
	float total_energy_current_state_assignment_;
	float total_energy_alternate_state_assignment_;
	int node_considering_alt_state_;

	bool have_not_committed_last_substitution_;

	static const int COMMIT_LIMIT_BETWEEN_UPDATES = 1024; // 2^10

	//no default constructor, uncopyable
	LinearMemoryInteractionGraph();
	LinearMemoryInteractionGraph( LinearMemoryInteractionGraph const & );
	LinearMemoryInteractionGraph & operator = ( LinearMemoryInteractionGraph const & );
};

} //end namespace

#endif


