// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef ONE_GENE_TWO_PROTEINS_H
#define ONE_GENE_TWO_PROTEINS_H

// Rosetta Headers
#include "ParallelSimAnnealBase.h"

// forward declaration
class RotamerSet;

namespace pack{

  class OneGeneTwoProteins;

  class OneGeneTwoProteins :  public ParallelSimAnnealBase
    {
    public:
      OneGeneTwoProteins(
			const RotamerSet * p_rotamer_set,
			FArray2DB_bool & neighborlist,
			FArray1D_int & bestrotamer_at_seqpos,
			float & bestenergy,
			bool start_with_current, // start simulation with current rotamers
			InteractionGraphBase * ig,
			FArray1DB_int & current_rot_index,
			bool calc_rot_freq,
			FArray1D_float & rot_freq
			);

      virtual ~OneGeneTwoProteins();
      void run();

    protected:
      void check_that_only_pairs_of_equivalent_residues();
      void enforce_complementary_amino_acids_for_equivalent_sequence_positions();
      void create_a_random_sequence();
      void propogate_mutations_to_complementary_residues();

    private:
      // void initialize_CodonTable();
      OneGeneTwoProteins(const OneGeneTwoProteins& rhs);
  };

}//end of namespace

#endif
